/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStage;
import software.amazon.awssdk.services.bedrockdataautomation.model.KmsEncryptionContextCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Blueprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Blueprint> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(Blueprint.getter(Blueprint::blueprintArn)).setter(Blueprint.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(Blueprint.getter(Blueprint::schema)).setter(Blueprint.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Blueprint.getter(Blueprint::typeAsString)).setter(Blueprint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Blueprint.getter(Blueprint::creationTime)).setter(Blueprint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(Blueprint.getter(Blueprint::lastModifiedTime)).setter(Blueprint.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintName").getter(Blueprint.getter(Blueprint::blueprintName)).setter(Blueprint.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()}).build();
    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintVersion").getter(Blueprint.getter(Blueprint::blueprintVersion)).setter(Blueprint.setter(Builder::blueprintVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()}).build();
    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintStage").getter(Blueprint.getter(Blueprint::blueprintStageAsString)).setter(Blueprint.setter(Builder::blueprintStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Blueprint.getter(Blueprint::kmsKeyId)).setter(Blueprint.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("kmsEncryptionContext").getter(Blueprint.getter(Blueprint::kmsEncryptionContext)).setter(Blueprint.setter(Builder::kmsEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, SCHEMA_FIELD, TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, BLUEPRINT_NAME_FIELD, BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD, KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Blueprint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String blueprintArn;
    private final String schema;
    private final String type;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String blueprintName;
    private final String blueprintVersion;
    private final String blueprintStage;
    private final String kmsKeyId;
    private final Map<String, String> kmsEncryptionContext;

    private Blueprint(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.schema = builder.schema;
        this.type = builder.type;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.blueprintName = builder.blueprintName;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final String schema() {
        return this.schema;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String blueprintVersion() {
        return this.blueprintVersion;
    }

    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(this.blueprintStage);
    }

    public final String blueprintStageAsString() {
        return this.blueprintStage;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasKmsEncryptionContext() {
        return this.kmsEncryptionContext != null && !(this.kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> kmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.blueprintVersion(), other.blueprintVersion()) && Objects.equals(this.blueprintStageAsString(), other.blueprintStageAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasKmsEncryptionContext() == other.hasKmsEncryptionContext() && Objects.equals(this.kmsEncryptionContext(), other.kmsEncryptionContext());
    }

    public final String toString() {
        return ToString.builder((String)"Blueprint").add("BlueprintArn", (Object)this.blueprintArn()).add("Schema", (Object)(this.schema() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("BlueprintName", (Object)(this.blueprintName() == null ? null : "*** Sensitive Data Redacted ***")).add("BlueprintVersion", (Object)this.blueprintVersion()).add("BlueprintStage", (Object)this.blueprintStageAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).add("KmsEncryptionContext", this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "blueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "blueprintVersion": {
                return Optional.ofNullable(clazz.cast(this.blueprintVersion()));
            }
            case "blueprintStage": {
                return Optional.ofNullable(clazz.cast(this.blueprintStageAsString()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "kmsEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("blueprintName", BLUEPRINT_NAME_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("kmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String schema;
        private String type;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String blueprintName;
        private String blueprintVersion;
        private String blueprintStage;
        private String kmsKeyId;
        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            this.blueprintArn(model.blueprintArn);
            this.schema(model.schema);
            this.type(model.type);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.blueprintName(model.blueprintName);
            this.blueprintVersion(model.blueprintVersion);
            this.blueprintStage(model.blueprintStage);
            this.kmsKeyId(model.kmsKeyId);
            this.kmsEncryptionContext(model.kmsEncryptionContext);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getBlueprintVersion() {
            return this.blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return this.blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (this.kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
            return this;
        }

        public Blueprint build() {
            return new Blueprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Blueprint> {
        public Builder blueprintArn(String var1);

        public Builder schema(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder blueprintName(String var1);

        public Builder blueprintVersion(String var1);

        public Builder blueprintStage(String var1);

        public Builder blueprintStage(BlueprintStage var1);

        public Builder kmsKeyId(String var1);

        public Builder kmsEncryptionContext(Map<String, String> var1);
    }
}

