/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockdataautomation.BedrockDataAutomationAsyncClient;
import software.amazon.awssdk.services.bedrockdataautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse;

public class ListDataAutomationProjectsPublisher
implements SdkPublisher<ListDataAutomationProjectsResponse> {
    private final BedrockDataAutomationAsyncClient client;
    private final ListDataAutomationProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataAutomationProjectsPublisher(BedrockDataAutomationAsyncClient client, ListDataAutomationProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataAutomationProjectsPublisher(BedrockDataAutomationAsyncClient client, ListDataAutomationProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataAutomationProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataAutomationProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataAutomationProjectSummary> projects() {
        Function<ListDataAutomationProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataAutomationProjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataAutomationProjectsResponseFetcher
    implements AsyncPageFetcher<ListDataAutomationProjectsResponse> {
        private ListDataAutomationProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataAutomationProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataAutomationProjectsResponse> nextPage(ListDataAutomationProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListDataAutomationProjectsPublisher.this.client.listDataAutomationProjects(ListDataAutomationProjectsPublisher.this.firstRequest);
            }
            return ListDataAutomationProjectsPublisher.this.client.listDataAutomationProjects((ListDataAutomationProjectsRequest)((Object)ListDataAutomationProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

