/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSegment> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(VideoSegment.getter(VideoSegment::s3Uri)).setter(VideoSegment.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(VideoSegment.getter(VideoSegment::summary)).setter(VideoSegment.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String summary;

    private VideoSegment(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.summary = builder.summary;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSegment)) {
            return false;
        }
        VideoSegment other = (VideoSegment)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"VideoSegment").add("S3Uri", (Object)this.s3Uri()).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSegment, T> g) {
        return obj -> g.apply((VideoSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String summary;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSegment model) {
            this.s3Uri(model.s3Uri);
            this.summary(model.summary);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public VideoSegment build() {
            return new VideoSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSegment> {
        public Builder s3Uri(String var1);

        public Builder summary(String var1);
    }
}

