/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.InputImage;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseQueryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseQuery> {
    private static final SdkField<InputImage> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(KnowledgeBaseQuery.getter(KnowledgeBaseQuery::image)).setter(KnowledgeBaseQuery.setter(Builder::image)).constructor(InputImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(KnowledgeBaseQuery.getter(KnowledgeBaseQuery::text)).setter(KnowledgeBaseQuery.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(KnowledgeBaseQuery.getter(KnowledgeBaseQuery::typeAsString)).setter(KnowledgeBaseQuery.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, TEXT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InputImage image;
    private final String text;
    private final String type;

    private KnowledgeBaseQuery(BuilderImpl builder) {
        this.image = builder.image;
        this.text = builder.text;
        this.type = builder.type;
    }

    public final InputImage image() {
        return this.image;
    }

    public final String text() {
        return this.text;
    }

    public final KnowledgeBaseQueryType type() {
        return KnowledgeBaseQueryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseQuery)) {
            return false;
        }
        KnowledgeBaseQuery other = (KnowledgeBaseQuery)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseQuery").add("Image", (Object)this.image()).add("Text", (Object)this.text()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("image", IMAGE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseQuery, T> g) {
        return obj -> g.apply((KnowledgeBaseQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InputImage image;
        private String text;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseQuery model) {
            this.image(model.image);
            this.text(model.text);
            this.type(model.type);
        }

        public final InputImage.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(InputImage.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(InputImage image) {
            this.image = image;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseQueryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public KnowledgeBaseQuery build() {
            return new KnowledgeBaseQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseQuery> {
        public Builder image(InputImage var1);

        default public Builder image(Consumer<InputImage.Builder> image) {
            return this.image((InputImage)((InputImage.Builder)InputImage.builder().applyMutation(image)).build());
        }

        public Builder text(String var1);

        public Builder type(String var1);

        public Builder type(KnowledgeBaseQueryType var1);
    }
}

