/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopFlowExecutionResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<StopFlowExecutionResponse.Builder, StopFlowExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(StopFlowExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StopFlowExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionArn;

    private final String status;

    private StopFlowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the flow execution that was stopped.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the flow execution that was stopped.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The updated status of the flow execution after the stop request. This will typically be ABORTED if the execution
     * was successfully stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The updated status of the flow execution after the stop request. This will typically be ABORTED if the
     *         execution was successfully stopped.
     * @see FlowExecutionStatus
     */
    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The updated status of the flow execution after the stop request. This will typically be ABORTED if the execution
     * was successfully stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The updated status of the flow execution after the stop request. This will typically be ABORTED if the
     *         execution was successfully stopped.
     * @see FlowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopFlowExecutionResponse)) {
            return false;
        }
        StopFlowExecutionResponse other = (StopFlowExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopFlowExecutionResponse").add("ExecutionArn", executionArn()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopFlowExecutionResponse, T> g) {
        return obj -> g.apply((StopFlowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopFlowExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the flow execution that was stopped.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the flow execution that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The updated status of the flow execution after the stop request. This will typically be ABORTED if the
         * execution was successfully stopped.
         * </p>
         * 
         * @param status
         *        The updated status of the flow execution after the stop request. This will typically be ABORTED if the
         *        execution was successfully stopped.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The updated status of the flow execution after the stop request. This will typically be ABORTED if the
         * execution was successfully stopped.
         * </p>
         * 
         * @param status
         *        The updated status of the flow execution after the stop request. This will typically be ABORTED if the
         *        execution was successfully stopped.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(FlowExecutionStatus status);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String executionArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StopFlowExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            status(model.status);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StopFlowExecutionResponse build() {
            return new StopFlowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
