/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about where the text with a citation begins and ends in the generated output.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>span</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>span</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Span implements SdkPojo, Serializable, ToCopyableBuilder<Span.Builder, Span> {
    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("end")
            .getter(getter(Span::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<Integer> START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("start")
            .getter(getter(Span::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_FIELD, START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer end;

    private final Integer start;

    private Span(BuilderImpl builder) {
        this.end = builder.end;
        this.start = builder.start;
    }

    /**
     * <p>
     * Where the text with a citation ends in the generated output.
     * </p>
     * 
     * @return Where the text with a citation ends in the generated output.
     */
    public final Integer end() {
        return end;
    }

    /**
     * <p>
     * Where the text with a citation starts in the generated output.
     * </p>
     * 
     * @return Where the text with a citation starts in the generated output.
     */
    public final Integer start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Span)) {
            return false;
        }
        Span other = (Span) obj;
        return Objects.equals(end(), other.end()) && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Span").add("End", end()).add("Start", start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("end", END_FIELD);
        map.put("start", START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Span, T> g) {
        return obj -> g.apply((Span) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Span> {
        /**
         * <p>
         * Where the text with a citation ends in the generated output.
         * </p>
         * 
         * @param end
         *        Where the text with a citation ends in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);

        /**
         * <p>
         * Where the text with a citation starts in the generated output.
         * </p>
         * 
         * @param start
         *        Where the text with a citation starts in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Integer start);
    }

    static final class BuilderImpl implements Builder {
        private Integer end;

        private Integer start;

        private BuilderImpl() {
        }

        private BuilderImpl(Span model) {
            end(model.end);
            start(model.start);
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        public final Integer getStart() {
            return start;
        }

        public final void setStart(Integer start) {
            this.start = start;
        }

        @Override
        public final Builder start(Integer start) {
            this.start = start;
            return this;
        }

        @Override
        public Span build() {
            return new Span(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
