/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the optimized prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizedPrompt implements SdkPojo, Serializable, ToCopyableBuilder<OptimizedPrompt.Builder, OptimizedPrompt> {
    private static final SdkField<TextPrompt> TEXT_PROMPT_FIELD = SdkField.<TextPrompt> builder(MarshallingType.SDK_POJO)
            .memberName("textPrompt").getter(getter(OptimizedPrompt::textPrompt)).setter(setter(Builder::textPrompt))
            .constructor(TextPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextPrompt textPrompt;

    private final Type type;

    private OptimizedPrompt(BuilderImpl builder) {
        this.textPrompt = builder.textPrompt;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about the text in the prompt that was optimized.
     * </p>
     * 
     * @return Contains information about the text in the prompt that was optimized.
     */
    public final TextPrompt textPrompt() {
        return textPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizedPrompt)) {
            return false;
        }
        OptimizedPrompt other = (OptimizedPrompt) obj;
        return Objects.equals(textPrompt(), other.textPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizedPrompt")
                .add("TextPrompt", textPrompt() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textPrompt":
            return Optional.ofNullable(clazz.cast(textPrompt()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #textPrompt()} initialized to the given value.
     *
     * <p>
     * Contains information about the text in the prompt that was optimized.
     * </p>
     * 
     * @param textPrompt
     *        Contains information about the text in the prompt that was optimized.
     */
    public static OptimizedPrompt fromTextPrompt(TextPrompt textPrompt) {
        return builder().textPrompt(textPrompt).build();
    }

    /**
     * Create an instance of this class with {@link #textPrompt()} initialized to the given value.
     *
     * <p>
     * Contains information about the text in the prompt that was optimized.
     * </p>
     * 
     * @param textPrompt
     *        Contains information about the text in the prompt that was optimized.
     */
    public static OptimizedPrompt fromTextPrompt(Consumer<TextPrompt.Builder> textPrompt) {
        TextPrompt.Builder builder = TextPrompt.builder();
        textPrompt.accept(builder);
        return fromTextPrompt(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textPrompt", TEXT_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizedPrompt, T> g) {
        return obj -> g.apply((OptimizedPrompt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizedPrompt> {
        /**
         * <p>
         * Contains information about the text in the prompt that was optimized.
         * </p>
         * 
         * @param textPrompt
         *        Contains information about the text in the prompt that was optimized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPrompt(TextPrompt textPrompt);

        /**
         * <p>
         * Contains information about the text in the prompt that was optimized.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextPrompt.Builder} avoiding the need to
         * create one manually via {@link TextPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextPrompt.Builder#build()} is called immediately and its result
         * is passed to {@link #textPrompt(TextPrompt)}.
         * 
         * @param textPrompt
         *        a consumer that will call methods on {@link TextPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textPrompt(TextPrompt)
         */
        default Builder textPrompt(Consumer<TextPrompt.Builder> textPrompt) {
            return textPrompt(TextPrompt.builder().applyMutation(textPrompt).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextPrompt textPrompt;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizedPrompt model) {
            textPrompt(model.textPrompt);
        }

        public final TextPrompt.Builder getTextPrompt() {
            return textPrompt != null ? textPrompt.toBuilder() : null;
        }

        public final void setTextPrompt(TextPrompt.BuilderImpl textPrompt) {
            Object oldValue = this.textPrompt;
            this.textPrompt = textPrompt != null ? textPrompt.build() : null;
            handleUnionValueChange(Type.TEXT_PROMPT, oldValue, this.textPrompt);
        }

        @Override
        public final Builder textPrompt(TextPrompt textPrompt) {
            Object oldValue = this.textPrompt;
            this.textPrompt = textPrompt;
            handleUnionValueChange(Type.TEXT_PROMPT, oldValue, this.textPrompt);
            return this;
        }

        @Override
        public OptimizedPrompt build() {
            return new OptimizedPrompt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OptimizedPrompt#type()
     */
    public enum Type {
        TEXT_PROMPT,

        UNKNOWN_TO_SDK_VERSION
    }
}
