/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of a session summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemorySessionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MemorySessionSummary.Builder, MemorySessionSummary> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(MemorySessionSummary::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()).build();

    private static final SdkField<Instant> SESSION_EXPIRY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("sessionExpiryTime")
            .getter(getter(MemorySessionSummary::sessionExpiryTime))
            .setter(setter(Builder::sessionExpiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionExpiryTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(MemorySessionSummary::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> SESSION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("sessionStartTime")
            .getter(getter(MemorySessionSummary::sessionStartTime))
            .setter(setter(Builder::sessionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SUMMARY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("summaryText").getter(getter(MemorySessionSummary::summaryText)).setter(setter(Builder::summaryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD,
            SESSION_EXPIRY_TIME_FIELD, SESSION_ID_FIELD, SESSION_START_TIME_FIELD, SUMMARY_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String memoryId;

    private final Instant sessionExpiryTime;

    private final String sessionId;

    private final Instant sessionStartTime;

    private final String summaryText;

    private MemorySessionSummary(BuilderImpl builder) {
        this.memoryId = builder.memoryId;
        this.sessionExpiryTime = builder.sessionExpiryTime;
        this.sessionId = builder.sessionId;
        this.sessionStartTime = builder.sessionStartTime;
        this.summaryText = builder.summaryText;
    }

    /**
     * <p>
     * The unique identifier of the memory where the session summary is stored.
     * </p>
     * 
     * @return The unique identifier of the memory where the session summary is stored.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The time when the memory duration for the session is set to end.
     * </p>
     * 
     * @return The time when the memory duration for the session is set to end.
     */
    public final Instant sessionExpiryTime() {
        return sessionExpiryTime;
    }

    /**
     * <p>
     * The identifier for this session.
     * </p>
     * 
     * @return The identifier for this session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The start time for this session.
     * </p>
     * 
     * @return The start time for this session.
     */
    public final Instant sessionStartTime() {
        return sessionStartTime;
    }

    /**
     * <p>
     * The summarized text for this session.
     * </p>
     * 
     * @return The summarized text for this session.
     */
    public final String summaryText() {
        return summaryText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(summaryText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemorySessionSummary)) {
            return false;
        }
        MemorySessionSummary other = (MemorySessionSummary) obj;
        return Objects.equals(memoryId(), other.memoryId()) && Objects.equals(sessionExpiryTime(), other.sessionExpiryTime())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionStartTime(), other.sessionStartTime())
                && Objects.equals(summaryText(), other.summaryText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemorySessionSummary").add("MemoryId", memoryId()).add("SessionExpiryTime", sessionExpiryTime())
                .add("SessionId", sessionId()).add("SessionStartTime", sessionStartTime()).add("SummaryText", summaryText())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "sessionExpiryTime":
            return Optional.ofNullable(clazz.cast(sessionExpiryTime()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionStartTime":
            return Optional.ofNullable(clazz.cast(sessionStartTime()));
        case "summaryText":
            return Optional.ofNullable(clazz.cast(summaryText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("sessionExpiryTime", SESSION_EXPIRY_TIME_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionStartTime", SESSION_START_TIME_FIELD);
        map.put("summaryText", SUMMARY_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemorySessionSummary, T> g) {
        return obj -> g.apply((MemorySessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemorySessionSummary> {
        /**
         * <p>
         * The unique identifier of the memory where the session summary is stored.
         * </p>
         * 
         * @param memoryId
         *        The unique identifier of the memory where the session summary is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The time when the memory duration for the session is set to end.
         * </p>
         * 
         * @param sessionExpiryTime
         *        The time when the memory duration for the session is set to end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpiryTime(Instant sessionExpiryTime);

        /**
         * <p>
         * The identifier for this session.
         * </p>
         * 
         * @param sessionId
         *        The identifier for this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The start time for this session.
         * </p>
         * 
         * @param sessionStartTime
         *        The start time for this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionStartTime(Instant sessionStartTime);

        /**
         * <p>
         * The summarized text for this session.
         * </p>
         * 
         * @param summaryText
         *        The summarized text for this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryText(String summaryText);
    }

    static final class BuilderImpl implements Builder {
        private String memoryId;

        private Instant sessionExpiryTime;

        private String sessionId;

        private Instant sessionStartTime;

        private String summaryText;

        private BuilderImpl() {
        }

        private BuilderImpl(MemorySessionSummary model) {
            memoryId(model.memoryId);
            sessionExpiryTime(model.sessionExpiryTime);
            sessionId(model.sessionId);
            sessionStartTime(model.sessionStartTime);
            summaryText(model.summaryText);
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final Instant getSessionExpiryTime() {
            return sessionExpiryTime;
        }

        public final void setSessionExpiryTime(Instant sessionExpiryTime) {
            this.sessionExpiryTime = sessionExpiryTime;
        }

        @Override
        public final Builder sessionExpiryTime(Instant sessionExpiryTime) {
            this.sessionExpiryTime = sessionExpiryTime;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getSessionStartTime() {
            return sessionStartTime;
        }

        public final void setSessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
        }

        @Override
        public final Builder sessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public final String getSummaryText() {
            return summaryText;
        }

        public final void setSummaryText(String summaryText) {
            this.summaryText = summaryText;
        }

        @Override
        public final Builder summaryText(String summaryText) {
            this.summaryText = summaryText;
            return this;
        }

        @Override
        public MemorySessionSummary build() {
            return new MemorySessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
