/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlowExecutionEventsResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<ListFlowExecutionEventsResponse.Builder, ListFlowExecutionEventsResponse> {
    private static final SdkField<List<FlowExecutionEvent>> FLOW_EXECUTION_EVENTS_FIELD = SdkField
            .<List<FlowExecutionEvent>> builder(MarshallingType.LIST)
            .memberName("flowExecutionEvents")
            .getter(getter(ListFlowExecutionEventsResponse::flowExecutionEvents))
            .setter(setter(Builder::flowExecutionEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowExecutionEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowExecutionEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFlowExecutionEventsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTION_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FlowExecutionEvent> flowExecutionEvents;

    private final String nextToken;

    private ListFlowExecutionEventsResponse(BuilderImpl builder) {
        super(builder);
        this.flowExecutionEvents = builder.flowExecutionEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlowExecutionEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlowExecutionEvents() {
        return flowExecutionEvents != null && !(flowExecutionEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events that occurred during the flow execution. Events can include node inputs and outputs, flow inputs
     * and outputs, condition results, and failure events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlowExecutionEvents} method.
     * </p>
     * 
     * @return A list of events that occurred during the flow execution. Events can include node inputs and outputs,
     *         flow inputs and outputs, condition results, and failure events.
     */
    public final List<FlowExecutionEvent> flowExecutionEvents() {
        return flowExecutionEvents;
    }

    /**
     * <p>
     * A token to retrieve the next set of results. This value is returned if more results are available.
     * </p>
     * 
     * @return A token to retrieve the next set of results. This value is returned if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFlowExecutionEvents() ? flowExecutionEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionEventsResponse)) {
            return false;
        }
        ListFlowExecutionEventsResponse other = (ListFlowExecutionEventsResponse) obj;
        return hasFlowExecutionEvents() == other.hasFlowExecutionEvents()
                && Objects.equals(flowExecutionEvents(), other.flowExecutionEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFlowExecutionEventsResponse")
                .add("FlowExecutionEvents", hasFlowExecutionEvents() ? flowExecutionEvents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowExecutionEvents":
            return Optional.ofNullable(clazz.cast(flowExecutionEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowExecutionEvents", FLOW_EXECUTION_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionEventsResponse, T> g) {
        return obj -> g.apply((ListFlowExecutionEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFlowExecutionEventsResponse> {
        /**
         * <p>
         * A list of events that occurred during the flow execution. Events can include node inputs and outputs, flow
         * inputs and outputs, condition results, and failure events.
         * </p>
         * 
         * @param flowExecutionEvents
         *        A list of events that occurred during the flow execution. Events can include node inputs and outputs,
         *        flow inputs and outputs, condition results, and failure events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutionEvents(Collection<FlowExecutionEvent> flowExecutionEvents);

        /**
         * <p>
         * A list of events that occurred during the flow execution. Events can include node inputs and outputs, flow
         * inputs and outputs, condition results, and failure events.
         * </p>
         * 
         * @param flowExecutionEvents
         *        A list of events that occurred during the flow execution. Events can include node inputs and outputs,
         *        flow inputs and outputs, condition results, and failure events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutionEvents(FlowExecutionEvent... flowExecutionEvents);

        /**
         * <p>
         * A list of events that occurred during the flow execution. Events can include node inputs and outputs, flow
         * inputs and outputs, condition results, and failure events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent.Builder#build()} is
         * called immediately and its result is passed to {@link #flowExecutionEvents(List<FlowExecutionEvent>)}.
         * 
         * @param flowExecutionEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowExecutionEvents(java.util.Collection<FlowExecutionEvent>)
         */
        Builder flowExecutionEvents(Consumer<FlowExecutionEvent.Builder>... flowExecutionEvents);

        /**
         * <p>
         * A token to retrieve the next set of results. This value is returned if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results. This value is returned if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private List<FlowExecutionEvent> flowExecutionEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionEventsResponse model) {
            super(model);
            flowExecutionEvents(model.flowExecutionEvents);
            nextToken(model.nextToken);
        }

        public final List<FlowExecutionEvent.Builder> getFlowExecutionEvents() {
            List<FlowExecutionEvent.Builder> result = FlowExecutionEventsCopier.copyToBuilder(this.flowExecutionEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowExecutionEvents(Collection<FlowExecutionEvent.BuilderImpl> flowExecutionEvents) {
            this.flowExecutionEvents = FlowExecutionEventsCopier.copyFromBuilder(flowExecutionEvents);
        }

        @Override
        public final Builder flowExecutionEvents(Collection<FlowExecutionEvent> flowExecutionEvents) {
            this.flowExecutionEvents = FlowExecutionEventsCopier.copy(flowExecutionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionEvents(FlowExecutionEvent... flowExecutionEvents) {
            flowExecutionEvents(Arrays.asList(flowExecutionEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionEvents(Consumer<FlowExecutionEvent.Builder>... flowExecutionEvents) {
            flowExecutionEvents(Stream.of(flowExecutionEvents).map(c -> FlowExecutionEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowExecutionEventsResponse build() {
            return new ListFlowExecutionEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
