/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a failure that occurred at the flow level during a flow execution.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowFailureEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowFailureEvent.Builder, FlowFailureEvent> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(FlowFailureEvent::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FlowFailureEvent::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(FlowFailureEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final Instant timestamp;

    private FlowFailureEvent(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The error code that identifies the type of failure that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link FlowErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code that identifies the type of failure that occurred.
     * @see FlowErrorCode
     */
    public final FlowErrorCode errorCode() {
        return FlowErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code that identifies the type of failure that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link FlowErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code that identifies the type of failure that occurred.
     * @see FlowErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * A descriptive message that provides details about the failure.
     * </p>
     * 
     * @return A descriptive message that provides details about the failure.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp when the failure occurred.
     * </p>
     * 
     * @return The timestamp when the failure occurred.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowFailureEvent)) {
            return false;
        }
        FlowFailureEvent other = (FlowFailureEvent) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowFailureEvent").add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowFailureEvent, T> g) {
        return obj -> g.apply((FlowFailureEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowFailureEvent> {
        /**
         * <p>
         * The error code that identifies the type of failure that occurred.
         * </p>
         * 
         * @param errorCode
         *        The error code that identifies the type of failure that occurred.
         * @see FlowErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code that identifies the type of failure that occurred.
         * </p>
         * 
         * @param errorCode
         *        The error code that identifies the type of failure that occurred.
         * @see FlowErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowErrorCode
         */
        Builder errorCode(FlowErrorCode errorCode);

        /**
         * <p>
         * A descriptive message that provides details about the failure.
         * </p>
         * 
         * @param errorMessage
         *        A descriptive message that provides details about the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp when the failure occurred.
         * </p>
         * 
         * @param timestamp
         *        The timestamp when the failure occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowFailureEvent model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            timestamp(model.timestamp);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(FlowErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public FlowFailureEvent build() {
            return new FlowFailureEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
