/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an event that occurred during an flow execution. This is a union type that can contain one of several
 * event types, such as node input and output events; flow input and output events; condition node result events, or
 * failure events.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowExecutionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowExecutionEvent.Builder, FlowExecutionEvent> {
    private static final SdkField<ConditionResultEvent> CONDITION_RESULT_EVENT_FIELD = SdkField
            .<ConditionResultEvent> builder(MarshallingType.SDK_POJO).memberName("conditionResultEvent")
            .getter(getter(FlowExecutionEvent::conditionResultEvent)).setter(setter(Builder::conditionResultEvent))
            .constructor(ConditionResultEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionResultEvent").build())
            .build();

    private static final SdkField<FlowFailureEvent> FLOW_FAILURE_EVENT_FIELD = SdkField
            .<FlowFailureEvent> builder(MarshallingType.SDK_POJO).memberName("flowFailureEvent")
            .getter(getter(FlowExecutionEvent::flowFailureEvent)).setter(setter(Builder::flowFailureEvent))
            .constructor(FlowFailureEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowFailureEvent").build()).build();

    private static final SdkField<FlowExecutionInputEvent> FLOW_INPUT_EVENT_FIELD = SdkField
            .<FlowExecutionInputEvent> builder(MarshallingType.SDK_POJO).memberName("flowInputEvent")
            .getter(getter(FlowExecutionEvent::flowInputEvent)).setter(setter(Builder::flowInputEvent))
            .constructor(FlowExecutionInputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowInputEvent").build()).build();

    private static final SdkField<FlowExecutionOutputEvent> FLOW_OUTPUT_EVENT_FIELD = SdkField
            .<FlowExecutionOutputEvent> builder(MarshallingType.SDK_POJO).memberName("flowOutputEvent")
            .getter(getter(FlowExecutionEvent::flowOutputEvent)).setter(setter(Builder::flowOutputEvent))
            .constructor(FlowExecutionOutputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutputEvent").build()).build();

    private static final SdkField<NodeActionEvent> NODE_ACTION_EVENT_FIELD = SdkField
            .<NodeActionEvent> builder(MarshallingType.SDK_POJO).memberName("nodeActionEvent")
            .getter(getter(FlowExecutionEvent::nodeActionEvent)).setter(setter(Builder::nodeActionEvent))
            .constructor(NodeActionEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeActionEvent").build()).build();

    private static final SdkField<NodeDependencyEvent> NODE_DEPENDENCY_EVENT_FIELD = SdkField
            .<NodeDependencyEvent> builder(MarshallingType.SDK_POJO).memberName("nodeDependencyEvent")
            .getter(getter(FlowExecutionEvent::nodeDependencyEvent)).setter(setter(Builder::nodeDependencyEvent))
            .constructor(NodeDependencyEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeDependencyEvent").build())
            .build();

    private static final SdkField<NodeFailureEvent> NODE_FAILURE_EVENT_FIELD = SdkField
            .<NodeFailureEvent> builder(MarshallingType.SDK_POJO).memberName("nodeFailureEvent")
            .getter(getter(FlowExecutionEvent::nodeFailureEvent)).setter(setter(Builder::nodeFailureEvent))
            .constructor(NodeFailureEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeFailureEvent").build()).build();

    private static final SdkField<NodeInputEvent> NODE_INPUT_EVENT_FIELD = SdkField
            .<NodeInputEvent> builder(MarshallingType.SDK_POJO).memberName("nodeInputEvent")
            .getter(getter(FlowExecutionEvent::nodeInputEvent)).setter(setter(Builder::nodeInputEvent))
            .constructor(NodeInputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputEvent").build()).build();

    private static final SdkField<NodeOutputEvent> NODE_OUTPUT_EVENT_FIELD = SdkField
            .<NodeOutputEvent> builder(MarshallingType.SDK_POJO).memberName("nodeOutputEvent")
            .getter(getter(FlowExecutionEvent::nodeOutputEvent)).setter(setter(Builder::nodeOutputEvent))
            .constructor(NodeOutputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_RESULT_EVENT_FIELD,
            FLOW_FAILURE_EVENT_FIELD, FLOW_INPUT_EVENT_FIELD, FLOW_OUTPUT_EVENT_FIELD, NODE_ACTION_EVENT_FIELD,
            NODE_DEPENDENCY_EVENT_FIELD, NODE_FAILURE_EVENT_FIELD, NODE_INPUT_EVENT_FIELD, NODE_OUTPUT_EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionResultEvent conditionResultEvent;

    private final FlowFailureEvent flowFailureEvent;

    private final FlowExecutionInputEvent flowInputEvent;

    private final FlowExecutionOutputEvent flowOutputEvent;

    private final NodeActionEvent nodeActionEvent;

    private final NodeDependencyEvent nodeDependencyEvent;

    private final NodeFailureEvent nodeFailureEvent;

    private final NodeInputEvent nodeInputEvent;

    private final NodeOutputEvent nodeOutputEvent;

    private final Type type;

    private FlowExecutionEvent(BuilderImpl builder) {
        this.conditionResultEvent = builder.conditionResultEvent;
        this.flowFailureEvent = builder.flowFailureEvent;
        this.flowInputEvent = builder.flowInputEvent;
        this.flowOutputEvent = builder.flowOutputEvent;
        this.nodeActionEvent = builder.nodeActionEvent;
        this.nodeDependencyEvent = builder.nodeDependencyEvent;
        this.nodeFailureEvent = builder.nodeFailureEvent;
        this.nodeInputEvent = builder.nodeInputEvent;
        this.nodeOutputEvent = builder.nodeOutputEvent;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about a condition evaluation result during the flow execution. This event is generated when
     * a condition node in the flow evaluates its conditions.
     * </p>
     * 
     * @return Contains information about a condition evaluation result during the flow execution. This event is
     *         generated when a condition node in the flow evaluates its conditions.
     */
    public final ConditionResultEvent conditionResultEvent() {
        return conditionResultEvent;
    }

    /**
     * <p>
     * Contains information about a failure that occurred at the flow level during execution.
     * </p>
     * 
     * @return Contains information about a failure that occurred at the flow level during execution.
     */
    public final FlowFailureEvent flowFailureEvent() {
        return flowFailureEvent;
    }

    /**
     * <p>
     * Contains information about the inputs provided to the flow at the start of execution.
     * </p>
     * 
     * @return Contains information about the inputs provided to the flow at the start of execution.
     */
    public final FlowExecutionInputEvent flowInputEvent() {
        return flowInputEvent;
    }

    /**
     * <p>
     * Contains information about the outputs produced by the flow at the end of execution.
     * </p>
     * 
     * @return Contains information about the outputs produced by the flow at the end of execution.
     */
    public final FlowExecutionOutputEvent flowOutputEvent() {
        return flowOutputEvent;
    }

    /**
     * <p>
     * Contains information about an action (operation) called by a node during execution.
     * </p>
     * 
     * @return Contains information about an action (operation) called by a node during execution.
     */
    public final NodeActionEvent nodeActionEvent() {
        return nodeActionEvent;
    }

    /**
     * <p>
     * Contains information about an internal trace of a specific node during execution.
     * </p>
     * 
     * @return Contains information about an internal trace of a specific node during execution.
     */
    public final NodeDependencyEvent nodeDependencyEvent() {
        return nodeDependencyEvent;
    }

    /**
     * <p>
     * Contains information about a failure that occurred at a specific node during execution.
     * </p>
     * 
     * @return Contains information about a failure that occurred at a specific node during execution.
     */
    public final NodeFailureEvent nodeFailureEvent() {
        return nodeFailureEvent;
    }

    /**
     * <p>
     * Contains information about the inputs provided to a specific node during execution.
     * </p>
     * 
     * @return Contains information about the inputs provided to a specific node during execution.
     */
    public final NodeInputEvent nodeInputEvent() {
        return nodeInputEvent;
    }

    /**
     * <p>
     * Contains information about the outputs produced by a specific node during execution.
     * </p>
     * 
     * @return Contains information about the outputs produced by a specific node during execution.
     */
    public final NodeOutputEvent nodeOutputEvent() {
        return nodeOutputEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionResultEvent());
        hashCode = 31 * hashCode + Objects.hashCode(flowFailureEvent());
        hashCode = 31 * hashCode + Objects.hashCode(flowInputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(flowOutputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(nodeActionEvent());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDependencyEvent());
        hashCode = 31 * hashCode + Objects.hashCode(nodeFailureEvent());
        hashCode = 31 * hashCode + Objects.hashCode(nodeInputEvent());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionEvent)) {
            return false;
        }
        FlowExecutionEvent other = (FlowExecutionEvent) obj;
        return Objects.equals(conditionResultEvent(), other.conditionResultEvent())
                && Objects.equals(flowFailureEvent(), other.flowFailureEvent())
                && Objects.equals(flowInputEvent(), other.flowInputEvent())
                && Objects.equals(flowOutputEvent(), other.flowOutputEvent())
                && Objects.equals(nodeActionEvent(), other.nodeActionEvent())
                && Objects.equals(nodeDependencyEvent(), other.nodeDependencyEvent())
                && Objects.equals(nodeFailureEvent(), other.nodeFailureEvent())
                && Objects.equals(nodeInputEvent(), other.nodeInputEvent())
                && Objects.equals(nodeOutputEvent(), other.nodeOutputEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowExecutionEvent")
                .add("ConditionResultEvent", conditionResultEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FlowFailureEvent", flowFailureEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FlowInputEvent", flowInputEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FlowOutputEvent", flowOutputEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeActionEvent", nodeActionEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeDependencyEvent", nodeDependencyEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeFailureEvent", nodeFailureEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeInputEvent", nodeInputEvent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeOutputEvent", nodeOutputEvent() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conditionResultEvent":
            return Optional.ofNullable(clazz.cast(conditionResultEvent()));
        case "flowFailureEvent":
            return Optional.ofNullable(clazz.cast(flowFailureEvent()));
        case "flowInputEvent":
            return Optional.ofNullable(clazz.cast(flowInputEvent()));
        case "flowOutputEvent":
            return Optional.ofNullable(clazz.cast(flowOutputEvent()));
        case "nodeActionEvent":
            return Optional.ofNullable(clazz.cast(nodeActionEvent()));
        case "nodeDependencyEvent":
            return Optional.ofNullable(clazz.cast(nodeDependencyEvent()));
        case "nodeFailureEvent":
            return Optional.ofNullable(clazz.cast(nodeFailureEvent()));
        case "nodeInputEvent":
            return Optional.ofNullable(clazz.cast(nodeInputEvent()));
        case "nodeOutputEvent":
            return Optional.ofNullable(clazz.cast(nodeOutputEvent()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #conditionResultEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a condition evaluation result during the flow execution. This event is generated when
     * a condition node in the flow evaluates its conditions.
     * </p>
     * 
     * @param conditionResultEvent
     *        Contains information about a condition evaluation result during the flow execution. This event is
     *        generated when a condition node in the flow evaluates its conditions.
     */
    public static FlowExecutionEvent fromConditionResultEvent(ConditionResultEvent conditionResultEvent) {
        return builder().conditionResultEvent(conditionResultEvent).build();
    }

    /**
     * Create an instance of this class with {@link #conditionResultEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a condition evaluation result during the flow execution. This event is generated when
     * a condition node in the flow evaluates its conditions.
     * </p>
     * 
     * @param conditionResultEvent
     *        Contains information about a condition evaluation result during the flow execution. This event is
     *        generated when a condition node in the flow evaluates its conditions.
     */
    public static FlowExecutionEvent fromConditionResultEvent(Consumer<ConditionResultEvent.Builder> conditionResultEvent) {
        ConditionResultEvent.Builder builder = ConditionResultEvent.builder();
        conditionResultEvent.accept(builder);
        return fromConditionResultEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #flowFailureEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a failure that occurred at the flow level during execution.
     * </p>
     * 
     * @param flowFailureEvent
     *        Contains information about a failure that occurred at the flow level during execution.
     */
    public static FlowExecutionEvent fromFlowFailureEvent(FlowFailureEvent flowFailureEvent) {
        return builder().flowFailureEvent(flowFailureEvent).build();
    }

    /**
     * Create an instance of this class with {@link #flowFailureEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a failure that occurred at the flow level during execution.
     * </p>
     * 
     * @param flowFailureEvent
     *        Contains information about a failure that occurred at the flow level during execution.
     */
    public static FlowExecutionEvent fromFlowFailureEvent(Consumer<FlowFailureEvent.Builder> flowFailureEvent) {
        FlowFailureEvent.Builder builder = FlowFailureEvent.builder();
        flowFailureEvent.accept(builder);
        return fromFlowFailureEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #flowInputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the inputs provided to the flow at the start of execution.
     * </p>
     * 
     * @param flowInputEvent
     *        Contains information about the inputs provided to the flow at the start of execution.
     */
    public static FlowExecutionEvent fromFlowInputEvent(FlowExecutionInputEvent flowInputEvent) {
        return builder().flowInputEvent(flowInputEvent).build();
    }

    /**
     * Create an instance of this class with {@link #flowInputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the inputs provided to the flow at the start of execution.
     * </p>
     * 
     * @param flowInputEvent
     *        Contains information about the inputs provided to the flow at the start of execution.
     */
    public static FlowExecutionEvent fromFlowInputEvent(Consumer<FlowExecutionInputEvent.Builder> flowInputEvent) {
        FlowExecutionInputEvent.Builder builder = FlowExecutionInputEvent.builder();
        flowInputEvent.accept(builder);
        return fromFlowInputEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #flowOutputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the outputs produced by the flow at the end of execution.
     * </p>
     * 
     * @param flowOutputEvent
     *        Contains information about the outputs produced by the flow at the end of execution.
     */
    public static FlowExecutionEvent fromFlowOutputEvent(FlowExecutionOutputEvent flowOutputEvent) {
        return builder().flowOutputEvent(flowOutputEvent).build();
    }

    /**
     * Create an instance of this class with {@link #flowOutputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the outputs produced by the flow at the end of execution.
     * </p>
     * 
     * @param flowOutputEvent
     *        Contains information about the outputs produced by the flow at the end of execution.
     */
    public static FlowExecutionEvent fromFlowOutputEvent(Consumer<FlowExecutionOutputEvent.Builder> flowOutputEvent) {
        FlowExecutionOutputEvent.Builder builder = FlowExecutionOutputEvent.builder();
        flowOutputEvent.accept(builder);
        return fromFlowOutputEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeActionEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about an action (operation) called by a node during execution.
     * </p>
     * 
     * @param nodeActionEvent
     *        Contains information about an action (operation) called by a node during execution.
     */
    public static FlowExecutionEvent fromNodeActionEvent(NodeActionEvent nodeActionEvent) {
        return builder().nodeActionEvent(nodeActionEvent).build();
    }

    /**
     * Create an instance of this class with {@link #nodeActionEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about an action (operation) called by a node during execution.
     * </p>
     * 
     * @param nodeActionEvent
     *        Contains information about an action (operation) called by a node during execution.
     */
    public static FlowExecutionEvent fromNodeActionEvent(Consumer<NodeActionEvent.Builder> nodeActionEvent) {
        NodeActionEvent.Builder builder = NodeActionEvent.builder();
        nodeActionEvent.accept(builder);
        return fromNodeActionEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeDependencyEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about an internal trace of a specific node during execution.
     * </p>
     * 
     * @param nodeDependencyEvent
     *        Contains information about an internal trace of a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeDependencyEvent(NodeDependencyEvent nodeDependencyEvent) {
        return builder().nodeDependencyEvent(nodeDependencyEvent).build();
    }

    /**
     * Create an instance of this class with {@link #nodeDependencyEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about an internal trace of a specific node during execution.
     * </p>
     * 
     * @param nodeDependencyEvent
     *        Contains information about an internal trace of a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeDependencyEvent(Consumer<NodeDependencyEvent.Builder> nodeDependencyEvent) {
        NodeDependencyEvent.Builder builder = NodeDependencyEvent.builder();
        nodeDependencyEvent.accept(builder);
        return fromNodeDependencyEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeFailureEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a failure that occurred at a specific node during execution.
     * </p>
     * 
     * @param nodeFailureEvent
     *        Contains information about a failure that occurred at a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeFailureEvent(NodeFailureEvent nodeFailureEvent) {
        return builder().nodeFailureEvent(nodeFailureEvent).build();
    }

    /**
     * Create an instance of this class with {@link #nodeFailureEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about a failure that occurred at a specific node during execution.
     * </p>
     * 
     * @param nodeFailureEvent
     *        Contains information about a failure that occurred at a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeFailureEvent(Consumer<NodeFailureEvent.Builder> nodeFailureEvent) {
        NodeFailureEvent.Builder builder = NodeFailureEvent.builder();
        nodeFailureEvent.accept(builder);
        return fromNodeFailureEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeInputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the inputs provided to a specific node during execution.
     * </p>
     * 
     * @param nodeInputEvent
     *        Contains information about the inputs provided to a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeInputEvent(NodeInputEvent nodeInputEvent) {
        return builder().nodeInputEvent(nodeInputEvent).build();
    }

    /**
     * Create an instance of this class with {@link #nodeInputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the inputs provided to a specific node during execution.
     * </p>
     * 
     * @param nodeInputEvent
     *        Contains information about the inputs provided to a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeInputEvent(Consumer<NodeInputEvent.Builder> nodeInputEvent) {
        NodeInputEvent.Builder builder = NodeInputEvent.builder();
        nodeInputEvent.accept(builder);
        return fromNodeInputEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeOutputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the outputs produced by a specific node during execution.
     * </p>
     * 
     * @param nodeOutputEvent
     *        Contains information about the outputs produced by a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeOutputEvent(NodeOutputEvent nodeOutputEvent) {
        return builder().nodeOutputEvent(nodeOutputEvent).build();
    }

    /**
     * Create an instance of this class with {@link #nodeOutputEvent()} initialized to the given value.
     *
     * <p>
     * Contains information about the outputs produced by a specific node during execution.
     * </p>
     * 
     * @param nodeOutputEvent
     *        Contains information about the outputs produced by a specific node during execution.
     */
    public static FlowExecutionEvent fromNodeOutputEvent(Consumer<NodeOutputEvent.Builder> nodeOutputEvent) {
        NodeOutputEvent.Builder builder = NodeOutputEvent.builder();
        nodeOutputEvent.accept(builder);
        return fromNodeOutputEvent(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conditionResultEvent", CONDITION_RESULT_EVENT_FIELD);
        map.put("flowFailureEvent", FLOW_FAILURE_EVENT_FIELD);
        map.put("flowInputEvent", FLOW_INPUT_EVENT_FIELD);
        map.put("flowOutputEvent", FLOW_OUTPUT_EVENT_FIELD);
        map.put("nodeActionEvent", NODE_ACTION_EVENT_FIELD);
        map.put("nodeDependencyEvent", NODE_DEPENDENCY_EVENT_FIELD);
        map.put("nodeFailureEvent", NODE_FAILURE_EVENT_FIELD);
        map.put("nodeInputEvent", NODE_INPUT_EVENT_FIELD);
        map.put("nodeOutputEvent", NODE_OUTPUT_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionEvent, T> g) {
        return obj -> g.apply((FlowExecutionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowExecutionEvent> {
        /**
         * <p>
         * Contains information about a condition evaluation result during the flow execution. This event is generated
         * when a condition node in the flow evaluates its conditions.
         * </p>
         * 
         * @param conditionResultEvent
         *        Contains information about a condition evaluation result during the flow execution. This event is
         *        generated when a condition node in the flow evaluates its conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionResultEvent(ConditionResultEvent conditionResultEvent);

        /**
         * <p>
         * Contains information about a condition evaluation result during the flow execution. This event is generated
         * when a condition node in the flow evaluates its conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionResultEvent.Builder} avoiding
         * the need to create one manually via {@link ConditionResultEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionResultEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #conditionResultEvent(ConditionResultEvent)}.
         * 
         * @param conditionResultEvent
         *        a consumer that will call methods on {@link ConditionResultEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionResultEvent(ConditionResultEvent)
         */
        default Builder conditionResultEvent(Consumer<ConditionResultEvent.Builder> conditionResultEvent) {
            return conditionResultEvent(ConditionResultEvent.builder().applyMutation(conditionResultEvent).build());
        }

        /**
         * <p>
         * Contains information about a failure that occurred at the flow level during execution.
         * </p>
         * 
         * @param flowFailureEvent
         *        Contains information about a failure that occurred at the flow level during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowFailureEvent(FlowFailureEvent flowFailureEvent);

        /**
         * <p>
         * Contains information about a failure that occurred at the flow level during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowFailureEvent.Builder} avoiding the
         * need to create one manually via {@link FlowFailureEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowFailureEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #flowFailureEvent(FlowFailureEvent)}.
         * 
         * @param flowFailureEvent
         *        a consumer that will call methods on {@link FlowFailureEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowFailureEvent(FlowFailureEvent)
         */
        default Builder flowFailureEvent(Consumer<FlowFailureEvent.Builder> flowFailureEvent) {
            return flowFailureEvent(FlowFailureEvent.builder().applyMutation(flowFailureEvent).build());
        }

        /**
         * <p>
         * Contains information about the inputs provided to the flow at the start of execution.
         * </p>
         * 
         * @param flowInputEvent
         *        Contains information about the inputs provided to the flow at the start of execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowInputEvent(FlowExecutionInputEvent flowInputEvent);

        /**
         * <p>
         * Contains information about the inputs provided to the flow at the start of execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowExecutionInputEvent.Builder} avoiding
         * the need to create one manually via {@link FlowExecutionInputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowExecutionInputEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #flowInputEvent(FlowExecutionInputEvent)}.
         * 
         * @param flowInputEvent
         *        a consumer that will call methods on {@link FlowExecutionInputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowInputEvent(FlowExecutionInputEvent)
         */
        default Builder flowInputEvent(Consumer<FlowExecutionInputEvent.Builder> flowInputEvent) {
            return flowInputEvent(FlowExecutionInputEvent.builder().applyMutation(flowInputEvent).build());
        }

        /**
         * <p>
         * Contains information about the outputs produced by the flow at the end of execution.
         * </p>
         * 
         * @param flowOutputEvent
         *        Contains information about the outputs produced by the flow at the end of execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOutputEvent(FlowExecutionOutputEvent flowOutputEvent);

        /**
         * <p>
         * Contains information about the outputs produced by the flow at the end of execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowExecutionOutputEvent.Builder}
         * avoiding the need to create one manually via {@link FlowExecutionOutputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowExecutionOutputEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #flowOutputEvent(FlowExecutionOutputEvent)}.
         * 
         * @param flowOutputEvent
         *        a consumer that will call methods on {@link FlowExecutionOutputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowOutputEvent(FlowExecutionOutputEvent)
         */
        default Builder flowOutputEvent(Consumer<FlowExecutionOutputEvent.Builder> flowOutputEvent) {
            return flowOutputEvent(FlowExecutionOutputEvent.builder().applyMutation(flowOutputEvent).build());
        }

        /**
         * <p>
         * Contains information about an action (operation) called by a node during execution.
         * </p>
         * 
         * @param nodeActionEvent
         *        Contains information about an action (operation) called by a node during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeActionEvent(NodeActionEvent nodeActionEvent);

        /**
         * <p>
         * Contains information about an action (operation) called by a node during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeActionEvent.Builder} avoiding the
         * need to create one manually via {@link NodeActionEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeActionEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeActionEvent(NodeActionEvent)}.
         * 
         * @param nodeActionEvent
         *        a consumer that will call methods on {@link NodeActionEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeActionEvent(NodeActionEvent)
         */
        default Builder nodeActionEvent(Consumer<NodeActionEvent.Builder> nodeActionEvent) {
            return nodeActionEvent(NodeActionEvent.builder().applyMutation(nodeActionEvent).build());
        }

        /**
         * <p>
         * Contains information about an internal trace of a specific node during execution.
         * </p>
         * 
         * @param nodeDependencyEvent
         *        Contains information about an internal trace of a specific node during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDependencyEvent(NodeDependencyEvent nodeDependencyEvent);

        /**
         * <p>
         * Contains information about an internal trace of a specific node during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeDependencyEvent.Builder} avoiding the
         * need to create one manually via {@link NodeDependencyEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeDependencyEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #nodeDependencyEvent(NodeDependencyEvent)}.
         * 
         * @param nodeDependencyEvent
         *        a consumer that will call methods on {@link NodeDependencyEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeDependencyEvent(NodeDependencyEvent)
         */
        default Builder nodeDependencyEvent(Consumer<NodeDependencyEvent.Builder> nodeDependencyEvent) {
            return nodeDependencyEvent(NodeDependencyEvent.builder().applyMutation(nodeDependencyEvent).build());
        }

        /**
         * <p>
         * Contains information about a failure that occurred at a specific node during execution.
         * </p>
         * 
         * @param nodeFailureEvent
         *        Contains information about a failure that occurred at a specific node during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeFailureEvent(NodeFailureEvent nodeFailureEvent);

        /**
         * <p>
         * Contains information about a failure that occurred at a specific node during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeFailureEvent.Builder} avoiding the
         * need to create one manually via {@link NodeFailureEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeFailureEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeFailureEvent(NodeFailureEvent)}.
         * 
         * @param nodeFailureEvent
         *        a consumer that will call methods on {@link NodeFailureEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeFailureEvent(NodeFailureEvent)
         */
        default Builder nodeFailureEvent(Consumer<NodeFailureEvent.Builder> nodeFailureEvent) {
            return nodeFailureEvent(NodeFailureEvent.builder().applyMutation(nodeFailureEvent).build());
        }

        /**
         * <p>
         * Contains information about the inputs provided to a specific node during execution.
         * </p>
         * 
         * @param nodeInputEvent
         *        Contains information about the inputs provided to a specific node during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInputEvent(NodeInputEvent nodeInputEvent);

        /**
         * <p>
         * Contains information about the inputs provided to a specific node during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeInputEvent.Builder} avoiding the need
         * to create one manually via {@link NodeInputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeInputEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeInputEvent(NodeInputEvent)}.
         * 
         * @param nodeInputEvent
         *        a consumer that will call methods on {@link NodeInputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInputEvent(NodeInputEvent)
         */
        default Builder nodeInputEvent(Consumer<NodeInputEvent.Builder> nodeInputEvent) {
            return nodeInputEvent(NodeInputEvent.builder().applyMutation(nodeInputEvent).build());
        }

        /**
         * <p>
         * Contains information about the outputs produced by a specific node during execution.
         * </p>
         * 
         * @param nodeOutputEvent
         *        Contains information about the outputs produced by a specific node during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputEvent(NodeOutputEvent nodeOutputEvent);

        /**
         * <p>
         * Contains information about the outputs produced by a specific node during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeOutputEvent.Builder} avoiding the
         * need to create one manually via {@link NodeOutputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeOutputEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeOutputEvent(NodeOutputEvent)}.
         * 
         * @param nodeOutputEvent
         *        a consumer that will call methods on {@link NodeOutputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeOutputEvent(NodeOutputEvent)
         */
        default Builder nodeOutputEvent(Consumer<NodeOutputEvent.Builder> nodeOutputEvent) {
            return nodeOutputEvent(NodeOutputEvent.builder().applyMutation(nodeOutputEvent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionResultEvent conditionResultEvent;

        private FlowFailureEvent flowFailureEvent;

        private FlowExecutionInputEvent flowInputEvent;

        private FlowExecutionOutputEvent flowOutputEvent;

        private NodeActionEvent nodeActionEvent;

        private NodeDependencyEvent nodeDependencyEvent;

        private NodeFailureEvent nodeFailureEvent;

        private NodeInputEvent nodeInputEvent;

        private NodeOutputEvent nodeOutputEvent;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionEvent model) {
            conditionResultEvent(model.conditionResultEvent);
            flowFailureEvent(model.flowFailureEvent);
            flowInputEvent(model.flowInputEvent);
            flowOutputEvent(model.flowOutputEvent);
            nodeActionEvent(model.nodeActionEvent);
            nodeDependencyEvent(model.nodeDependencyEvent);
            nodeFailureEvent(model.nodeFailureEvent);
            nodeInputEvent(model.nodeInputEvent);
            nodeOutputEvent(model.nodeOutputEvent);
        }

        public final ConditionResultEvent.Builder getConditionResultEvent() {
            return conditionResultEvent != null ? conditionResultEvent.toBuilder() : null;
        }

        public final void setConditionResultEvent(ConditionResultEvent.BuilderImpl conditionResultEvent) {
            Object oldValue = this.conditionResultEvent;
            this.conditionResultEvent = conditionResultEvent != null ? conditionResultEvent.build() : null;
            handleUnionValueChange(Type.CONDITION_RESULT_EVENT, oldValue, this.conditionResultEvent);
        }

        @Override
        public final Builder conditionResultEvent(ConditionResultEvent conditionResultEvent) {
            Object oldValue = this.conditionResultEvent;
            this.conditionResultEvent = conditionResultEvent;
            handleUnionValueChange(Type.CONDITION_RESULT_EVENT, oldValue, this.conditionResultEvent);
            return this;
        }

        public final FlowFailureEvent.Builder getFlowFailureEvent() {
            return flowFailureEvent != null ? flowFailureEvent.toBuilder() : null;
        }

        public final void setFlowFailureEvent(FlowFailureEvent.BuilderImpl flowFailureEvent) {
            Object oldValue = this.flowFailureEvent;
            this.flowFailureEvent = flowFailureEvent != null ? flowFailureEvent.build() : null;
            handleUnionValueChange(Type.FLOW_FAILURE_EVENT, oldValue, this.flowFailureEvent);
        }

        @Override
        public final Builder flowFailureEvent(FlowFailureEvent flowFailureEvent) {
            Object oldValue = this.flowFailureEvent;
            this.flowFailureEvent = flowFailureEvent;
            handleUnionValueChange(Type.FLOW_FAILURE_EVENT, oldValue, this.flowFailureEvent);
            return this;
        }

        public final FlowExecutionInputEvent.Builder getFlowInputEvent() {
            return flowInputEvent != null ? flowInputEvent.toBuilder() : null;
        }

        public final void setFlowInputEvent(FlowExecutionInputEvent.BuilderImpl flowInputEvent) {
            Object oldValue = this.flowInputEvent;
            this.flowInputEvent = flowInputEvent != null ? flowInputEvent.build() : null;
            handleUnionValueChange(Type.FLOW_INPUT_EVENT, oldValue, this.flowInputEvent);
        }

        @Override
        public final Builder flowInputEvent(FlowExecutionInputEvent flowInputEvent) {
            Object oldValue = this.flowInputEvent;
            this.flowInputEvent = flowInputEvent;
            handleUnionValueChange(Type.FLOW_INPUT_EVENT, oldValue, this.flowInputEvent);
            return this;
        }

        public final FlowExecutionOutputEvent.Builder getFlowOutputEvent() {
            return flowOutputEvent != null ? flowOutputEvent.toBuilder() : null;
        }

        public final void setFlowOutputEvent(FlowExecutionOutputEvent.BuilderImpl flowOutputEvent) {
            Object oldValue = this.flowOutputEvent;
            this.flowOutputEvent = flowOutputEvent != null ? flowOutputEvent.build() : null;
            handleUnionValueChange(Type.FLOW_OUTPUT_EVENT, oldValue, this.flowOutputEvent);
        }

        @Override
        public final Builder flowOutputEvent(FlowExecutionOutputEvent flowOutputEvent) {
            Object oldValue = this.flowOutputEvent;
            this.flowOutputEvent = flowOutputEvent;
            handleUnionValueChange(Type.FLOW_OUTPUT_EVENT, oldValue, this.flowOutputEvent);
            return this;
        }

        public final NodeActionEvent.Builder getNodeActionEvent() {
            return nodeActionEvent != null ? nodeActionEvent.toBuilder() : null;
        }

        public final void setNodeActionEvent(NodeActionEvent.BuilderImpl nodeActionEvent) {
            Object oldValue = this.nodeActionEvent;
            this.nodeActionEvent = nodeActionEvent != null ? nodeActionEvent.build() : null;
            handleUnionValueChange(Type.NODE_ACTION_EVENT, oldValue, this.nodeActionEvent);
        }

        @Override
        public final Builder nodeActionEvent(NodeActionEvent nodeActionEvent) {
            Object oldValue = this.nodeActionEvent;
            this.nodeActionEvent = nodeActionEvent;
            handleUnionValueChange(Type.NODE_ACTION_EVENT, oldValue, this.nodeActionEvent);
            return this;
        }

        public final NodeDependencyEvent.Builder getNodeDependencyEvent() {
            return nodeDependencyEvent != null ? nodeDependencyEvent.toBuilder() : null;
        }

        public final void setNodeDependencyEvent(NodeDependencyEvent.BuilderImpl nodeDependencyEvent) {
            Object oldValue = this.nodeDependencyEvent;
            this.nodeDependencyEvent = nodeDependencyEvent != null ? nodeDependencyEvent.build() : null;
            handleUnionValueChange(Type.NODE_DEPENDENCY_EVENT, oldValue, this.nodeDependencyEvent);
        }

        @Override
        public final Builder nodeDependencyEvent(NodeDependencyEvent nodeDependencyEvent) {
            Object oldValue = this.nodeDependencyEvent;
            this.nodeDependencyEvent = nodeDependencyEvent;
            handleUnionValueChange(Type.NODE_DEPENDENCY_EVENT, oldValue, this.nodeDependencyEvent);
            return this;
        }

        public final NodeFailureEvent.Builder getNodeFailureEvent() {
            return nodeFailureEvent != null ? nodeFailureEvent.toBuilder() : null;
        }

        public final void setNodeFailureEvent(NodeFailureEvent.BuilderImpl nodeFailureEvent) {
            Object oldValue = this.nodeFailureEvent;
            this.nodeFailureEvent = nodeFailureEvent != null ? nodeFailureEvent.build() : null;
            handleUnionValueChange(Type.NODE_FAILURE_EVENT, oldValue, this.nodeFailureEvent);
        }

        @Override
        public final Builder nodeFailureEvent(NodeFailureEvent nodeFailureEvent) {
            Object oldValue = this.nodeFailureEvent;
            this.nodeFailureEvent = nodeFailureEvent;
            handleUnionValueChange(Type.NODE_FAILURE_EVENT, oldValue, this.nodeFailureEvent);
            return this;
        }

        public final NodeInputEvent.Builder getNodeInputEvent() {
            return nodeInputEvent != null ? nodeInputEvent.toBuilder() : null;
        }

        public final void setNodeInputEvent(NodeInputEvent.BuilderImpl nodeInputEvent) {
            Object oldValue = this.nodeInputEvent;
            this.nodeInputEvent = nodeInputEvent != null ? nodeInputEvent.build() : null;
            handleUnionValueChange(Type.NODE_INPUT_EVENT, oldValue, this.nodeInputEvent);
        }

        @Override
        public final Builder nodeInputEvent(NodeInputEvent nodeInputEvent) {
            Object oldValue = this.nodeInputEvent;
            this.nodeInputEvent = nodeInputEvent;
            handleUnionValueChange(Type.NODE_INPUT_EVENT, oldValue, this.nodeInputEvent);
            return this;
        }

        public final NodeOutputEvent.Builder getNodeOutputEvent() {
            return nodeOutputEvent != null ? nodeOutputEvent.toBuilder() : null;
        }

        public final void setNodeOutputEvent(NodeOutputEvent.BuilderImpl nodeOutputEvent) {
            Object oldValue = this.nodeOutputEvent;
            this.nodeOutputEvent = nodeOutputEvent != null ? nodeOutputEvent.build() : null;
            handleUnionValueChange(Type.NODE_OUTPUT_EVENT, oldValue, this.nodeOutputEvent);
        }

        @Override
        public final Builder nodeOutputEvent(NodeOutputEvent nodeOutputEvent) {
            Object oldValue = this.nodeOutputEvent;
            this.nodeOutputEvent = nodeOutputEvent;
            handleUnionValueChange(Type.NODE_OUTPUT_EVENT, oldValue, this.nodeOutputEvent);
            return this;
        }

        @Override
        public FlowExecutionEvent build() {
            return new FlowExecutionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FlowExecutionEvent#type()
     */
    public enum Type {
        CONDITION_RESULT_EVENT,

        FLOW_FAILURE_EVENT,

        FLOW_INPUT_EVENT,

        FLOW_OUTPUT_EVENT,

        NODE_ACTION_EVENT,

        NODE_DEPENDENCY_EVENT,

        NODE_FAILURE_EVENT,

        NODE_INPUT_EVENT,

        NODE_OUTPUT_EVENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
