/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a condition evaluation result during a flow execution. This event is generated when a
 * condition node in the flow evaluates its conditions.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionResultEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionResultEvent.Builder, ConditionResultEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(ConditionResultEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<List<SatisfiedCondition>> SATISFIED_CONDITIONS_FIELD = SdkField
            .<List<SatisfiedCondition>> builder(MarshallingType.LIST)
            .memberName("satisfiedConditions")
            .getter(getter(ConditionResultEvent::satisfiedConditions))
            .setter(setter(Builder::satisfiedConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satisfiedConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SatisfiedCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SatisfiedCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(ConditionResultEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            SATISFIED_CONDITIONS_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final List<SatisfiedCondition> satisfiedConditions;

    private final Instant timestamp;

    private ConditionResultEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.satisfiedConditions = builder.satisfiedConditions;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The name of the condition node that evaluated the conditions.
     * </p>
     * 
     * @return The name of the condition node that evaluated the conditions.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SatisfiedConditions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSatisfiedConditions() {
        return satisfiedConditions != null && !(satisfiedConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions that were satisfied during the evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSatisfiedConditions} method.
     * </p>
     * 
     * @return A list of conditions that were satisfied during the evaluation.
     */
    public final List<SatisfiedCondition> satisfiedConditions() {
        return satisfiedConditions;
    }

    /**
     * <p>
     * The timestamp when the condition evaluation occurred.
     * </p>
     * 
     * @return The timestamp when the condition evaluation occurred.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSatisfiedConditions() ? satisfiedConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionResultEvent)) {
            return false;
        }
        ConditionResultEvent other = (ConditionResultEvent) obj;
        return Objects.equals(nodeName(), other.nodeName()) && hasSatisfiedConditions() == other.hasSatisfiedConditions()
                && Objects.equals(satisfiedConditions(), other.satisfiedConditions())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionResultEvent").add("NodeName", nodeName())
                .add("SatisfiedConditions", satisfiedConditions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "satisfiedConditions":
            return Optional.ofNullable(clazz.cast(satisfiedConditions()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("satisfiedConditions", SATISFIED_CONDITIONS_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionResultEvent, T> g) {
        return obj -> g.apply((ConditionResultEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionResultEvent> {
        /**
         * <p>
         * The name of the condition node that evaluated the conditions.
         * </p>
         * 
         * @param nodeName
         *        The name of the condition node that evaluated the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * A list of conditions that were satisfied during the evaluation.
         * </p>
         * 
         * @param satisfiedConditions
         *        A list of conditions that were satisfied during the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satisfiedConditions(Collection<SatisfiedCondition> satisfiedConditions);

        /**
         * <p>
         * A list of conditions that were satisfied during the evaluation.
         * </p>
         * 
         * @param satisfiedConditions
         *        A list of conditions that were satisfied during the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satisfiedConditions(SatisfiedCondition... satisfiedConditions);

        /**
         * <p>
         * A list of conditions that were satisfied during the evaluation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.SatisfiedCondition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.SatisfiedCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.SatisfiedCondition.Builder#build()} is
         * called immediately and its result is passed to {@link #satisfiedConditions(List<SatisfiedCondition>)}.
         * 
         * @param satisfiedConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.SatisfiedCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #satisfiedConditions(java.util.Collection<SatisfiedCondition>)
         */
        Builder satisfiedConditions(Consumer<SatisfiedCondition.Builder>... satisfiedConditions);

        /**
         * <p>
         * The timestamp when the condition evaluation occurred.
         * </p>
         * 
         * @param timestamp
         *        The timestamp when the condition evaluation occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private List<SatisfiedCondition> satisfiedConditions = DefaultSdkAutoConstructList.getInstance();

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionResultEvent model) {
            nodeName(model.nodeName);
            satisfiedConditions(model.satisfiedConditions);
            timestamp(model.timestamp);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final List<SatisfiedCondition.Builder> getSatisfiedConditions() {
            List<SatisfiedCondition.Builder> result = SatisfiedConditionsCopier.copyToBuilder(this.satisfiedConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSatisfiedConditions(Collection<SatisfiedCondition.BuilderImpl> satisfiedConditions) {
            this.satisfiedConditions = SatisfiedConditionsCopier.copyFromBuilder(satisfiedConditions);
        }

        @Override
        public final Builder satisfiedConditions(Collection<SatisfiedCondition> satisfiedConditions) {
            this.satisfiedConditions = SatisfiedConditionsCopier.copy(satisfiedConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satisfiedConditions(SatisfiedCondition... satisfiedConditions) {
            satisfiedConditions(Arrays.asList(satisfiedConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satisfiedConditions(Consumer<SatisfiedCondition.Builder>... satisfiedConditions) {
            satisfiedConditions(Stream.of(satisfiedConditions).map(c -> SatisfiedCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ConditionResultEvent build() {
            return new ConditionResultEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
