/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings of an inline collaborator agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaboratorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaboratorConfiguration.Builder, CollaboratorConfiguration> {
    private static final SdkField<String> AGENT_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasArn").getter(getter(CollaboratorConfiguration::agentAliasArn))
            .setter(setter(Builder::agentAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasArn").build()).build();

    private static final SdkField<String> COLLABORATOR_INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorInstruction").getter(getter(CollaboratorConfiguration::collaboratorInstruction))
            .setter(setter(Builder::collaboratorInstruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorInstruction").build())
            .build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(CollaboratorConfiguration::collaboratorName))
            .setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final SdkField<String> RELAY_CONVERSATION_HISTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relayConversationHistory").getter(getter(CollaboratorConfiguration::relayConversationHistoryAsString))
            .setter(setter(Builder::relayConversationHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relayConversationHistory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ARN_FIELD,
            COLLABORATOR_INSTRUCTION_FIELD, COLLABORATOR_NAME_FIELD, RELAY_CONVERSATION_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentAliasArn;

    private final String collaboratorInstruction;

    private final String collaboratorName;

    private final String relayConversationHistory;

    private CollaboratorConfiguration(BuilderImpl builder) {
        this.agentAliasArn = builder.agentAliasArn;
        this.collaboratorInstruction = builder.collaboratorInstruction;
        this.collaboratorName = builder.collaboratorName;
        this.relayConversationHistory = builder.relayConversationHistory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inline collaborator agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inline collaborator agent.
     */
    public final String agentAliasArn() {
        return agentAliasArn;
    }

    /**
     * <p>
     * Instructions that tell the inline collaborator agent what it should do and how it should interact with users.
     * </p>
     * 
     * @return Instructions that tell the inline collaborator agent what it should do and how it should interact with
     *         users.
     */
    public final String collaboratorInstruction() {
        return collaboratorInstruction;
    }

    /**
     * <p>
     * Name of the inline collaborator agent which must be the same name as specified for <code>agentName</code>.
     * </p>
     * 
     * @return Name of the inline collaborator agent which must be the same name as specified for <code>agentName</code>
     *         .
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    /**
     * <p>
     * A relay conversation history for the inline collaborator agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return A relay conversation history for the inline collaborator agent.
     * @see RelayConversationHistory
     */
    public final RelayConversationHistory relayConversationHistory() {
        return RelayConversationHistory.fromValue(relayConversationHistory);
    }

    /**
     * <p>
     * A relay conversation history for the inline collaborator agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return A relay conversation history for the inline collaborator agent.
     * @see RelayConversationHistory
     */
    public final String relayConversationHistoryAsString() {
        return relayConversationHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(relayConversationHistoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaboratorConfiguration)) {
            return false;
        }
        CollaboratorConfiguration other = (CollaboratorConfiguration) obj;
        return Objects.equals(agentAliasArn(), other.agentAliasArn())
                && Objects.equals(collaboratorInstruction(), other.collaboratorInstruction())
                && Objects.equals(collaboratorName(), other.collaboratorName())
                && Objects.equals(relayConversationHistoryAsString(), other.relayConversationHistoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaboratorConfiguration").add("AgentAliasArn", agentAliasArn())
                .add("CollaboratorInstruction", collaboratorInstruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CollaboratorName", collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RelayConversationHistory", relayConversationHistoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasArn":
            return Optional.ofNullable(clazz.cast(agentAliasArn()));
        case "collaboratorInstruction":
            return Optional.ofNullable(clazz.cast(collaboratorInstruction()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        case "relayConversationHistory":
            return Optional.ofNullable(clazz.cast(relayConversationHistoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentAliasArn", AGENT_ALIAS_ARN_FIELD);
        map.put("collaboratorInstruction", COLLABORATOR_INSTRUCTION_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("relayConversationHistory", RELAY_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaboratorConfiguration, T> g) {
        return obj -> g.apply((CollaboratorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaboratorConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inline collaborator agent.
         * </p>
         * 
         * @param agentAliasArn
         *        The Amazon Resource Name (ARN) of the inline collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasArn(String agentAliasArn);

        /**
         * <p>
         * Instructions that tell the inline collaborator agent what it should do and how it should interact with users.
         * </p>
         * 
         * @param collaboratorInstruction
         *        Instructions that tell the inline collaborator agent what it should do and how it should interact with
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorInstruction(String collaboratorInstruction);

        /**
         * <p>
         * Name of the inline collaborator agent which must be the same name as specified for <code>agentName</code>.
         * </p>
         * 
         * @param collaboratorName
         *        Name of the inline collaborator agent which must be the same name as specified for
         *        <code>agentName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);

        /**
         * <p>
         * A relay conversation history for the inline collaborator agent.
         * </p>
         * 
         * @param relayConversationHistory
         *        A relay conversation history for the inline collaborator agent.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(String relayConversationHistory);

        /**
         * <p>
         * A relay conversation history for the inline collaborator agent.
         * </p>
         * 
         * @param relayConversationHistory
         *        A relay conversation history for the inline collaborator agent.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(RelayConversationHistory relayConversationHistory);
    }

    static final class BuilderImpl implements Builder {
        private String agentAliasArn;

        private String collaboratorInstruction;

        private String collaboratorName;

        private String relayConversationHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaboratorConfiguration model) {
            agentAliasArn(model.agentAliasArn);
            collaboratorInstruction(model.collaboratorInstruction);
            collaboratorName(model.collaboratorName);
            relayConversationHistory(model.relayConversationHistory);
        }

        public final String getAgentAliasArn() {
            return agentAliasArn;
        }

        public final void setAgentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
        }

        @Override
        public final Builder agentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
            return this;
        }

        public final String getCollaboratorInstruction() {
            return collaboratorInstruction;
        }

        public final void setCollaboratorInstruction(String collaboratorInstruction) {
            this.collaboratorInstruction = collaboratorInstruction;
        }

        @Override
        public final Builder collaboratorInstruction(String collaboratorInstruction) {
            this.collaboratorInstruction = collaboratorInstruction;
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getRelayConversationHistory() {
            return relayConversationHistory;
        }

        public final void setRelayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
        }

        @Override
        public final Builder relayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
            return this;
        }

        @Override
        public final Builder relayConversationHistory(RelayConversationHistory relayConversationHistory) {
            this.relayConversationHistory(relayConversationHistory == null ? null : relayConversationHistory.toString());
            return this;
        }

        @Override
        public CollaboratorConfiguration build() {
            return new CollaboratorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
