/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bedrockagentruntime.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentruntime.model.BadGatewayException;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeException;
import software.amazon.awssdk.services.bedrockagentruntime.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.DependencyFailedException;
import software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetExecutionFlowSnapshotRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetExecutionFlowSnapshotResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetFlowExecutionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetFlowExecutionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentruntime.model.StartFlowExecutionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.StartFlowExecutionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.StopFlowExecutionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.StopFlowExecutionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable;

/**
 * Service client for accessing Agents for Amazon Bedrock Runtime. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Contains APIs related to model invocation and querying of knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentRuntimeClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent-runtime";

    /**
     * <p>
     * Creates a new invocation within a session. An invocation groups the related invocation steps that store the
     * content from a conversation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createInvocationRequest
     * @return Result of the CreateInvocation operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.CreateInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInvocationResponse createInvocation(CreateInvocationRequest createInvocationRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new invocation within a session. An invocation groups the related invocation steps that store the
     * content from a conversation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvocationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInvocationRequest#builder()}
     * </p>
     *
     * @param createInvocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateInvocation operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.CreateInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInvocationResponse createInvocation(Consumer<CreateInvocationRequest.Builder> createInvocationRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return createInvocation(CreateInvocationRequest.builder().applyMutation(createInvocationRequest).build());
    }

    /**
     * <p>
     * Creates a session to temporarily store conversations for generative AI (GenAI) applications built with
     * open-source frameworks such as LangGraph and LlamaIndex. Sessions enable you to save the state of conversations
     * at checkpoints, with the added security and infrastructure of Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * By default, Amazon Bedrock uses Amazon Web Services-managed keys for session encryption, including session
     * metadata, or you can use your own KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/session-encryption.html">Amazon Bedrock session
     * encryption</a>.
     * </p>
     * <note>
     * <p>
     * You use a session to store state and conversation history for generative AI applications built with open-source
     * frameworks. For Amazon Bedrock Agents, the service automatically manages conversation context and associates them
     * with the agent-specific sessionId you specify in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * API operation.
     * </p>
     * </note>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html">
     * DeleteSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSessionRequest
     * @return Result of the CreateSession operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session to temporarily store conversations for generative AI (GenAI) applications built with
     * open-source frameworks such as LangGraph and LlamaIndex. Sessions enable you to save the state of conversations
     * at checkpoints, with the added security and infrastructure of Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * By default, Amazon Bedrock uses Amazon Web Services-managed keys for session encryption, including session
     * metadata, or you can use your own KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/session-encryption.html">Amazon Bedrock session
     * encryption</a>.
     * </p>
     * <note>
     * <p>
     * You use a session to store state and conversation history for generative AI applications built with open-source
     * frameworks. For Amazon Bedrock Agents, the service automatically manages conversation context and associates them
     * with the agent-specific sessionId you specify in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * API operation.
     * </p>
     * </note>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html">
     * DeleteSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSession operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSessionResponse createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest)
            throws ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     *
     * @param deleteAgentMemoryRequest
     * @return Result of the DeleteAgentMemory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentMemoryResponse deleteAgentMemory(DeleteAgentMemoryRequest deleteAgentMemoryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentMemoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgentMemoryRequest#builder()}
     * </p>
     *
     * @param deleteAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAgentMemory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentMemoryResponse deleteAgentMemory(Consumer<DeleteAgentMemoryRequest.Builder> deleteAgentMemoryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return deleteAgentMemory(DeleteAgentMemoryRequest.builder().applyMutation(deleteAgentMemoryRequest).build());
    }

    /**
     * <p>
     * Deletes a session that you ended. You can't delete a session with an <code>ACTIVE</code> status. To delete an
     * active session, you must first end it with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * API operation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param deleteSessionRequest
     * @return Result of the DeleteSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSessionResponse deleteSession(DeleteSessionRequest deleteSessionRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a session that you ended. You can't delete a session with an <code>ACTIVE</code> status. To delete an
     * active session, you must first end it with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * API operation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSessionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSessionRequest#builder()}
     * </p>
     *
     * @param deleteSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSessionResponse deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return deleteSession(DeleteSessionRequest.builder().applyMutation(deleteSessionRequest).build());
    }

    /**
     * <p>
     * Ends the session. After you end a session, you can still access its content but you can’t add to it. To delete
     * the session and it's content, you use the DeleteSession API operation. For more information about sessions, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation
     * history and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param endSessionRequest
     * @return Result of the EndSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.EndSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/EndSession"
     *      target="_top">AWS API Documentation</a>
     */
    default EndSessionResponse endSession(EndSessionRequest endSessionRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends the session. After you end a session, you can still access its content but you can’t add to it. To delete
     * the session and it's content, you use the DeleteSession API operation. For more information about sessions, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation
     * history and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EndSessionRequest.Builder} avoiding the need to
     * create one manually via {@link EndSessionRequest#builder()}
     * </p>
     *
     * @param endSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionRequest.Builder} to create a
     *        request.
     * @return Result of the EndSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.EndSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/EndSession"
     *      target="_top">AWS API Documentation</a>
     */
    default EndSessionResponse endSession(Consumer<EndSessionRequest.Builder> endSessionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return endSession(EndSessionRequest.builder().applyMutation(endSessionRequest).build());
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param generateQueryRequest
     * @return Result of the GenerateQuery operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateQueryResponse generateQuery(GenerateQueryRequest generateQueryRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GenerateQueryRequest#builder()}
     * </p>
     *
     * @param generateQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest.Builder} to create a
     *        request.
     * @return Result of the GenerateQuery operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateQueryResponse generateQuery(Consumer<GenerateQueryRequest.Builder> generateQueryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return generateQuery(GenerateQueryRequest.builder().applyMutation(generateQueryRequest).build());
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return Result of the GetAgentMemory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryResponse getAgentMemory(GetAgentMemoryRequest getAgentMemoryRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return Result of the GetAgentMemory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryResponse getAgentMemory(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return getAgentMemory(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client.getAgentMemoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client
     *             .getAgentMemoryPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client.getAgentMemoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryIterable getAgentMemoryPaginator(GetAgentMemoryRequest getAgentMemoryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return new GetAgentMemoryIterable(this, getAgentMemoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client.getAgentMemoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client
     *             .getAgentMemoryPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryIterable responses = client.getAgentMemoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryIterable getAgentMemoryPaginator(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return getAgentMemoryPaginator(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the flow definition snapshot used for a flow execution. The snapshot represents the flow metadata and
     * definition as it existed at the time the execution was started. Note that even if the flow is edited after an
     * execution starts, the snapshot connected to the execution remains unchanged.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note>
     *
     * @param getExecutionFlowSnapshotRequest
     * @return Result of the GetExecutionFlowSnapshot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetExecutionFlowSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetExecutionFlowSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExecutionFlowSnapshotResponse getExecutionFlowSnapshot(
            GetExecutionFlowSnapshotRequest getExecutionFlowSnapshotRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the flow definition snapshot used for a flow execution. The snapshot represents the flow metadata and
     * definition as it existed at the time the execution was started. Note that even if the flow is edited after an
     * execution starts, the snapshot connected to the execution remains unchanged.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExecutionFlowSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link GetExecutionFlowSnapshotRequest#builder()}
     * </p>
     *
     * @param getExecutionFlowSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetExecutionFlowSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the GetExecutionFlowSnapshot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetExecutionFlowSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetExecutionFlowSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExecutionFlowSnapshotResponse getExecutionFlowSnapshot(
            Consumer<GetExecutionFlowSnapshotRequest.Builder> getExecutionFlowSnapshotRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return getExecutionFlowSnapshot(GetExecutionFlowSnapshotRequest.builder().applyMutation(getExecutionFlowSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details about a specific flow execution, including its status, start and end times, and any errors that
     * occurred during execution.
     * </p>
     *
     * @param getFlowExecutionRequest
     * @return Result of the GetFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowExecutionResponse getFlowExecution(GetFlowExecutionRequest getFlowExecutionRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific flow execution, including its status, start and end times, and any errors that
     * occurred during execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link GetFlowExecutionRequest#builder()}
     * </p>
     *
     * @param getFlowExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetFlowExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the GetFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowExecutionResponse getFlowExecution(Consumer<GetFlowExecutionRequest.Builder> getFlowExecutionRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return getFlowExecution(GetFlowExecutionRequest.builder().applyMutation(getFlowExecutionRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific invocation step within an invocation in a session. For more information about
     * sessions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve
     * conversation history and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param getInvocationStepRequest
     * @return Result of the GetInvocationStep operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvocationStepResponse getInvocationStep(GetInvocationStepRequest getInvocationStepRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific invocation step within an invocation in a session. For more information about
     * sessions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve
     * conversation history and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvocationStepRequest.Builder} avoiding the need
     * to create one manually via {@link GetInvocationStepRequest#builder()}
     * </p>
     *
     * @param getInvocationStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepRequest.Builder} to
     *        create a request.
     * @return Result of the GetInvocationStep operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvocationStepResponse getInvocationStep(Consumer<GetInvocationStepRequest.Builder> getInvocationStepRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return getInvocationStep(GetInvocationStepRequest.builder().applyMutation(getInvocationStepRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionRequest.Builder} to create a
     *        request.
     * @return Result of the GetSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Lists events that occurred during a flow execution. Events provide detailed information about the execution
     * progress, including node inputs and outputs, flow inputs and outputs, condition results, and failure events.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note>
     *
     * @param listFlowExecutionEventsRequest
     * @return Result of the ListFlowExecutionEvents operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionEventsResponse listFlowExecutionEvents(ListFlowExecutionEventsRequest listFlowExecutionEventsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events that occurred during a flow execution. Events provide detailed information about the execution
     * progress, including node inputs and outputs, flow inputs and outputs, condition results, and failure events.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionEventsRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest.Builder}
     *        to create a request.
     * @return Result of the ListFlowExecutionEvents operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionEventsResponse listFlowExecutionEvents(
            Consumer<ListFlowExecutionEventsRequest.Builder> listFlowExecutionEventsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listFlowExecutionEvents(ListFlowExecutionEventsRequest.builder().applyMutation(listFlowExecutionEventsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionEvents(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client.listFlowExecutionEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client
     *             .listFlowExecutionEventsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client.listFlowExecutionEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionEvents(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowExecutionEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionEventsIterable listFlowExecutionEventsPaginator(
            ListFlowExecutionEventsRequest listFlowExecutionEventsRequest) throws ResourceNotFoundException, ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return new ListFlowExecutionEventsIterable(this, listFlowExecutionEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionEvents(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client.listFlowExecutionEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client
     *             .listFlowExecutionEventsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionEventsIterable responses = client.listFlowExecutionEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionEvents(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionEventsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionEventsRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionEventsIterable listFlowExecutionEventsPaginator(
            Consumer<ListFlowExecutionEventsRequest.Builder> listFlowExecutionEventsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listFlowExecutionEventsPaginator(ListFlowExecutionEventsRequest.builder()
                .applyMutation(listFlowExecutionEventsRequest).build());
    }

    /**
     * <p>
     * Lists all executions of a flow. Results can be paginated and include summary information about each execution,
     * such as status, start and end times, and the execution's Amazon Resource Name (ARN).
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note>
     *
     * @param listFlowExecutionsRequest
     * @return Result of the ListFlowExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionsResponse listFlowExecutions(ListFlowExecutionsRequest listFlowExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all executions of a flow. Results can be paginated and include summary information about each execution,
     * such as status, start and end times, and the execution's Amazon Resource Name (ARN).
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFlowExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionsResponse listFlowExecutions(Consumer<ListFlowExecutionsRequest.Builder> listFlowExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return listFlowExecutions(ListFlowExecutionsRequest.builder().applyMutation(listFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowExecutions(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client.listFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client
     *             .listFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client.listFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutions(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionsIterable listFlowExecutionsPaginator(ListFlowExecutionsRequest listFlowExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return new ListFlowExecutionsIterable(this, listFlowExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowExecutions(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client.listFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client
     *             .listFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListFlowExecutionsIterable responses = client.listFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutions(software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionsIterable listFlowExecutionsPaginator(
            Consumer<ListFlowExecutionsRequest.Builder> listFlowExecutionsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listFlowExecutionsPaginator(ListFlowExecutionsRequest.builder().applyMutation(listFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all invocation steps associated with a session and optionally, an invocation within the session. For more
     * information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listInvocationStepsRequest
     * @return Result of the ListInvocationSteps operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsResponse listInvocationSteps(ListInvocationStepsRequest listInvocationStepsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all invocation steps associated with a session and optionally, an invocation within the session. For more
     * information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationStepsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvocationStepsRequest#builder()}
     * </p>
     *
     * @param listInvocationStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest.Builder} to
     *        create a request.
     * @return Result of the ListInvocationSteps operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsResponse listInvocationSteps(
            Consumer<ListInvocationStepsRequest.Builder> listInvocationStepsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listInvocationSteps(ListInvocationStepsRequest.builder().applyMutation(listInvocationStepsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client.listInvocationStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client
     *             .listInvocationStepsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client.listInvocationStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvocationStepsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsIterable listInvocationStepsPaginator(ListInvocationStepsRequest listInvocationStepsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return new ListInvocationStepsIterable(this, listInvocationStepsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client.listInvocationStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client
     *             .listInvocationStepsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsIterable responses = client.listInvocationStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationStepsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvocationStepsRequest#builder()}
     * </p>
     *
     * @param listInvocationStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsIterable listInvocationStepsPaginator(
            Consumer<ListInvocationStepsRequest.Builder> listInvocationStepsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listInvocationStepsPaginator(ListInvocationStepsRequest.builder().applyMutation(listInvocationStepsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all invocations associated with a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listInvocationsRequest
     * @return Result of the ListInvocations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsResponse listInvocations(ListInvocationsRequest listInvocationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all invocations associated with a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvocationsRequest#builder()}
     * </p>
     *
     * @param listInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListInvocations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsResponse listInvocations(Consumer<ListInvocationsRequest.Builder> listInvocationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return listInvocations(ListInvocationsRequest.builder().applyMutation(listInvocationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client.listInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client
     *             .listInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client.listInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsIterable listInvocationsPaginator(ListInvocationsRequest listInvocationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return new ListInvocationsIterable(this, listInvocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client.listInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client
     *             .listInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsIterable responses = client.listInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvocationsRequest#builder()}
     * </p>
     *
     * @param listInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsIterable listInvocationsPaginator(Consumer<ListInvocationsRequest.Builder> listInvocationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return listInvocationsPaginator(ListInvocationsRequest.builder().applyMutation(listInvocationsRequest).build());
    }

    /**
     * <p>
     * Lists all sessions in your Amazon Web Services account. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all sessions in your Amazon Web Services account. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSessions operation returned by the service.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsResponse listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(ListSessionsRequest listSessionsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return new ListSessionsIterable(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * List all the tags for the resource you specify.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the tags for the resource you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Add an invocation step to an invocation in a session. An invocation step stores fine-grained state checkpoints,
     * including text and images, for each interaction. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html">
     * GetInvocationStep</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html">
     * ListInvocationSteps</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListSessions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putInvocationStepRequest
     * @return Result of the PutInvocationStep operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.PutInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/PutInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInvocationStepResponse putInvocationStep(PutInvocationStepRequest putInvocationStepRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add an invocation step to an invocation in a session. An invocation step stores fine-grained state checkpoints,
     * including text and images, for each interaction. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html">
     * GetInvocationStep</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html">
     * ListInvocationSteps</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListSessions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInvocationStepRequest.Builder} avoiding the need
     * to create one manually via {@link PutInvocationStepRequest#builder()}
     * </p>
     *
     * @param putInvocationStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepRequest.Builder} to
     *        create a request.
     * @return Result of the PutInvocationStep operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.PutInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/PutInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInvocationStepResponse putInvocationStep(Consumer<PutInvocationStepRequest.Builder> putInvocationStepRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return putInvocationStep(PutInvocationStepRequest.builder().applyMutation(putInvocationStepRequest).build());
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     *
     * @param rerankRequest
     * @return Result of the Rerank operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankResponse rerank(RerankRequest rerankRequest) throws ResourceNotFoundException, ConflictException,
            ValidationException, InternalServerException, DependencyFailedException, BadGatewayException, ThrottlingException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return Result of the Rerank operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankResponse rerank(Consumer<RerankRequest.Builder> rerankRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return rerank(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     *
     * @param rerankRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankIterable rerankPaginator(RerankRequest rerankRequest) throws ResourceNotFoundException, ConflictException,
            ValidationException, InternalServerException, DependencyFailedException, BadGatewayException, ThrottlingException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return new RerankIterable(this, rerankRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankIterable responses = client.rerankPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankIterable rerankPaginator(Consumer<RerankRequest.Builder> rerankRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return rerankPaginator(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     *
     * @param retrieveRequest
     * @return Result of the Retrieve operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveResponse retrieve(RetrieveRequest retrieveRequest) throws ResourceNotFoundException, ConflictException,
            ValidationException, InternalServerException, DependencyFailedException, BadGatewayException, ThrottlingException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return Result of the Retrieve operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveResponse retrieve(Consumer<RetrieveRequest.Builder> retrieveRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return retrieve(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     *
     * @param retrieveRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveIterable retrievePaginator(RetrieveRequest retrieveRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return new RetrieveIterable(this, retrieveRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrieveIterable responses = client.retrievePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveIterable retrievePaginator(Consumer<RetrieveRequest.Builder> retrieveRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return retrievePaginator(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     *
     * @param retrieveAndGenerateRequest
     * @return Result of the RetrieveAndGenerate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveAndGenerateResponse retrieveAndGenerate(RetrieveAndGenerateRequest retrieveAndGenerateRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveAndGenerateRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest.Builder} to
     *        create a request.
     * @return Result of the RetrieveAndGenerate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveAndGenerateResponse retrieveAndGenerate(
            Consumer<RetrieveAndGenerateRequest.Builder> retrieveAndGenerateRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, InternalServerException, DependencyFailedException, BadGatewayException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return retrieveAndGenerate(RetrieveAndGenerateRequest.builder().applyMutation(retrieveAndGenerateRequest).build());
    }

    /**
     * <p>
     * Starts an execution of an Amazon Bedrock flow. Unlike flows that run until completion or time out after five
     * minutes, flow executions let you run flows asynchronously for longer durations. Flow executions also yield
     * control so that your application can perform other tasks.
     * </p>
     * <p>
     * This operation returns an Amazon Resource Name (ARN) that you can use to track and manage your flow execution.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note>
     *
     * @param startFlowExecutionRequest
     * @return Result of the StartFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.StartFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/StartFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowExecutionResponse startFlowExecution(StartFlowExecutionRequest startFlowExecutionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an execution of an Amazon Bedrock flow. Unlike flows that run until completion or time out after five
     * minutes, flow executions let you run flows asynchronously for longer durations. Flow executions also yield
     * control so that your application can perform other tasks.
     * </p>
     * <p>
     * This operation returns an Amazon Resource Name (ARN) that you can use to track and manage your flow execution.
     * </p>
     * <note>
     * <p>
     * Flow executions is in preview release for Amazon Bedrock and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartFlowExecutionRequest#builder()}
     * </p>
     *
     * @param startFlowExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.StartFlowExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the StartFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.StartFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/StartFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowExecutionResponse startFlowExecution(Consumer<StartFlowExecutionRequest.Builder> startFlowExecutionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return startFlowExecution(StartFlowExecutionRequest.builder().applyMutation(startFlowExecutionRequest).build());
    }

    /**
     * <p>
     * Stops an Amazon Bedrock flow's execution. This operation prevents further processing of the flow and changes the
     * execution status to <code>Aborted</code>.
     * </p>
     *
     * @param stopFlowExecutionRequest
     * @return Result of the StopFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.StopFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/StopFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StopFlowExecutionResponse stopFlowExecution(StopFlowExecutionRequest stopFlowExecutionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an Amazon Bedrock flow's execution. This operation prevents further processing of the flow and changes the
     * execution status to <code>Aborted</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFlowExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link StopFlowExecutionRequest#builder()}
     * </p>
     *
     * @param stopFlowExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.StopFlowExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the StopFlowExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws DependencyFailedException
     *         There was an issue with a dependency. Check the resource configurations and retry the request.
     * @throws BadGatewayException
     *         There was an issue with a dependency due to a server issue. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.StopFlowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/StopFlowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StopFlowExecutionResponse stopFlowExecution(Consumer<StopFlowExecutionRequest.Builder> stopFlowExecutionRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            DependencyFailedException, BadGatewayException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        return stopFlowExecution(StopFlowExecutionRequest.builder().applyMutation(stopFlowExecutionRequest).build());
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the
     * Amazon Bedrock User Guide.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the
     * Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws ServiceQuotaExceededException
     *         The number of requests exceeds the service quota. Resubmit your request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            BedrockAgentRuntimeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the metadata or encryption settings of a session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param updateSessionRequest
     * @return Result of the UpdateSession operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UpdateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSessionResponse updateSession(UpdateSessionRequest updateSessionRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata or encryption settings of a session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSession operation returned by the service.
     * @throws ConflictException
     *         There was a conflict performing an operation. Resolve the conflict and retry your request.
     * @throws ResourceNotFoundException
     *         The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and
     *         try your request again.
     * @throws ValidationException
     *         Input validation failed. Check your request parameters and retry the request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ThrottlingException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws AccessDeniedException
     *         The request is denied because of missing access permissions. Check your permissions and retry your
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentRuntimeClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UpdateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSessionResponse updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockAgentRuntimeException {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    /**
     * Create a {@link BedrockAgentRuntimeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentRuntimeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentRuntimeClient}.
     */
    static BedrockAgentRuntimeClientBuilder builder() {
        return new DefaultBedrockAgentRuntimeClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BedrockAgentRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
