/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.AdditionalModelRequestFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorSearchBedrockRerankingModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorSearchBedrockRerankingModelConfiguration> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(VectorSearchBedrockRerankingModelConfiguration.getter(VectorSearchBedrockRerankingModelConfiguration::modelArn)).setter(VectorSearchBedrockRerankingModelConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalModelRequestFields").getter(VectorSearchBedrockRerankingModelConfiguration.getter(VectorSearchBedrockRerankingModelConfiguration::additionalModelRequestFields)).setter(VectorSearchBedrockRerankingModelConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VectorSearchBedrockRerankingModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelArn;
    private final Map<String, Document> additionalModelRequestFields;

    private VectorSearchBedrockRerankingModelConfiguration(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final boolean hasAdditionalModelRequestFields() {
        return this.additionalModelRequestFields != null && !(this.additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchBedrockRerankingModelConfiguration)) {
            return false;
        }
        VectorSearchBedrockRerankingModelConfiguration other = (VectorSearchBedrockRerankingModelConfiguration)obj;
        return Objects.equals(this.modelArn(), other.modelArn()) && this.hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields() && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields());
    }

    public final String toString() {
        return ToString.builder((String)"VectorSearchBedrockRerankingModelConfiguration").add("ModelArn", (Object)this.modelArn()).add("AdditionalModelRequestFields", this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchBedrockRerankingModelConfiguration, T> g) {
        return obj -> g.apply((VectorSearchBedrockRerankingModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelArn;
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchBedrockRerankingModelConfiguration model) {
            this.modelArn(model.modelArn);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (this.additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public VectorSearchBedrockRerankingModelConfiguration build() {
            return new VectorSearchBedrockRerankingModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorSearchBedrockRerankingModelConfiguration> {
        public Builder modelArn(String var1);

        public Builder additionalModelRequestFields(Map<String, Document> var1);
    }
}

