/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.MemoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgentMemoryRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, GetAgentMemoryRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::nextToken)).setter(GetAgentMemoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxItems").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::maxItems)).setter(GetAgentMemoryRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxItems").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::agentId)).setter(GetAgentMemoryRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::agentAliasId)).setter(GetAgentMemoryRequest.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> MEMORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryType").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::memoryTypeAsString)).setter(GetAgentMemoryRequest.setter(Builder::memoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memoryType").build()}).build();
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(GetAgentMemoryRequest.getter(GetAgentMemoryRequest::memoryId)).setter(GetAgentMemoryRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memoryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_ITEMS_FIELD, AGENT_ID_FIELD, AGENT_ALIAS_ID_FIELD, MEMORY_TYPE_FIELD, MEMORY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAgentMemoryRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxItems;
    private final String agentId;
    private final String agentAliasId;
    private final String memoryType;
    private final String memoryId;

    private GetAgentMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.memoryType = builder.memoryType;
        this.memoryId = builder.memoryId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final MemoryType memoryType() {
        return MemoryType.fromValue(this.memoryType);
    }

    public final String memoryTypeAsString() {
        return this.memoryType;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentMemoryRequest)) {
            return false;
        }
        GetAgentMemoryRequest other = (GetAgentMemoryRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.memoryTypeAsString(), other.memoryTypeAsString()) && Objects.equals(this.memoryId(), other.memoryId());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgentMemoryRequest").add("NextToken", (Object)this.nextToken()).add("MaxItems", (Object)this.maxItems()).add("AgentId", (Object)this.agentId()).add("AgentAliasId", (Object)this.agentAliasId()).add("MemoryType", (Object)this.memoryTypeAsString()).add("MemoryId", (Object)this.memoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "memoryType": {
                return Optional.ofNullable(clazz.cast(this.memoryTypeAsString()));
            }
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxItems", MAX_ITEMS_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("memoryType", MEMORY_TYPE_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentMemoryRequest, T> g) {
        return obj -> g.apply((GetAgentMemoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxItems;
        private String agentId;
        private String agentAliasId;
        private String memoryType;
        private String memoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentMemoryRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxItems(model.maxItems);
            this.agentId(model.agentId);
            this.agentAliasId(model.agentAliasId);
            this.memoryType(model.memoryType);
            this.memoryId(model.memoryId);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getMemoryType() {
            return this.memoryType;
        }

        public final void setMemoryType(String memoryType) {
            this.memoryType = memoryType;
        }

        @Override
        public final Builder memoryType(String memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Override
        public final Builder memoryType(MemoryType memoryType) {
            this.memoryType(memoryType == null ? null : memoryType.toString());
            return this;
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAgentMemoryRequest build() {
            return new GetAgentMemoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgentMemoryRequest> {
        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);

        public Builder agentId(String var1);

        public Builder agentAliasId(String var1);

        public Builder memoryType(String var1);

        public Builder memoryType(MemoryType var1);

        public Builder memoryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

