/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankDocument;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RerankSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RerankSource> {
    private static final SdkField<RerankDocument> INLINE_DOCUMENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineDocumentSource").getter(RerankSource.getter(RerankSource::inlineDocumentSource)).setter(RerankSource.setter(Builder::inlineDocumentSource)).constructor(RerankDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineDocumentSource").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RerankSource.getter(RerankSource::typeAsString)).setter(RerankSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_DOCUMENT_SOURCE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RerankSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RerankDocument inlineDocumentSource;
    private final String type;

    private RerankSource(BuilderImpl builder) {
        this.inlineDocumentSource = builder.inlineDocumentSource;
        this.type = builder.type;
    }

    public final RerankDocument inlineDocumentSource() {
        return this.inlineDocumentSource;
    }

    public final RerankSourceType type() {
        return RerankSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineDocumentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankSource)) {
            return false;
        }
        RerankSource other = (RerankSource)obj;
        return Objects.equals(this.inlineDocumentSource(), other.inlineDocumentSource()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RerankSource").add("InlineDocumentSource", (Object)(this.inlineDocumentSource() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inlineDocumentSource": {
                return Optional.ofNullable(clazz.cast(this.inlineDocumentSource()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inlineDocumentSource", INLINE_DOCUMENT_SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankSource, T> g) {
        return obj -> g.apply((RerankSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RerankDocument inlineDocumentSource;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankSource model) {
            this.inlineDocumentSource(model.inlineDocumentSource);
            this.type(model.type);
        }

        public final RerankDocument.Builder getInlineDocumentSource() {
            return this.inlineDocumentSource != null ? this.inlineDocumentSource.toBuilder() : null;
        }

        public final void setInlineDocumentSource(RerankDocument.BuilderImpl inlineDocumentSource) {
            this.inlineDocumentSource = inlineDocumentSource != null ? inlineDocumentSource.build() : null;
        }

        @Override
        public final Builder inlineDocumentSource(RerankDocument inlineDocumentSource) {
            this.inlineDocumentSource = inlineDocumentSource;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RerankSource build() {
            return new RerankSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RerankSource> {
        public Builder inlineDocumentSource(RerankDocument var1);

        default public Builder inlineDocumentSource(Consumer<RerankDocument.Builder> inlineDocumentSource) {
            return this.inlineDocumentSource((RerankDocument)((RerankDocument.Builder)RerankDocument.builder().applyMutation(inlineDocumentSource)).build());
        }

        public Builder type(String var1);

        public Builder type(RerankSourceType var1);
    }
}

