/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsResponse;

public class ListFlowExecutionsIterable
implements SdkIterable<ListFlowExecutionsResponse> {
    private final BedrockAgentRuntimeClient client;
    private final ListFlowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowExecutionsIterable(BedrockAgentRuntimeClient client, ListFlowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowExecutionsResponseFetcher();
    }

    public Iterator<ListFlowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowExecutionSummary> flowExecutionSummaries() {
        Function<ListFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutionSummaries() != null) {
                return response.flowExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowExecutionsResponseFetcher
    implements SyncPageFetcher<ListFlowExecutionsResponse> {
        private ListFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowExecutionsResponse nextPage(ListFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowExecutionsIterable.this.client.listFlowExecutions(ListFlowExecutionsIterable.this.firstRequest);
            }
            return ListFlowExecutionsIterable.this.client.listFlowExecutions((ListFlowExecutionsRequest)((Object)ListFlowExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

