/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationStepSummariesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationStepSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvocationStepsResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, ListInvocationStepsResponse> {
    private static final SdkField<List<InvocationStepSummary>> INVOCATION_STEP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invocationStepSummaries").getter(ListInvocationStepsResponse.getter(ListInvocationStepsResponse::invocationStepSummaries)).setter(ListInvocationStepsResponse.setter(Builder::invocationStepSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvocationStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInvocationStepsResponse.getter(ListInvocationStepsResponse::nextToken)).setter(ListInvocationStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_STEP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvocationStepsResponse.memberNameToFieldInitializer();
    private final List<InvocationStepSummary> invocationStepSummaries;
    private final String nextToken;

    private ListInvocationStepsResponse(BuilderImpl builder) {
        super(builder);
        this.invocationStepSummaries = builder.invocationStepSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInvocationStepSummaries() {
        return this.invocationStepSummaries != null && !(this.invocationStepSummaries instanceof SdkAutoConstructList);
    }

    public final List<InvocationStepSummary> invocationStepSummaries() {
        return this.invocationStepSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvocationStepSummaries() ? this.invocationStepSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvocationStepsResponse)) {
            return false;
        }
        ListInvocationStepsResponse other = (ListInvocationStepsResponse)((Object)obj);
        return this.hasInvocationStepSummaries() == other.hasInvocationStepSummaries() && Objects.equals(this.invocationStepSummaries(), other.invocationStepSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvocationStepsResponse").add("InvocationStepSummaries", this.hasInvocationStepSummaries() ? this.invocationStepSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationStepSummaries": {
                return Optional.ofNullable(clazz.cast(this.invocationStepSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invocationStepSummaries", INVOCATION_STEP_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvocationStepsResponse, T> g) {
        return obj -> g.apply((ListInvocationStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<InvocationStepSummary> invocationStepSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvocationStepsResponse model) {
            super(model);
            this.invocationStepSummaries(model.invocationStepSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InvocationStepSummary.Builder> getInvocationStepSummaries() {
            List<InvocationStepSummary.Builder> result = InvocationStepSummariesCopier.copyToBuilder(this.invocationStepSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationStepSummaries(Collection<InvocationStepSummary.BuilderImpl> invocationStepSummaries) {
            this.invocationStepSummaries = InvocationStepSummariesCopier.copyFromBuilder(invocationStepSummaries);
        }

        @Override
        public final Builder invocationStepSummaries(Collection<InvocationStepSummary> invocationStepSummaries) {
            this.invocationStepSummaries = InvocationStepSummariesCopier.copy(invocationStepSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationStepSummaries(InvocationStepSummary ... invocationStepSummaries) {
            this.invocationStepSummaries(Arrays.asList(invocationStepSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationStepSummaries(Consumer<InvocationStepSummary.Builder> ... invocationStepSummaries) {
            this.invocationStepSummaries(Stream.of(invocationStepSummaries).map(c -> (InvocationStepSummary)((InvocationStepSummary.Builder)InvocationStepSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvocationStepsResponse build() {
            return new ListInvocationStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvocationStepsResponse> {
        public Builder invocationStepSummaries(Collection<InvocationStepSummary> var1);

        public Builder invocationStepSummaries(InvocationStepSummary ... var1);

        public Builder invocationStepSummaries(Consumer<InvocationStepSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

