/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowExecutionEventsResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, ListFlowExecutionEventsResponse> {
    private static final SdkField<List<FlowExecutionEvent>> FLOW_EXECUTION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowExecutionEvents").getter(ListFlowExecutionEventsResponse.getter(ListFlowExecutionEventsResponse::flowExecutionEvents)).setter(ListFlowExecutionEventsResponse.setter(Builder::flowExecutionEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowExecutionEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowExecutionEventsResponse.getter(ListFlowExecutionEventsResponse::nextToken)).setter(ListFlowExecutionEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTION_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowExecutionEventsResponse.memberNameToFieldInitializer();
    private final List<FlowExecutionEvent> flowExecutionEvents;
    private final String nextToken;

    private ListFlowExecutionEventsResponse(BuilderImpl builder) {
        super(builder);
        this.flowExecutionEvents = builder.flowExecutionEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowExecutionEvents() {
        return this.flowExecutionEvents != null && !(this.flowExecutionEvents instanceof SdkAutoConstructList);
    }

    public final List<FlowExecutionEvent> flowExecutionEvents() {
        return this.flowExecutionEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowExecutionEvents() ? this.flowExecutionEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionEventsResponse)) {
            return false;
        }
        ListFlowExecutionEventsResponse other = (ListFlowExecutionEventsResponse)((Object)obj);
        return this.hasFlowExecutionEvents() == other.hasFlowExecutionEvents() && Objects.equals(this.flowExecutionEvents(), other.flowExecutionEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowExecutionEventsResponse").add("FlowExecutionEvents", this.hasFlowExecutionEvents() ? this.flowExecutionEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowExecutionEvents": {
                return Optional.ofNullable(clazz.cast(this.flowExecutionEvents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowExecutionEvents", FLOW_EXECUTION_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionEventsResponse, T> g) {
        return obj -> g.apply((ListFlowExecutionEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<FlowExecutionEvent> flowExecutionEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionEventsResponse model) {
            super(model);
            this.flowExecutionEvents(model.flowExecutionEvents);
            this.nextToken(model.nextToken);
        }

        public final List<FlowExecutionEvent.Builder> getFlowExecutionEvents() {
            List<FlowExecutionEvent.Builder> result = FlowExecutionEventsCopier.copyToBuilder(this.flowExecutionEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowExecutionEvents(Collection<FlowExecutionEvent.BuilderImpl> flowExecutionEvents) {
            this.flowExecutionEvents = FlowExecutionEventsCopier.copyFromBuilder(flowExecutionEvents);
        }

        @Override
        public final Builder flowExecutionEvents(Collection<FlowExecutionEvent> flowExecutionEvents) {
            this.flowExecutionEvents = FlowExecutionEventsCopier.copy(flowExecutionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionEvents(FlowExecutionEvent ... flowExecutionEvents) {
            this.flowExecutionEvents(Arrays.asList(flowExecutionEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionEvents(Consumer<FlowExecutionEvent.Builder> ... flowExecutionEvents) {
            this.flowExecutionEvents(Stream.of(flowExecutionEvents).map(c -> (FlowExecutionEvent)((FlowExecutionEvent.Builder)FlowExecutionEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowExecutionEventsResponse build() {
            return new ListFlowExecutionEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowExecutionEventsResponse> {
        public Builder flowExecutionEvents(Collection<FlowExecutionEvent> var1);

        public Builder flowExecutionEvents(FlowExecutionEvent ... var1);

        public Builder flowExecutionEvents(Consumer<FlowExecutionEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

