/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroupsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentCollaboration;
import software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfigurationsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailConfigurationWithArn;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBasesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Collaborator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Collaborator> {
    private static final SdkField<List<AgentActionGroup>> ACTION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionGroups").getter(Collaborator.getter(Collaborator::actionGroups)).setter(Collaborator.setter(Builder::actionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentActionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentCollaboration").getter(Collaborator.getter(Collaborator::agentCollaborationAsString)).setter(Collaborator.setter(Builder::agentCollaboration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build()}).build();
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentName").getter(Collaborator.getter(Collaborator::agentName)).setter(Collaborator.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()}).build();
    private static final SdkField<List<CollaboratorConfiguration>> COLLABORATOR_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaboratorConfigurations").getter(Collaborator.getter(Collaborator::collaboratorConfigurations)).setter(Collaborator.setter(Builder::collaboratorConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaboratorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(Collaborator.getter(Collaborator::customerEncryptionKeyArn)).setter(Collaborator.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModel").getter(Collaborator.getter(Collaborator::foundationModel)).setter(Collaborator.setter(Builder::foundationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()}).build();
    private static final SdkField<GuardrailConfigurationWithArn> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(Collaborator.getter(Collaborator::guardrailConfiguration)).setter(Collaborator.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfigurationWithArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(Collaborator.getter(Collaborator::idleSessionTTLInSeconds)).setter(Collaborator.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(Collaborator.getter(Collaborator::instruction)).setter(Collaborator.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<List<KnowledgeBase>> KNOWLEDGE_BASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("knowledgeBases").getter(Collaborator.getter(Collaborator::knowledgeBases)).setter(Collaborator.setter(Builder::knowledgeBases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KnowledgeBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptOverrideConfiguration").getter(Collaborator.getter(Collaborator::promptOverrideConfiguration)).setter(Collaborator.setter(Builder::promptOverrideConfiguration)).constructor(PromptOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUPS_FIELD, AGENT_COLLABORATION_FIELD, AGENT_NAME_FIELD, COLLABORATOR_CONFIGURATIONS_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INSTRUCTION_FIELD, KNOWLEDGE_BASES_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collaborator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AgentActionGroup> actionGroups;
    private final String agentCollaboration;
    private final String agentName;
    private final List<CollaboratorConfiguration> collaboratorConfigurations;
    private final String customerEncryptionKeyArn;
    private final String foundationModel;
    private final GuardrailConfigurationWithArn guardrailConfiguration;
    private final Integer idleSessionTTLInSeconds;
    private final String instruction;
    private final List<KnowledgeBase> knowledgeBases;
    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private Collaborator(BuilderImpl builder) {
        this.actionGroups = builder.actionGroups;
        this.agentCollaboration = builder.agentCollaboration;
        this.agentName = builder.agentName;
        this.collaboratorConfigurations = builder.collaboratorConfigurations;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.instruction = builder.instruction;
        this.knowledgeBases = builder.knowledgeBases;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
    }

    public final boolean hasActionGroups() {
        return this.actionGroups != null && !(this.actionGroups instanceof SdkAutoConstructList);
    }

    public final List<AgentActionGroup> actionGroups() {
        return this.actionGroups;
    }

    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(this.agentCollaboration);
    }

    public final String agentCollaborationAsString() {
        return this.agentCollaboration;
    }

    public final String agentName() {
        return this.agentName;
    }

    public final boolean hasCollaboratorConfigurations() {
        return this.collaboratorConfigurations != null && !(this.collaboratorConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CollaboratorConfiguration> collaboratorConfigurations() {
        return this.collaboratorConfigurations;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String foundationModel() {
        return this.foundationModel;
    }

    public final GuardrailConfigurationWithArn guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final boolean hasKnowledgeBases() {
        return this.knowledgeBases != null && !(this.knowledgeBases instanceof SdkAutoConstructList);
    }

    public final List<KnowledgeBase> knowledgeBases() {
        return this.knowledgeBases;
    }

    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return this.promptOverrideConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionGroups() ? this.actionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.agentCollaborationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaboratorConfigurations() ? this.collaboratorConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKnowledgeBases() ? this.knowledgeBases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.promptOverrideConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collaborator)) {
            return false;
        }
        Collaborator other = (Collaborator)obj;
        return this.hasActionGroups() == other.hasActionGroups() && Objects.equals(this.actionGroups(), other.actionGroups()) && Objects.equals(this.agentCollaborationAsString(), other.agentCollaborationAsString()) && Objects.equals(this.agentName(), other.agentName()) && this.hasCollaboratorConfigurations() == other.hasCollaboratorConfigurations() && Objects.equals(this.collaboratorConfigurations(), other.collaboratorConfigurations()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.foundationModel(), other.foundationModel()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.instruction(), other.instruction()) && this.hasKnowledgeBases() == other.hasKnowledgeBases() && Objects.equals(this.knowledgeBases(), other.knowledgeBases()) && Objects.equals(this.promptOverrideConfiguration(), other.promptOverrideConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Collaborator").add("ActionGroups", this.hasActionGroups() ? this.actionGroups() : null).add("AgentCollaboration", (Object)this.agentCollaborationAsString()).add("AgentName", (Object)(this.agentName() == null ? null : "*** Sensitive Data Redacted ***")).add("CollaboratorConfigurations", this.hasCollaboratorConfigurations() ? this.collaboratorConfigurations() : null).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("FoundationModel", (Object)this.foundationModel()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("KnowledgeBases", this.hasKnowledgeBases() ? this.knowledgeBases() : null).add("PromptOverrideConfiguration", (Object)(this.promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroups": {
                return Optional.ofNullable(clazz.cast(this.actionGroups()));
            }
            case "agentCollaboration": {
                return Optional.ofNullable(clazz.cast(this.agentCollaborationAsString()));
            }
            case "agentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "collaboratorConfigurations": {
                return Optional.ofNullable(clazz.cast(this.collaboratorConfigurations()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "foundationModel": {
                return Optional.ofNullable(clazz.cast(this.foundationModel()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "knowledgeBases": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBases()));
            }
            case "promptOverrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.promptOverrideConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroups", ACTION_GROUPS_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("collaboratorConfigurations", COLLABORATOR_CONFIGURATIONS_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("knowledgeBases", KNOWLEDGE_BASES_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Collaborator, T> g) {
        return obj -> g.apply((Collaborator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AgentActionGroup> actionGroups = DefaultSdkAutoConstructList.getInstance();
        private String agentCollaboration;
        private String agentName;
        private List<CollaboratorConfiguration> collaboratorConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String customerEncryptionKeyArn;
        private String foundationModel;
        private GuardrailConfigurationWithArn guardrailConfiguration;
        private Integer idleSessionTTLInSeconds;
        private String instruction;
        private List<KnowledgeBase> knowledgeBases = DefaultSdkAutoConstructList.getInstance();
        private PromptOverrideConfiguration promptOverrideConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Collaborator model) {
            this.actionGroups(model.actionGroups);
            this.agentCollaboration(model.agentCollaboration);
            this.agentName(model.agentName);
            this.collaboratorConfigurations(model.collaboratorConfigurations);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.foundationModel(model.foundationModel);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.instruction(model.instruction);
            this.knowledgeBases(model.knowledgeBases);
            this.promptOverrideConfiguration(model.promptOverrideConfiguration);
        }

        public final List<AgentActionGroup.Builder> getActionGroups() {
            List<AgentActionGroup.Builder> result = AgentActionGroupsCopier.copyToBuilder(this.actionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroups(Collection<AgentActionGroup.BuilderImpl> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copyFromBuilder(actionGroups);
        }

        @Override
        public final Builder actionGroups(Collection<AgentActionGroup> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copy(actionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(AgentActionGroup ... actionGroups) {
            this.actionGroups(Arrays.asList(actionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(Consumer<AgentActionGroup.Builder> ... actionGroups) {
            this.actionGroups(Stream.of(actionGroups).map(c -> (AgentActionGroup)((AgentActionGroup.Builder)AgentActionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAgentCollaboration() {
            return this.agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final List<CollaboratorConfiguration.Builder> getCollaboratorConfigurations() {
            List<CollaboratorConfiguration.Builder> result = CollaboratorConfigurationsCopier.copyToBuilder(this.collaboratorConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaboratorConfigurations(Collection<CollaboratorConfiguration.BuilderImpl> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copyFromBuilder(collaboratorConfigurations);
        }

        @Override
        public final Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copy(collaboratorConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(CollaboratorConfiguration ... collaboratorConfigurations) {
            this.collaboratorConfigurations(Arrays.asList(collaboratorConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder> ... collaboratorConfigurations) {
            this.collaboratorConfigurations(Stream.of(collaboratorConfigurations).map(c -> (CollaboratorConfiguration)((CollaboratorConfiguration.Builder)CollaboratorConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getFoundationModel() {
            return this.foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfigurationWithArn.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfigurationWithArn.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<KnowledgeBase.Builder> getKnowledgeBases() {
            List<KnowledgeBase.Builder> result = KnowledgeBasesCopier.copyToBuilder(this.knowledgeBases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBases(Collection<KnowledgeBase.BuilderImpl> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copyFromBuilder(knowledgeBases);
        }

        @Override
        public final Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copy(knowledgeBases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(KnowledgeBase ... knowledgeBases) {
            this.knowledgeBases(Arrays.asList(knowledgeBases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(Consumer<KnowledgeBase.Builder> ... knowledgeBases) {
            this.knowledgeBases(Stream.of(knowledgeBases).map(c -> (KnowledgeBase)((KnowledgeBase.Builder)KnowledgeBase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public Collaborator build() {
            return new Collaborator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Collaborator> {
        public Builder actionGroups(Collection<AgentActionGroup> var1);

        public Builder actionGroups(AgentActionGroup ... var1);

        public Builder actionGroups(Consumer<AgentActionGroup.Builder> ... var1);

        public Builder agentCollaboration(String var1);

        public Builder agentCollaboration(AgentCollaboration var1);

        public Builder agentName(String var1);

        public Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> var1);

        public Builder collaboratorConfigurations(CollaboratorConfiguration ... var1);

        public Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder> ... var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder foundationModel(String var1);

        public Builder guardrailConfiguration(GuardrailConfigurationWithArn var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfigurationWithArn.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfigurationWithArn)((GuardrailConfigurationWithArn.Builder)GuardrailConfigurationWithArn.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder instruction(String var1);

        public Builder knowledgeBases(Collection<KnowledgeBase> var1);

        public Builder knowledgeBases(KnowledgeBase ... var1);

        public Builder knowledgeBases(Consumer<KnowledgeBase.Builder> ... var1);

        public Builder promptOverrideConfiguration(PromptOverrideConfiguration var1);

        default public Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return this.promptOverrideConfiguration((PromptOverrideConfiguration)((PromptOverrideConfiguration.Builder)PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)).build());
        }
    }
}

