/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.PayloadType;
import software.amazon.awssdk.services.bedrockagentruntime.model.ReturnControlResults;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentCollaboratorInputPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentCollaboratorInputPayload> {
    private static final SdkField<ReturnControlResults> RETURN_CONTROL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("returnControlResults").getter(AgentCollaboratorInputPayload.getter(AgentCollaboratorInputPayload::returnControlResults)).setter(AgentCollaboratorInputPayload.setter(Builder::returnControlResults)).constructor(ReturnControlResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlResults").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(AgentCollaboratorInputPayload.getter(AgentCollaboratorInputPayload::text)).setter(AgentCollaboratorInputPayload.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AgentCollaboratorInputPayload.getter(AgentCollaboratorInputPayload::typeAsString)).setter(AgentCollaboratorInputPayload.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_CONTROL_RESULTS_FIELD, TEXT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentCollaboratorInputPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReturnControlResults returnControlResults;
    private final String text;
    private final String type;

    private AgentCollaboratorInputPayload(BuilderImpl builder) {
        this.returnControlResults = builder.returnControlResults;
        this.text = builder.text;
        this.type = builder.type;
    }

    public final ReturnControlResults returnControlResults() {
        return this.returnControlResults;
    }

    public final String text() {
        return this.text;
    }

    public final PayloadType type() {
        return PayloadType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.returnControlResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaboratorInputPayload)) {
            return false;
        }
        AgentCollaboratorInputPayload other = (AgentCollaboratorInputPayload)obj;
        return Objects.equals(this.returnControlResults(), other.returnControlResults()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AgentCollaboratorInputPayload").add("ReturnControlResults", (Object)this.returnControlResults()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "returnControlResults": {
                return Optional.ofNullable(clazz.cast(this.returnControlResults()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("returnControlResults", RETURN_CONTROL_RESULTS_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaboratorInputPayload, T> g) {
        return obj -> g.apply((AgentCollaboratorInputPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReturnControlResults returnControlResults;
        private String text;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaboratorInputPayload model) {
            this.returnControlResults(model.returnControlResults);
            this.text(model.text);
            this.type(model.type);
        }

        public final ReturnControlResults.Builder getReturnControlResults() {
            return this.returnControlResults != null ? this.returnControlResults.toBuilder() : null;
        }

        public final void setReturnControlResults(ReturnControlResults.BuilderImpl returnControlResults) {
            this.returnControlResults = returnControlResults != null ? returnControlResults.build() : null;
        }

        @Override
        public final Builder returnControlResults(ReturnControlResults returnControlResults) {
            this.returnControlResults = returnControlResults;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PayloadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public AgentCollaboratorInputPayload build() {
            return new AgentCollaboratorInputPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentCollaboratorInputPayload> {
        public Builder returnControlResults(ReturnControlResults var1);

        default public Builder returnControlResults(Consumer<ReturnControlResults.Builder> returnControlResults) {
            return this.returnControlResults((ReturnControlResults)((ReturnControlResults.Builder)ReturnControlResults.builder().applyMutation(returnControlResults)).build());
        }

        public Builder text(String var1);

        public Builder type(String var1);

        public Builder type(PayloadType var1);
    }
}

