/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;

public class RetrieveIterable
implements SdkIterable<RetrieveResponse> {
    private final BedrockAgentRuntimeClient client;
    private final RetrieveRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public RetrieveIterable(BedrockAgentRuntimeClient client, RetrieveRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new RetrieveResponseFetcher();
    }

    public Iterator<RetrieveResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KnowledgeBaseRetrievalResult> retrievalResults() {
        Function<RetrieveResponse, Iterator> getIterator = response -> {
            if (response != null && response.retrievalResults() != null) {
                return response.retrievalResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class RetrieveResponseFetcher
    implements SyncPageFetcher<RetrieveResponse> {
        private RetrieveResponseFetcher() {
        }

        public boolean hasNextPage(RetrieveResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public RetrieveResponse nextPage(RetrieveResponse previousPage) {
            if (previousPage == null) {
                return RetrieveIterable.this.client.retrieve(RetrieveIterable.this.firstRequest);
            }
            return RetrieveIterable.this.client.retrieve((RetrieveRequest)((Object)RetrieveIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

