/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.ImageInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.ImageInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBody> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(ContentBody.getter(ContentBody::body)).setter(ContentBody.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<List<ImageInput>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("images").getter(ContentBody.getter(ContentBody::images)).setter(ContentBody.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, IMAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final List<ImageInput> images;

    private ContentBody(BuilderImpl builder) {
        this.body = builder.body;
        this.images = builder.images;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public final List<ImageInput> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBody)) {
            return false;
        }
        ContentBody other = (ContentBody)obj;
        return Objects.equals(this.body(), other.body()) && this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBody").add("Body", (Object)this.body()).add("Images", this.hasImages() ? this.images() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("body", BODY_FIELD);
        map.put("images", IMAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBody, T> g) {
        return obj -> g.apply((ContentBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private List<ImageInput> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBody model) {
            this.body(model.body);
            this.images(model.images);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final List<ImageInput.Builder> getImages() {
            List<ImageInput.Builder> result = ImageInputsCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<ImageInput.BuilderImpl> images) {
            this.images = ImageInputsCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<ImageInput> images) {
            this.images = ImageInputsCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(ImageInput ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<ImageInput.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (ImageInput)((ImageInput.Builder)ImageInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContentBody build() {
            return new ContentBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBody> {
        public Builder body(String var1);

        public Builder images(Collection<ImageInput> var1);

        public Builder images(ImageInput ... var1);

        public Builder images(Consumer<ImageInput.Builder> ... var1);
    }
}

