/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.Citation;
import software.amazon.awssdk.services.bedrockagentruntime.model.GeneratedResponsePart;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseOutput;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CitationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CitationEvent>,
RetrieveAndGenerateStreamResponseOutput {
    private static final SdkField<Citation> CITATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citation").getter(CitationEvent.getter(CitationEvent::citation)).setter(CitationEvent.setter(Builder::citation)).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citation").build()}).build();
    private static final SdkField<GeneratedResponsePart> GENERATED_RESPONSE_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generatedResponsePart").getter(CitationEvent.getter(CitationEvent::generatedResponsePart)).setter(CitationEvent.setter(Builder::generatedResponsePart)).constructor(GeneratedResponsePart::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedResponsePart").build()}).build();
    private static final SdkField<List<RetrievedReference>> RETRIEVED_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retrievedReferences").getter(CitationEvent.getter(CitationEvent::retrievedReferences)).setter(CitationEvent.setter(Builder::retrievedReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievedReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrievedReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATION_FIELD, GENERATED_RESPONSE_PART_FIELD, RETRIEVED_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CitationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Citation citation;
    private final GeneratedResponsePart generatedResponsePart;
    private final List<RetrievedReference> retrievedReferences;

    protected CitationEvent(BuilderImpl builder) {
        this.citation = builder.citation;
        this.generatedResponsePart = builder.generatedResponsePart;
        this.retrievedReferences = builder.retrievedReferences;
    }

    @Deprecated
    public final Citation citation() {
        return this.citation;
    }

    public final GeneratedResponsePart generatedResponsePart() {
        return this.generatedResponsePart;
    }

    public final boolean hasRetrievedReferences() {
        return this.retrievedReferences != null && !(this.retrievedReferences instanceof SdkAutoConstructList);
    }

    public final List<RetrievedReference> retrievedReferences() {
        return this.retrievedReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.citation());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedResponsePart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrievedReferences() ? this.retrievedReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationEvent)) {
            return false;
        }
        CitationEvent other = (CitationEvent)obj;
        return Objects.equals(this.citation(), other.citation()) && Objects.equals(this.generatedResponsePart(), other.generatedResponsePart()) && this.hasRetrievedReferences() == other.hasRetrievedReferences() && Objects.equals(this.retrievedReferences(), other.retrievedReferences());
    }

    public final String toString() {
        return ToString.builder((String)"CitationEvent").add("Citation", (Object)this.citation()).add("GeneratedResponsePart", (Object)this.generatedResponsePart()).add("RetrievedReferences", this.hasRetrievedReferences() ? this.retrievedReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "citation": {
                return Optional.ofNullable(clazz.cast(this.citation()));
            }
            case "generatedResponsePart": {
                return Optional.ofNullable(clazz.cast(this.generatedResponsePart()));
            }
            case "retrievedReferences": {
                return Optional.ofNullable(clazz.cast(this.retrievedReferences()));
            }
        }
        return Optional.empty();
    }

    public final CitationEvent copy(Consumer<? super Builder> modifier) {
        return (CitationEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("citation", CITATION_FIELD);
        map.put("generatedResponsePart", GENERATED_RESPONSE_PART_FIELD);
        map.put("retrievedReferences", RETRIEVED_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationEvent, T> g) {
        return obj -> g.apply((CitationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(RetrieveAndGenerateStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private Citation citation;
        private GeneratedResponsePart generatedResponsePart;
        private List<RetrievedReference> retrievedReferences = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(CitationEvent model) {
            this.citation(model.citation);
            this.generatedResponsePart(model.generatedResponsePart);
            this.retrievedReferences(model.retrievedReferences);
        }

        @Deprecated
        public final Citation.Builder getCitation() {
            return this.citation != null ? this.citation.toBuilder() : null;
        }

        @Deprecated
        public final void setCitation(Citation.BuilderImpl citation) {
            this.citation = citation != null ? citation.build() : null;
        }

        @Override
        @Deprecated
        public final Builder citation(Citation citation) {
            this.citation = citation;
            return this;
        }

        public final GeneratedResponsePart.Builder getGeneratedResponsePart() {
            return this.generatedResponsePart != null ? this.generatedResponsePart.toBuilder() : null;
        }

        public final void setGeneratedResponsePart(GeneratedResponsePart.BuilderImpl generatedResponsePart) {
            this.generatedResponsePart = generatedResponsePart != null ? generatedResponsePart.build() : null;
        }

        @Override
        public final Builder generatedResponsePart(GeneratedResponsePart generatedResponsePart) {
            this.generatedResponsePart = generatedResponsePart;
            return this;
        }

        public final List<RetrievedReference.Builder> getRetrievedReferences() {
            List<RetrievedReference.Builder> result = RetrievedReferencesCopier.copyToBuilder(this.retrievedReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievedReferences(Collection<RetrievedReference.BuilderImpl> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copyFromBuilder(retrievedReferences);
        }

        @Override
        public final Builder retrievedReferences(Collection<RetrievedReference> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copy(retrievedReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(RetrievedReference ... retrievedReferences) {
            this.retrievedReferences(Arrays.asList(retrievedReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(Consumer<RetrievedReference.Builder> ... retrievedReferences) {
            this.retrievedReferences(Stream.of(retrievedReferences).map(c -> (RetrievedReference)((RetrievedReference.Builder)RetrievedReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CitationEvent build() {
            return new CitationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CitationEvent> {
        @Deprecated
        public Builder citation(Citation var1);

        @Deprecated
        default public Builder citation(Consumer<Citation.Builder> citation) {
            return this.citation((Citation)((Citation.Builder)Citation.builder().applyMutation(citation)).build());
        }

        public Builder generatedResponsePart(GeneratedResponsePart var1);

        default public Builder generatedResponsePart(Consumer<GeneratedResponsePart.Builder> generatedResponsePart) {
            return this.generatedResponsePart((GeneratedResponsePart)((GeneratedResponsePart.Builder)GeneratedResponsePart.builder().applyMutation(generatedResponsePart)).build());
        }

        public Builder retrievedReferences(Collection<RetrievedReference> var1);

        public Builder retrievedReferences(RetrievedReference ... var1);

        public Builder retrievedReferences(Consumer<RetrievedReference.Builder> ... var1);
    }
}

