/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.ApiContentMapCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.PropertyParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiRequestBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiRequestBody> {
    private static final SdkField<Map<String, PropertyParameters>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("content").getter(ApiRequestBody.getter(ApiRequestBody::content)).setter(ApiRequestBody.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiRequestBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, PropertyParameters> content;

    private ApiRequestBody(BuilderImpl builder) {
        this.content = builder.content;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyParameters> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiRequestBody)) {
            return false;
        }
        ApiRequestBody other = (ApiRequestBody)obj;
        return this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"ApiRequestBody").add("Content", this.hasContent() ? this.content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, PropertyParameters>>> map = new HashMap<String, SdkField<Map<String, PropertyParameters>>>();
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiRequestBody, T> g) {
        return obj -> g.apply((ApiRequestBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, PropertyParameters> content = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiRequestBody model) {
            this.content(model.content);
        }

        public final Map<String, PropertyParameters.Builder> getContent() {
            Map<String, PropertyParameters.Builder> result = ApiContentMapCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContent(Map<String, PropertyParameters.BuilderImpl> content) {
            this.content = ApiContentMapCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Map<String, PropertyParameters> content) {
            this.content = ApiContentMapCopier.copy(content);
            return this;
        }

        public ApiRequestBody build() {
            return new ApiRequestBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiRequestBody> {
        public Builder content(Map<String, PropertyParameters> var1);
    }
}

