/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionInvocationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionInvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroup").getter(FunctionInvocationInput.getter(FunctionInvocationInput::actionGroup)).setter(FunctionInvocationInput.setter(Builder::actionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()}).build();
    private static final SdkField<String> ACTION_INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionInvocationType").getter(FunctionInvocationInput.getter(FunctionInvocationInput::actionInvocationTypeAsString)).setter(FunctionInvocationInput.setter(Builder::actionInvocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInvocationType").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(FunctionInvocationInput.getter(FunctionInvocationInput::agentId)).setter(FunctionInvocationInput.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorName").getter(FunctionInvocationInput.getter(FunctionInvocationInput::collaboratorName)).setter(FunctionInvocationInput.setter(Builder::collaboratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(FunctionInvocationInput.getter(FunctionInvocationInput::function)).setter(FunctionInvocationInput.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final SdkField<List<FunctionParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(FunctionInvocationInput.getter(FunctionInvocationInput::parameters)).setter(FunctionInvocationInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD, ACTION_INVOCATION_TYPE_FIELD, AGENT_ID_FIELD, COLLABORATOR_NAME_FIELD, FUNCTION_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionInvocationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionGroup;
    private final String actionInvocationType;
    private final String agentId;
    private final String collaboratorName;
    private final String function;
    private final List<FunctionParameter> parameters;

    private FunctionInvocationInput(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.actionInvocationType = builder.actionInvocationType;
        this.agentId = builder.agentId;
        this.collaboratorName = builder.collaboratorName;
        this.function = builder.function;
        this.parameters = builder.parameters;
    }

    public final String actionGroup() {
        return this.actionGroup;
    }

    public final ActionInvocationType actionInvocationType() {
        return ActionInvocationType.fromValue(this.actionInvocationType);
    }

    public final String actionInvocationTypeAsString() {
        return this.actionInvocationType;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String collaboratorName() {
        return this.collaboratorName;
    }

    public final String function() {
        return this.function;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<FunctionParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionInvocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionInvocationInput)) {
            return false;
        }
        FunctionInvocationInput other = (FunctionInvocationInput)obj;
        return Objects.equals(this.actionGroup(), other.actionGroup()) && Objects.equals(this.actionInvocationTypeAsString(), other.actionInvocationTypeAsString()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.collaboratorName(), other.collaboratorName()) && Objects.equals(this.function(), other.function()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionInvocationInput").add("ActionGroup", (Object)this.actionGroup()).add("ActionInvocationType", (Object)this.actionInvocationTypeAsString()).add("AgentId", (Object)this.agentId()).add("CollaboratorName", (Object)(this.collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")).add("Function", (Object)this.function()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroup": {
                return Optional.ofNullable(clazz.cast(this.actionGroup()));
            }
            case "actionInvocationType": {
                return Optional.ofNullable(clazz.cast(this.actionInvocationTypeAsString()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "collaboratorName": {
                return Optional.ofNullable(clazz.cast(this.collaboratorName()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroup", ACTION_GROUP_FIELD);
        map.put("actionInvocationType", ACTION_INVOCATION_TYPE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("function", FUNCTION_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionInvocationInput, T> g) {
        return obj -> g.apply((FunctionInvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroup;
        private String actionInvocationType;
        private String agentId;
        private String collaboratorName;
        private String function;
        private List<FunctionParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionInvocationInput model) {
            this.actionGroup(model.actionGroup);
            this.actionInvocationType(model.actionInvocationType);
            this.agentId(model.agentId);
            this.collaboratorName(model.collaboratorName);
            this.function(model.function);
            this.parameters(model.parameters);
        }

        public final String getActionGroup() {
            return this.actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getActionInvocationType() {
            return this.actionInvocationType;
        }

        public final void setActionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
        }

        @Override
        public final Builder actionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
            return this;
        }

        @Override
        public final Builder actionInvocationType(ActionInvocationType actionInvocationType) {
            this.actionInvocationType(actionInvocationType == null ? null : actionInvocationType.toString());
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getCollaboratorName() {
            return this.collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<FunctionParameter.Builder> getParameters() {
            List<FunctionParameter.Builder> result = FunctionParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<FunctionParameter.BuilderImpl> parameters) {
            this.parameters = FunctionParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<FunctionParameter> parameters) {
            this.parameters = FunctionParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(FunctionParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<FunctionParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (FunctionParameter)((FunctionParameter.Builder)FunctionParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FunctionInvocationInput build() {
            return new FunctionInvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionInvocationInput> {
        public Builder actionGroup(String var1);

        public Builder actionInvocationType(String var1);

        public Builder actionInvocationType(ActionInvocationType var1);

        public Builder agentId(String var1);

        public Builder collaboratorName(String var1);

        public Builder function(String var1);

        public Builder parameters(Collection<FunctionParameter> var1);

        public Builder parameters(FunctionParameter ... var1);

        public Builder parameters(Consumer<FunctionParameter.Builder> ... var1);
    }
}

