/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionMetadataMapCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, CreateSessionRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyArn").getter(CreateSessionRequest.getter(CreateSessionRequest::encryptionKeyArn)).setter(CreateSessionRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> SESSION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionMetadata").getter(CreateSessionRequest.getter(CreateSessionRequest::sessionMetadata)).setter(CreateSessionRequest.setter(Builder::sessionMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSessionRequest.getter(CreateSessionRequest::tags)).setter(CreateSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_ARN_FIELD, SESSION_METADATA_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSessionRequest.memberNameToFieldInitializer();
    private final String encryptionKeyArn;
    private final Map<String, String> sessionMetadata;
    private final Map<String, String> tags;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.sessionMetadata = builder.sessionMetadata;
        this.tags = builder.tags;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final boolean hasSessionMetadata() {
        return this.sessionMetadata != null && !(this.sessionMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionMetadata() {
        return this.sessionMetadata;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionMetadata() ? this.sessionMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)obj);
        return Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && this.hasSessionMetadata() == other.hasSessionMetadata() && Objects.equals(this.sessionMetadata(), other.sessionMetadata()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionRequest").add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("SessionMetadata", this.hasSessionMetadata() ? this.sessionMetadata() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "sessionMetadata": {
                return Optional.ofNullable(clazz.cast(this.sessionMetadata()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("sessionMetadata", SESSION_METADATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String encryptionKeyArn;
        private Map<String, String> sessionMetadata = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.sessionMetadata(model.sessionMetadata);
            this.tags(model.tags);
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Map<String, String> getSessionMetadata() {
            if (this.sessionMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionMetadata;
        }

        public final void setSessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
        }

        @Override
        public final Builder sessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionRequest> {
        public Builder encryptionKeyArn(String var1);

        public Builder sessionMetadata(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

