/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionState;
import software.amazon.awssdk.services.bedrockagentruntime.model.StreamingConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeAgentRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeAgentRequest> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::agentAliasId)).setter(InvokeAgentRequest.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::agentId)).setter(InvokeAgentRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableTrace").getter(InvokeAgentRequest.getter(InvokeAgentRequest::enableTrace)).setter(InvokeAgentRequest.setter(Builder::enableTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()}).build();
    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("endSession").getter(InvokeAgentRequest.getter(InvokeAgentRequest::endSession)).setter(InvokeAgentRequest.setter(Builder::endSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()}).build();
    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputText").getter(InvokeAgentRequest.getter(InvokeAgentRequest::inputText)).setter(InvokeAgentRequest.setter(Builder::inputText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()}).build();
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::memoryId)).setter(InvokeAgentRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sessionId)).setter(InvokeAgentRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sessionState)).setter(InvokeAgentRequest.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(InvokeAgentRequest.getter(InvokeAgentRequest::sourceArn)).setter(InvokeAgentRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-source-arn").build()}).build();
    private static final SdkField<StreamingConfigurations> STREAMING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamingConfigurations").getter(InvokeAgentRequest.getter(InvokeAgentRequest::streamingConfigurations)).setter(InvokeAgentRequest.setter(Builder::streamingConfigurations)).constructor(StreamingConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD, AGENT_ID_FIELD, ENABLE_TRACE_FIELD, END_SESSION_FIELD, INPUT_TEXT_FIELD, MEMORY_ID_FIELD, SESSION_ID_FIELD, SESSION_STATE_FIELD, SOURCE_ARN_FIELD, STREAMING_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeAgentRequest.memberNameToFieldInitializer();
    private final String agentAliasId;
    private final String agentId;
    private final Boolean enableTrace;
    private final Boolean endSession;
    private final String inputText;
    private final String memoryId;
    private final String sessionId;
    private final SessionState sessionState;
    private final String sourceArn;
    private final StreamingConfigurations streamingConfigurations;

    private InvokeAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentAliasId = builder.agentAliasId;
        this.agentId = builder.agentId;
        this.enableTrace = builder.enableTrace;
        this.endSession = builder.endSession;
        this.inputText = builder.inputText;
        this.memoryId = builder.memoryId;
        this.sessionId = builder.sessionId;
        this.sessionState = builder.sessionState;
        this.sourceArn = builder.sourceArn;
        this.streamingConfigurations = builder.streamingConfigurations;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final Boolean enableTrace() {
        return this.enableTrace;
    }

    public final Boolean endSession() {
        return this.endSession;
    }

    public final String inputText() {
        return this.inputText;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final StreamingConfigurations streamingConfigurations() {
        return this.streamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputText());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingConfigurations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRequest)) {
            return false;
        }
        InvokeAgentRequest other = (InvokeAgentRequest)((Object)obj);
        return Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.enableTrace(), other.enableTrace()) && Objects.equals(this.endSession(), other.endSession()) && Objects.equals(this.inputText(), other.inputText()) && Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionState(), other.sessionState()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.streamingConfigurations(), other.streamingConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeAgentRequest").add("AgentAliasId", (Object)this.agentAliasId()).add("AgentId", (Object)this.agentId()).add("EnableTrace", (Object)this.enableTrace()).add("EndSession", (Object)this.endSession()).add("InputText", (Object)(this.inputText() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryId", (Object)this.memoryId()).add("SessionId", (Object)this.sessionId()).add("SessionState", (Object)this.sessionState()).add("SourceArn", (Object)this.sourceArn()).add("StreamingConfigurations", (Object)this.streamingConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "enableTrace": {
                return Optional.ofNullable(clazz.cast(this.enableTrace()));
            }
            case "endSession": {
                return Optional.ofNullable(clazz.cast(this.endSession()));
            }
            case "inputText": {
                return Optional.ofNullable(clazz.cast(this.inputText()));
            }
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "streamingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.streamingConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionState", SESSION_STATE_FIELD);
        map.put("x-amz-source-arn", SOURCE_ARN_FIELD);
        map.put("streamingConfigurations", STREAMING_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRequest, T> g) {
        return obj -> g.apply((InvokeAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String agentAliasId;
        private String agentId;
        private Boolean enableTrace;
        private Boolean endSession;
        private String inputText;
        private String memoryId;
        private String sessionId;
        private SessionState sessionState;
        private String sourceArn;
        private StreamingConfigurations streamingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRequest model) {
            super(model);
            this.agentAliasId(model.agentAliasId);
            this.agentId(model.agentId);
            this.enableTrace(model.enableTrace);
            this.endSession(model.endSession);
            this.inputText(model.inputText);
            this.memoryId(model.memoryId);
            this.sessionId(model.sessionId);
            this.sessionState(model.sessionState);
            this.sourceArn(model.sourceArn);
            this.streamingConfigurations(model.streamingConfigurations);
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final Boolean getEnableTrace() {
            return this.enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final Boolean getEndSession() {
            return this.endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final String getInputText() {
            return this.inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final StreamingConfigurations.Builder getStreamingConfigurations() {
            return this.streamingConfigurations != null ? this.streamingConfigurations.toBuilder() : null;
        }

        public final void setStreamingConfigurations(StreamingConfigurations.BuilderImpl streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations != null ? streamingConfigurations.build() : null;
        }

        @Override
        public final Builder streamingConfigurations(StreamingConfigurations streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRequest build() {
            return new InvokeAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeAgentRequest> {
        public Builder agentAliasId(String var1);

        public Builder agentId(String var1);

        public Builder enableTrace(Boolean var1);

        public Builder endSession(Boolean var1);

        public Builder inputText(String var1);

        public Builder memoryId(String var1);

        public Builder sessionId(String var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder sourceArn(String var1);

        public Builder streamingConfigurations(StreamingConfigurations var1);

        default public Builder streamingConfigurations(Consumer<StreamingConfigurations.Builder> streamingConfigurations) {
            return this.streamingConfigurations((StreamingConfigurations)((StreamingConfigurations.Builder)StreamingConfigurations.builder().applyMutation(streamingConfigurations)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

