/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputFile> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("bytes").getter(OutputFile.getter(OutputFile::bytes)).setter(OutputFile.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(OutputFile.getter(OutputFile::name)).setter(OutputFile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(OutputFile.getter(OutputFile::type)).setter(OutputFile.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD, NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bytes", BYTES_FIELD);
            this.put("name", NAME_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SdkBytes bytes;
    private final String name;
    private final String type;

    private OutputFile(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.name = builder.name;
        this.type = builder.type;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFile)) {
            return false;
        }
        OutputFile other = (OutputFile)obj;
        return Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"OutputFile").add("Bytes", (Object)(this.bytes() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OutputFile, T> g) {
        return obj -> g.apply((OutputFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes bytes;
        private String name;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFile model) {
            this.bytes(model.bytes);
            this.name(model.name);
            this.type(model.type);
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public OutputFile build() {
            return new OutputFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputFile> {
        public Builder bytes(SdkBytes var1);

        public Builder name(String var1);

        public Builder type(String var1);
    }
}

