/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.ModelInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.Observation;
import software.amazon.awssdk.services.bedrockagentruntime.model.RoutingClassifierModelInvocationOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingClassifierTrace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingClassifierTrace> {
    private static final SdkField<InvocationInput> INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invocationInput").getter(RoutingClassifierTrace.getter(RoutingClassifierTrace::invocationInput)).setter(RoutingClassifierTrace.setter(Builder::invocationInput)).constructor(InvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInput").build()}).build();
    private static final SdkField<ModelInvocationInput> MODEL_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelInvocationInput").getter(RoutingClassifierTrace.getter(RoutingClassifierTrace::modelInvocationInput)).setter(RoutingClassifierTrace.setter(Builder::modelInvocationInput)).constructor(ModelInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationInput").build()}).build();
    private static final SdkField<RoutingClassifierModelInvocationOutput> MODEL_INVOCATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelInvocationOutput").getter(RoutingClassifierTrace.getter(RoutingClassifierTrace::modelInvocationOutput)).setter(RoutingClassifierTrace.setter(Builder::modelInvocationOutput)).constructor(RoutingClassifierModelInvocationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationOutput").build()}).build();
    private static final SdkField<Observation> OBSERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("observation").getter(RoutingClassifierTrace.getter(RoutingClassifierTrace::observation)).setter(RoutingClassifierTrace.setter(Builder::observation)).constructor(Observation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_INPUT_FIELD, MODEL_INVOCATION_INPUT_FIELD, MODEL_INVOCATION_OUTPUT_FIELD, OBSERVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("invocationInput", INVOCATION_INPUT_FIELD);
            this.put("modelInvocationInput", MODEL_INVOCATION_INPUT_FIELD);
            this.put("modelInvocationOutput", MODEL_INVOCATION_OUTPUT_FIELD);
            this.put("observation", OBSERVATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final InvocationInput invocationInput;
    private final ModelInvocationInput modelInvocationInput;
    private final RoutingClassifierModelInvocationOutput modelInvocationOutput;
    private final Observation observation;
    private final Type type;

    private RoutingClassifierTrace(BuilderImpl builder) {
        this.invocationInput = builder.invocationInput;
        this.modelInvocationInput = builder.modelInvocationInput;
        this.modelInvocationOutput = builder.modelInvocationOutput;
        this.observation = builder.observation;
        this.type = builder.type;
    }

    public final InvocationInput invocationInput() {
        return this.invocationInput;
    }

    public final ModelInvocationInput modelInvocationInput() {
        return this.modelInvocationInput;
    }

    public final RoutingClassifierModelInvocationOutput modelInvocationOutput() {
        return this.modelInvocationOutput;
    }

    public final Observation observation() {
        return this.observation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.observation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingClassifierTrace)) {
            return false;
        }
        RoutingClassifierTrace other = (RoutingClassifierTrace)obj;
        return Objects.equals(this.invocationInput(), other.invocationInput()) && Objects.equals(this.modelInvocationInput(), other.modelInvocationInput()) && Objects.equals(this.modelInvocationOutput(), other.modelInvocationOutput()) && Objects.equals(this.observation(), other.observation());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingClassifierTrace").add("InvocationInput", (Object)(this.invocationInput() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelInvocationInput", (Object)(this.modelInvocationInput() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelInvocationOutput", (Object)(this.modelInvocationOutput() == null ? null : "*** Sensitive Data Redacted ***")).add("Observation", (Object)(this.observation() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationInput": {
                return Optional.ofNullable(clazz.cast(this.invocationInput()));
            }
            case "modelInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.modelInvocationInput()));
            }
            case "modelInvocationOutput": {
                return Optional.ofNullable(clazz.cast(this.modelInvocationOutput()));
            }
            case "observation": {
                return Optional.ofNullable(clazz.cast(this.observation()));
            }
        }
        return Optional.empty();
    }

    public static RoutingClassifierTrace fromInvocationInput(InvocationInput invocationInput) {
        return (RoutingClassifierTrace)RoutingClassifierTrace.builder().invocationInput(invocationInput).build();
    }

    public static RoutingClassifierTrace fromInvocationInput(Consumer<InvocationInput.Builder> invocationInput) {
        InvocationInput.Builder builder = InvocationInput.builder();
        invocationInput.accept(builder);
        return RoutingClassifierTrace.fromInvocationInput((InvocationInput)builder.build());
    }

    public static RoutingClassifierTrace fromModelInvocationInput(ModelInvocationInput modelInvocationInput) {
        return (RoutingClassifierTrace)RoutingClassifierTrace.builder().modelInvocationInput(modelInvocationInput).build();
    }

    public static RoutingClassifierTrace fromModelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
        ModelInvocationInput.Builder builder = ModelInvocationInput.builder();
        modelInvocationInput.accept(builder);
        return RoutingClassifierTrace.fromModelInvocationInput((ModelInvocationInput)builder.build());
    }

    public static RoutingClassifierTrace fromModelInvocationOutput(RoutingClassifierModelInvocationOutput modelInvocationOutput) {
        return (RoutingClassifierTrace)RoutingClassifierTrace.builder().modelInvocationOutput(modelInvocationOutput).build();
    }

    public static RoutingClassifierTrace fromModelInvocationOutput(Consumer<RoutingClassifierModelInvocationOutput.Builder> modelInvocationOutput) {
        RoutingClassifierModelInvocationOutput.Builder builder = RoutingClassifierModelInvocationOutput.builder();
        modelInvocationOutput.accept(builder);
        return RoutingClassifierTrace.fromModelInvocationOutput((RoutingClassifierModelInvocationOutput)builder.build());
    }

    public static RoutingClassifierTrace fromObservation(Observation observation) {
        return (RoutingClassifierTrace)RoutingClassifierTrace.builder().observation(observation).build();
    }

    public static RoutingClassifierTrace fromObservation(Consumer<Observation.Builder> observation) {
        Observation.Builder builder = Observation.builder();
        observation.accept(builder);
        return RoutingClassifierTrace.fromObservation((Observation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RoutingClassifierTrace, T> g) {
        return obj -> g.apply((RoutingClassifierTrace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INVOCATION_INPUT,
        MODEL_INVOCATION_INPUT,
        MODEL_INVOCATION_OUTPUT,
        OBSERVATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InvocationInput invocationInput;
        private ModelInvocationInput modelInvocationInput;
        private RoutingClassifierModelInvocationOutput modelInvocationOutput;
        private Observation observation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingClassifierTrace model) {
            this.invocationInput(model.invocationInput);
            this.modelInvocationInput(model.modelInvocationInput);
            this.modelInvocationOutput(model.modelInvocationOutput);
            this.observation(model.observation);
        }

        public final InvocationInput.Builder getInvocationInput() {
            return this.invocationInput != null ? this.invocationInput.toBuilder() : null;
        }

        public final void setInvocationInput(InvocationInput.BuilderImpl invocationInput) {
            InvocationInput oldValue = this.invocationInput;
            this.invocationInput = invocationInput != null ? invocationInput.build() : null;
            this.handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
        }

        @Override
        public final Builder invocationInput(InvocationInput invocationInput) {
            InvocationInput oldValue = this.invocationInput;
            this.invocationInput = invocationInput;
            this.handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
            return this;
        }

        public final ModelInvocationInput.Builder getModelInvocationInput() {
            return this.modelInvocationInput != null ? this.modelInvocationInput.toBuilder() : null;
        }

        public final void setModelInvocationInput(ModelInvocationInput.BuilderImpl modelInvocationInput) {
            ModelInvocationInput oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput != null ? modelInvocationInput.build() : null;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
        }

        @Override
        public final Builder modelInvocationInput(ModelInvocationInput modelInvocationInput) {
            ModelInvocationInput oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
            return this;
        }

        public final RoutingClassifierModelInvocationOutput.Builder getModelInvocationOutput() {
            return this.modelInvocationOutput != null ? this.modelInvocationOutput.toBuilder() : null;
        }

        public final void setModelInvocationOutput(RoutingClassifierModelInvocationOutput.BuilderImpl modelInvocationOutput) {
            RoutingClassifierModelInvocationOutput oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput != null ? modelInvocationOutput.build() : null;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
        }

        @Override
        public final Builder modelInvocationOutput(RoutingClassifierModelInvocationOutput modelInvocationOutput) {
            RoutingClassifierModelInvocationOutput oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
            return this;
        }

        public final Observation.Builder getObservation() {
            return this.observation != null ? this.observation.toBuilder() : null;
        }

        public final void setObservation(Observation.BuilderImpl observation) {
            Observation oldValue = this.observation;
            this.observation = observation != null ? observation.build() : null;
            this.handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
        }

        @Override
        public final Builder observation(Observation observation) {
            Observation oldValue = this.observation;
            this.observation = observation;
            this.handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
            return this;
        }

        public RoutingClassifierTrace build() {
            return new RoutingClassifierTrace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingClassifierTrace> {
        public Builder invocationInput(InvocationInput var1);

        default public Builder invocationInput(Consumer<InvocationInput.Builder> invocationInput) {
            return this.invocationInput((InvocationInput)((InvocationInput.Builder)InvocationInput.builder().applyMutation(invocationInput)).build());
        }

        public Builder modelInvocationInput(ModelInvocationInput var1);

        default public Builder modelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
            return this.modelInvocationInput((ModelInvocationInput)((ModelInvocationInput.Builder)ModelInvocationInput.builder().applyMutation(modelInvocationInput)).build());
        }

        public Builder modelInvocationOutput(RoutingClassifierModelInvocationOutput var1);

        default public Builder modelInvocationOutput(Consumer<RoutingClassifierModelInvocationOutput.Builder> modelInvocationOutput) {
            return this.modelInvocationOutput((RoutingClassifierModelInvocationOutput)((RoutingClassifierModelInvocationOutput.Builder)RoutingClassifierModelInvocationOutput.builder().applyMutation(modelInvocationOutput)).build());
        }

        public Builder observation(Observation var1);

        default public Builder observation(Consumer<Observation.Builder> observation) {
            return this.observation((Observation)((Observation.Builder)Observation.builder().applyMutation(observation)).build());
        }
    }
}

