/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailConfiguration> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(GuardrailConfiguration.getter(GuardrailConfiguration::guardrailId)).setter(GuardrailConfiguration.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(GuardrailConfiguration.getter(GuardrailConfiguration::guardrailVersion)).setter(GuardrailConfiguration.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD, GUARDRAIL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("guardrailId", GUARDRAIL_ID_FIELD);
            this.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String guardrailId;
    private final String guardrailVersion;

    private GuardrailConfiguration(BuilderImpl builder) {
        this.guardrailId = builder.guardrailId;
        this.guardrailVersion = builder.guardrailVersion;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConfiguration)) {
            return false;
        }
        GuardrailConfiguration other = (GuardrailConfiguration)obj;
        return Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailConfiguration").add("GuardrailId", (Object)this.guardrailId()).add("GuardrailVersion", (Object)this.guardrailVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConfiguration, T> g) {
        return obj -> g.apply((GuardrailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String guardrailId;
        private String guardrailVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConfiguration model) {
            this.guardrailId(model.guardrailId);
            this.guardrailVersion(model.guardrailVersion);
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public GuardrailConfiguration build() {
            return new GuardrailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailConfiguration> {
        public Builder guardrailId(String var1);

        public Builder guardrailVersion(String var1);
    }
}

