/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result or output of an action group or knowledge base, or the response to the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Observation implements SdkPojo, Serializable, ToCopyableBuilder<Observation.Builder, Observation> {
    private static final SdkField<ActionGroupInvocationOutput> ACTION_GROUP_INVOCATION_OUTPUT_FIELD = SdkField
            .<ActionGroupInvocationOutput> builder(MarshallingType.SDK_POJO)
            .memberName("actionGroupInvocationOutput")
            .getter(getter(Observation::actionGroupInvocationOutput))
            .setter(setter(Builder::actionGroupInvocationOutput))
            .constructor(ActionGroupInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationOutput")
                    .build()).build();

    private static final SdkField<CodeInterpreterInvocationOutput> CODE_INTERPRETER_INVOCATION_OUTPUT_FIELD = SdkField
            .<CodeInterpreterInvocationOutput> builder(MarshallingType.SDK_POJO)
            .memberName("codeInterpreterInvocationOutput")
            .getter(getter(Observation::codeInterpreterInvocationOutput))
            .setter(setter(Builder::codeInterpreterInvocationOutput))
            .constructor(CodeInterpreterInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterInvocationOutput")
                    .build()).build();

    private static final SdkField<FinalResponse> FINAL_RESPONSE_FIELD = SdkField
            .<FinalResponse> builder(MarshallingType.SDK_POJO).memberName("finalResponse")
            .getter(getter(Observation::finalResponse)).setter(setter(Builder::finalResponse))
            .constructor(FinalResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalResponse").build()).build();

    private static final SdkField<KnowledgeBaseLookupOutput> KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD = SdkField
            .<KnowledgeBaseLookupOutput> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupOutput")
            .getter(getter(Observation::knowledgeBaseLookupOutput)).setter(setter(Builder::knowledgeBaseLookupOutput))
            .constructor(KnowledgeBaseLookupOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupOutput").build())
            .build();

    private static final SdkField<RepromptResponse> REPROMPT_RESPONSE_FIELD = SdkField
            .<RepromptResponse> builder(MarshallingType.SDK_POJO).memberName("repromptResponse")
            .getter(getter(Observation::repromptResponse)).setter(setter(Builder::repromptResponse))
            .constructor(RepromptResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repromptResponse").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(Observation::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Observation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTION_GROUP_INVOCATION_OUTPUT_FIELD, CODE_INTERPRETER_INVOCATION_OUTPUT_FIELD, FINAL_RESPONSE_FIELD,
            KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD, REPROMPT_RESPONSE_FIELD, TRACE_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionGroupInvocationOutput actionGroupInvocationOutput;

    private final CodeInterpreterInvocationOutput codeInterpreterInvocationOutput;

    private final FinalResponse finalResponse;

    private final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;

    private final RepromptResponse repromptResponse;

    private final String traceId;

    private final String type;

    private Observation(BuilderImpl builder) {
        this.actionGroupInvocationOutput = builder.actionGroupInvocationOutput;
        this.codeInterpreterInvocationOutput = builder.codeInterpreterInvocationOutput;
        this.finalResponse = builder.finalResponse;
        this.knowledgeBaseLookupOutput = builder.knowledgeBaseLookupOutput;
        this.repromptResponse = builder.repromptResponse;
        this.traceId = builder.traceId;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the JSON-formatted string returned by the API invoked by the action group.
     * </p>
     * 
     * @return Contains the JSON-formatted string returned by the API invoked by the action group.
     */
    public final ActionGroupInvocationOutput actionGroupInvocationOutput() {
        return actionGroupInvocationOutput;
    }

    /**
     * <p>
     * Contains the JSON-formatted string returned by the API invoked by the code interpreter.
     * </p>
     * 
     * @return Contains the JSON-formatted string returned by the API invoked by the code interpreter.
     */
    public final CodeInterpreterInvocationOutput codeInterpreterInvocationOutput() {
        return codeInterpreterInvocationOutput;
    }

    /**
     * <p>
     * Contains details about the response to the user.
     * </p>
     * 
     * @return Contains details about the response to the user.
     */
    public final FinalResponse finalResponse() {
        return finalResponse;
    }

    /**
     * <p>
     * Contains details about the results from looking up the knowledge base.
     * </p>
     * 
     * @return Contains details about the results from looking up the knowledge base.
     */
    public final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput() {
        return knowledgeBaseLookupOutput;
    }

    /**
     * <p>
     * Contains details about the response to reprompt the input.
     * </p>
     * 
     * @return Contains details about the response to reprompt the input.
     */
    public final RepromptResponse repromptResponse() {
        return repromptResponse;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * <p>
     * Specifies what kind of information the agent returns in the observation. The following values are possible.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTION_GROUP</code> – The agent returns the result of an action group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASK_USER</code> – The agent asks the user a question.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPROMPT</code> – The agent prompts the user again for the same information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies what kind of information the agent returns in the observation. The following values are
     *         possible.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTION_GROUP</code> – The agent returns the result of an action group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASK_USER</code> – The agent asks the user a question.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPROMPT</code> – The agent prompts the user again for the same information.
     *         </p>
     *         </li>
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * Specifies what kind of information the agent returns in the observation. The following values are possible.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTION_GROUP</code> – The agent returns the result of an action group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASK_USER</code> – The agent asks the user a question.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPROMPT</code> – The agent prompts the user again for the same information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies what kind of information the agent returns in the observation. The following values are
     *         possible.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTION_GROUP</code> – The agent returns the result of an action group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASK_USER</code> – The agent asks the user a question.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPROMPT</code> – The agent prompts the user again for the same information.
     *         </p>
     *         </li>
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(finalResponse());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseLookupOutput());
        hashCode = 31 * hashCode + Objects.hashCode(repromptResponse());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation) obj;
        return Objects.equals(actionGroupInvocationOutput(), other.actionGroupInvocationOutput())
                && Objects.equals(codeInterpreterInvocationOutput(), other.codeInterpreterInvocationOutput())
                && Objects.equals(finalResponse(), other.finalResponse())
                && Objects.equals(knowledgeBaseLookupOutput(), other.knowledgeBaseLookupOutput())
                && Objects.equals(repromptResponse(), other.repromptResponse()) && Objects.equals(traceId(), other.traceId())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Observation").add("ActionGroupInvocationOutput", actionGroupInvocationOutput())
                .add("CodeInterpreterInvocationOutput", codeInterpreterInvocationOutput()).add("FinalResponse", finalResponse())
                .add("KnowledgeBaseLookupOutput", knowledgeBaseLookupOutput())
                .add("RepromptResponse", repromptResponse() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TraceId", traceId()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroupInvocationOutput":
            return Optional.ofNullable(clazz.cast(actionGroupInvocationOutput()));
        case "codeInterpreterInvocationOutput":
            return Optional.ofNullable(clazz.cast(codeInterpreterInvocationOutput()));
        case "finalResponse":
            return Optional.ofNullable(clazz.cast(finalResponse()));
        case "knowledgeBaseLookupOutput":
            return Optional.ofNullable(clazz.cast(knowledgeBaseLookupOutput()));
        case "repromptResponse":
            return Optional.ofNullable(clazz.cast(repromptResponse()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Observation> {
        /**
         * <p>
         * Contains the JSON-formatted string returned by the API invoked by the action group.
         * </p>
         * 
         * @param actionGroupInvocationOutput
         *        Contains the JSON-formatted string returned by the API invoked by the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupInvocationOutput(ActionGroupInvocationOutput actionGroupInvocationOutput);

        /**
         * <p>
         * Contains the JSON-formatted string returned by the API invoked by the action group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionGroupInvocationOutput.Builder}
         * avoiding the need to create one manually via {@link ActionGroupInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #actionGroupInvocationOutput(ActionGroupInvocationOutput)}.
         * 
         * @param actionGroupInvocationOutput
         *        a consumer that will call methods on {@link ActionGroupInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupInvocationOutput(ActionGroupInvocationOutput)
         */
        default Builder actionGroupInvocationOutput(Consumer<ActionGroupInvocationOutput.Builder> actionGroupInvocationOutput) {
            return actionGroupInvocationOutput(ActionGroupInvocationOutput.builder().applyMutation(actionGroupInvocationOutput)
                    .build());
        }

        /**
         * <p>
         * Contains the JSON-formatted string returned by the API invoked by the code interpreter.
         * </p>
         * 
         * @param codeInterpreterInvocationOutput
         *        Contains the JSON-formatted string returned by the API invoked by the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterInvocationOutput(CodeInterpreterInvocationOutput codeInterpreterInvocationOutput);

        /**
         * <p>
         * Contains the JSON-formatted string returned by the API invoked by the code interpreter.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeInterpreterInvocationOutput.Builder}
         * avoiding the need to create one manually via {@link CodeInterpreterInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeInterpreterInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #codeInterpreterInvocationOutput(CodeInterpreterInvocationOutput)}.
         * 
         * @param codeInterpreterInvocationOutput
         *        a consumer that will call methods on {@link CodeInterpreterInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeInterpreterInvocationOutput(CodeInterpreterInvocationOutput)
         */
        default Builder codeInterpreterInvocationOutput(
                Consumer<CodeInterpreterInvocationOutput.Builder> codeInterpreterInvocationOutput) {
            return codeInterpreterInvocationOutput(CodeInterpreterInvocationOutput.builder()
                    .applyMutation(codeInterpreterInvocationOutput).build());
        }

        /**
         * <p>
         * Contains details about the response to the user.
         * </p>
         * 
         * @param finalResponse
         *        Contains details about the response to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalResponse(FinalResponse finalResponse);

        /**
         * <p>
         * Contains details about the response to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link FinalResponse.Builder} avoiding the need
         * to create one manually via {@link FinalResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FinalResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #finalResponse(FinalResponse)}.
         * 
         * @param finalResponse
         *        a consumer that will call methods on {@link FinalResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalResponse(FinalResponse)
         */
        default Builder finalResponse(Consumer<FinalResponse.Builder> finalResponse) {
            return finalResponse(FinalResponse.builder().applyMutation(finalResponse).build());
        }

        /**
         * <p>
         * Contains details about the results from looking up the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseLookupOutput
         *        Contains details about the results from looking up the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput knowledgeBaseLookupOutput);

        /**
         * <p>
         * Contains details about the results from looking up the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseLookupOutput.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseLookupOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseLookupOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput)}.
         * 
         * @param knowledgeBaseLookupOutput
         *        a consumer that will call methods on {@link KnowledgeBaseLookupOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput)
         */
        default Builder knowledgeBaseLookupOutput(Consumer<KnowledgeBaseLookupOutput.Builder> knowledgeBaseLookupOutput) {
            return knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput.builder().applyMutation(knowledgeBaseLookupOutput).build());
        }

        /**
         * <p>
         * Contains details about the response to reprompt the input.
         * </p>
         * 
         * @param repromptResponse
         *        Contains details about the response to reprompt the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repromptResponse(RepromptResponse repromptResponse);

        /**
         * <p>
         * Contains details about the response to reprompt the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepromptResponse.Builder} avoiding the
         * need to create one manually via {@link RepromptResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepromptResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #repromptResponse(RepromptResponse)}.
         * 
         * @param repromptResponse
         *        a consumer that will call methods on {@link RepromptResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repromptResponse(RepromptResponse)
         */
        default Builder repromptResponse(Consumer<RepromptResponse.Builder> repromptResponse) {
            return repromptResponse(RepromptResponse.builder().applyMutation(repromptResponse).build());
        }

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * <p>
         * Specifies what kind of information the agent returns in the observation. The following values are possible.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTION_GROUP</code> – The agent returns the result of an action group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASK_USER</code> – The agent asks the user a question.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPROMPT</code> – The agent prompts the user again for the same information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Specifies what kind of information the agent returns in the observation. The following values are
         *        possible.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTION_GROUP</code> – The agent returns the result of an action group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASK_USER</code> – The agent asks the user a question.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPROMPT</code> – The agent prompts the user again for the same information.
         *        </p>
         *        </li>
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies what kind of information the agent returns in the observation. The following values are possible.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTION_GROUP</code> – The agent returns the result of an action group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASK_USER</code> – The agent asks the user a question.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPROMPT</code> – The agent prompts the user again for the same information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Specifies what kind of information the agent returns in the observation. The following values are
         *        possible.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTION_GROUP</code> – The agent returns the result of an action group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISH</code> – The agent returns a final response to the user with no follow-up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASK_USER</code> – The agent asks the user a question.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPROMPT</code> – The agent prompts the user again for the same information.
         *        </p>
         *        </li>
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private ActionGroupInvocationOutput actionGroupInvocationOutput;

        private CodeInterpreterInvocationOutput codeInterpreterInvocationOutput;

        private FinalResponse finalResponse;

        private KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;

        private RepromptResponse repromptResponse;

        private String traceId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            actionGroupInvocationOutput(model.actionGroupInvocationOutput);
            codeInterpreterInvocationOutput(model.codeInterpreterInvocationOutput);
            finalResponse(model.finalResponse);
            knowledgeBaseLookupOutput(model.knowledgeBaseLookupOutput);
            repromptResponse(model.repromptResponse);
            traceId(model.traceId);
            type(model.type);
        }

        public final ActionGroupInvocationOutput.Builder getActionGroupInvocationOutput() {
            return actionGroupInvocationOutput != null ? actionGroupInvocationOutput.toBuilder() : null;
        }

        public final void setActionGroupInvocationOutput(ActionGroupInvocationOutput.BuilderImpl actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput != null ? actionGroupInvocationOutput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationOutput(ActionGroupInvocationOutput actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput;
            return this;
        }

        public final CodeInterpreterInvocationOutput.Builder getCodeInterpreterInvocationOutput() {
            return codeInterpreterInvocationOutput != null ? codeInterpreterInvocationOutput.toBuilder() : null;
        }

        public final void setCodeInterpreterInvocationOutput(
                CodeInterpreterInvocationOutput.BuilderImpl codeInterpreterInvocationOutput) {
            this.codeInterpreterInvocationOutput = codeInterpreterInvocationOutput != null ? codeInterpreterInvocationOutput
                    .build() : null;
        }

        @Override
        public final Builder codeInterpreterInvocationOutput(CodeInterpreterInvocationOutput codeInterpreterInvocationOutput) {
            this.codeInterpreterInvocationOutput = codeInterpreterInvocationOutput;
            return this;
        }

        public final FinalResponse.Builder getFinalResponse() {
            return finalResponse != null ? finalResponse.toBuilder() : null;
        }

        public final void setFinalResponse(FinalResponse.BuilderImpl finalResponse) {
            this.finalResponse = finalResponse != null ? finalResponse.build() : null;
        }

        @Override
        public final Builder finalResponse(FinalResponse finalResponse) {
            this.finalResponse = finalResponse;
            return this;
        }

        public final KnowledgeBaseLookupOutput.Builder getKnowledgeBaseLookupOutput() {
            return knowledgeBaseLookupOutput != null ? knowledgeBaseLookupOutput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupOutput(KnowledgeBaseLookupOutput.BuilderImpl knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput != null ? knowledgeBaseLookupOutput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput;
            return this;
        }

        public final RepromptResponse.Builder getRepromptResponse() {
            return repromptResponse != null ? repromptResponse.toBuilder() : null;
        }

        public final void setRepromptResponse(RepromptResponse.BuilderImpl repromptResponse) {
            this.repromptResponse = repromptResponse != null ? repromptResponse.build() : null;
        }

        @Override
        public final Builder repromptResponse(RepromptResponse repromptResponse) {
            this.repromptResponse = repromptResponse;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Observation build() {
            return new Observation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
