/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations to apply to a knowledge base attached to the agent during query. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html#session-state-kb">Knowledge base
 * retrieval configurations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseConfiguration.Builder, KnowledgeBaseConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseConfiguration::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(KnowledgeBaseConfiguration::retrievalConfiguration)).setter(setter(Builder::retrievalConfiguration))
            .constructor(KnowledgeBaseRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            RETRIEVAL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

    private KnowledgeBaseConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.retrievalConfiguration = builder.retrievalConfiguration;
    }

    /**
     * <p>
     * The unique identifier for a knowledge base attached to the agent.
     * </p>
     * 
     * @return The unique identifier for a knowledge base attached to the agent.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The configurations to apply to the knowledge base during query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
     * </p>
     * 
     * @return The configurations to apply to the knowledge base during query. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
     */
    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseConfiguration)) {
            return false;
        }
        KnowledgeBaseConfiguration other = (KnowledgeBaseConfiguration) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseConfiguration").add("KnowledgeBaseId", knowledgeBaseId())
                .add("RetrievalConfiguration", retrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseConfiguration> {
        /**
         * <p>
         * The unique identifier for a knowledge base attached to the agent.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier for a knowledge base attached to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The configurations to apply to the knowledge base during query. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * 
         * @param retrievalConfiguration
         *        The configurations to apply to the knowledge base during query. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query
         *        configurations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * The configurations to apply to the knowledge base during query. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrievalConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseConfiguration model) {
            knowledgeBaseId(model.knowledgeBaseId);
            retrievalConfiguration(model.retrievalConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseConfiguration build() {
            return new KnowledgeBaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
