/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentMemoryRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<GetAgentMemoryRequest.Builder, GetAgentMemoryRequest> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(GetAgentMemoryRequest::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(GetAgentMemoryRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxItems").getter(getter(GetAgentMemoryRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxItems").build()).build();

    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(GetAgentMemoryRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memoryId").build()).build();

    private static final SdkField<String> MEMORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryType").getter(getter(GetAgentMemoryRequest::memoryTypeAsString))
            .setter(setter(Builder::memoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memoryType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAgentMemoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD,
            AGENT_ID_FIELD, MAX_ITEMS_FIELD, MEMORY_ID_FIELD, MEMORY_TYPE_FIELD, NEXT_TOKEN_FIELD));

    private final String agentAliasId;

    private final String agentId;

    private final Integer maxItems;

    private final String memoryId;

    private final String memoryType;

    private final String nextToken;

    private GetAgentMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.agentAliasId = builder.agentAliasId;
        this.agentId = builder.agentId;
        this.maxItems = builder.maxItems;
        this.memoryId = builder.memoryId;
        this.memoryType = builder.memoryType;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of an alias of an agent.
     * </p>
     * 
     * @return The unique identifier of an alias of an agent.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * The unique identifier of the agent to which the alias belongs.
     * </p>
     * 
     * @return The unique identifier of the agent to which the alias belongs.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If the total number of results is greater than this value,
     * use the token returned in the response in the <code>nextToken</code> field when making another request to return
     * the next batch of results.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If the total number of results is greater than
     *         this value, use the token returned in the response in the <code>nextToken</code> field when making
     *         another request to return the next batch of results.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The unique identifier of the memory.
     * </p>
     * 
     * @return The unique identifier of the memory.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The type of memory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memoryType} will
     * return {@link MemoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memoryTypeAsString}.
     * </p>
     * 
     * @return The type of memory.
     * @see MemoryType
     */
    public final MemoryType memoryType() {
        return MemoryType.fromValue(memoryType);
    }

    /**
     * <p>
     * The type of memory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memoryType} will
     * return {@link MemoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memoryTypeAsString}.
     * </p>
     * 
     * @return The type of memory.
     * @see MemoryType
     */
    public final String memoryTypeAsString() {
        return memoryType;
    }

    /**
     * <p>
     * If the total number of results is greater than the maxItems value provided in the request, enter the token
     * returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the maxItems value provided in the request, enter the
     *         token returned in the <code>nextToken</code> field in the response in this field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(memoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentMemoryRequest)) {
            return false;
        }
        GetAgentMemoryRequest other = (GetAgentMemoryRequest) obj;
        return Objects.equals(agentAliasId(), other.agentAliasId()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(memoryId(), other.memoryId())
                && Objects.equals(memoryTypeAsString(), other.memoryTypeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentMemoryRequest").add("AgentAliasId", agentAliasId()).add("AgentId", agentId())
                .add("MaxItems", maxItems()).add("MemoryId", memoryId()).add("MemoryType", memoryTypeAsString())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "maxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "memoryType":
            return Optional.ofNullable(clazz.cast(memoryTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAgentMemoryRequest, T> g) {
        return obj -> g.apply((GetAgentMemoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAgentMemoryRequest> {
        /**
         * <p>
         * The unique identifier of an alias of an agent.
         * </p>
         * 
         * @param agentAliasId
         *        The unique identifier of an alias of an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * The unique identifier of the agent to which the alias belongs.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent to which the alias belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The maximum number of items to return in the response. If the total number of results is greater than this
         * value, use the token returned in the response in the <code>nextToken</code> field when making another request
         * to return the next batch of results.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of items to return in the response. If the total number of results is greater than
         *        this value, use the token returned in the response in the <code>nextToken</code> field when making
         *        another request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The unique identifier of the memory.
         * </p>
         * 
         * @param memoryId
         *        The unique identifier of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The type of memory.
         * </p>
         * 
         * @param memoryType
         *        The type of memory.
         * @see MemoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryType
         */
        Builder memoryType(String memoryType);

        /**
         * <p>
         * The type of memory.
         * </p>
         * 
         * @param memoryType
         *        The type of memory.
         * @see MemoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryType
         */
        Builder memoryType(MemoryType memoryType);

        /**
         * <p>
         * If the total number of results is greater than the maxItems value provided in the request, enter the token
         * returned in the <code>nextToken</code> field in the response in this field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the maxItems value provided in the request, enter the
         *        token returned in the <code>nextToken</code> field in the response in this field to return the next
         *        batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String agentAliasId;

        private String agentId;

        private Integer maxItems;

        private String memoryId;

        private String memoryType;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentMemoryRequest model) {
            super(model);
            agentAliasId(model.agentAliasId);
            agentId(model.agentId);
            maxItems(model.maxItems);
            memoryId(model.memoryId);
            memoryType(model.memoryType);
            nextToken(model.nextToken);
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getMemoryType() {
            return memoryType;
        }

        public final void setMemoryType(String memoryType) {
            this.memoryType = memoryType;
        }

        @Override
        public final Builder memoryType(String memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Override
        public final Builder memoryType(MemoryType memoryType) {
            this.memoryType(memoryType == null ? null : memoryType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAgentMemoryRequest build() {
            return new GetAgentMemoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
