/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The property contains the file to chat with, along with its attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByteContentFile implements SdkPojo, Serializable, ToCopyableBuilder<ByteContentFile.Builder, ByteContentFile> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(ByteContentFile::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaType").getter(getter(ByteContentFile::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, MEDIA_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes data;

    private final String mediaType;

    private ByteContentFile(BuilderImpl builder) {
        this.data = builder.data;
        this.mediaType = builder.mediaType;
    }

    /**
     * <p>
     * The raw bytes of the file to attach. The maximum size of all files that is attached is 10MB. You can attach a
     * maximum of 5 files.
     * </p>
     * 
     * @return The raw bytes of the file to attach. The maximum size of all files that is attached is 10MB. You can
     *         attach a maximum of 5 files.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The MIME type of data contained in the file used for chat.
     * </p>
     * 
     * @return The MIME type of data contained in the file used for chat.
     */
    public final String mediaType() {
        return mediaType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentFile)) {
            return false;
        }
        ByteContentFile other = (ByteContentFile) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(mediaType(), other.mediaType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByteContentFile").add("Data", data() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaType", mediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "mediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteContentFile, T> g) {
        return obj -> g.apply((ByteContentFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByteContentFile> {
        /**
         * <p>
         * The raw bytes of the file to attach. The maximum size of all files that is attached is 10MB. You can attach a
         * maximum of 5 files.
         * </p>
         * 
         * @param data
         *        The raw bytes of the file to attach. The maximum size of all files that is attached is 10MB. You can
         *        attach a maximum of 5 files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The MIME type of data contained in the file used for chat.
         * </p>
         * 
         * @param mediaType
         *        The MIME type of data contained in the file used for chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes data;

        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentFile model) {
            data(model.data);
            mediaType(model.mediaType);
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getMediaType() {
            return mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @Override
        public ByteContentFile build() {
            return new ByteContentFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
