/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.MemoriesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.Memory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgentMemoryResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, GetAgentMemoryResponse> {
    private static final SdkField<List<Memory>> MEMORY_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memoryContents").getter(GetAgentMemoryResponse.getter(GetAgentMemoryResponse::memoryContents)).setter(GetAgentMemoryResponse.setter(Builder::memoryContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Memory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAgentMemoryResponse.getter(GetAgentMemoryResponse::nextToken)).setter(GetAgentMemoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_CONTENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Memory> memoryContents;
    private final String nextToken;

    private GetAgentMemoryResponse(BuilderImpl builder) {
        super(builder);
        this.memoryContents = builder.memoryContents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMemoryContents() {
        return this.memoryContents != null && !(this.memoryContents instanceof SdkAutoConstructList);
    }

    public final List<Memory> memoryContents() {
        return this.memoryContents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemoryContents() ? this.memoryContents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentMemoryResponse)) {
            return false;
        }
        GetAgentMemoryResponse other = (GetAgentMemoryResponse)((Object)obj);
        return this.hasMemoryContents() == other.hasMemoryContents() && Objects.equals(this.memoryContents(), other.memoryContents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgentMemoryResponse").add("MemoryContents", this.hasMemoryContents() ? this.memoryContents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryContents": {
                return Optional.ofNullable(clazz.cast(this.memoryContents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAgentMemoryResponse, T> g) {
        return obj -> g.apply((GetAgentMemoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<Memory> memoryContents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentMemoryResponse model) {
            super(model);
            this.memoryContents(model.memoryContents);
            this.nextToken(model.nextToken);
        }

        public final List<Memory.Builder> getMemoryContents() {
            List<Memory.Builder> result = MemoriesCopier.copyToBuilder(this.memoryContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemoryContents(Collection<Memory.BuilderImpl> memoryContents) {
            this.memoryContents = MemoriesCopier.copyFromBuilder(memoryContents);
        }

        @Override
        public final Builder memoryContents(Collection<Memory> memoryContents) {
            this.memoryContents = MemoriesCopier.copy(memoryContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryContents(Memory ... memoryContents) {
            this.memoryContents(Arrays.asList(memoryContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryContents(Consumer<Memory.Builder> ... memoryContents) {
            this.memoryContents(Stream.of(memoryContents).map(c -> (Memory)((Memory.Builder)Memory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAgentMemoryResponse build() {
            return new GetAgentMemoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgentMemoryResponse> {
        public Builder memoryContents(Collection<Memory> var1);

        public Builder memoryContents(Memory ... var1);

        public Builder memoryContents(Consumer<Memory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

