/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.ApiResult;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationResultMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationResultMember> {
    private static final SdkField<ApiResult> API_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiResult").getter(InvocationResultMember.getter(InvocationResultMember::apiResult)).setter(InvocationResultMember.setter(Builder::apiResult)).constructor(ApiResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiResult").build()}).build();
    private static final SdkField<FunctionResult> FUNCTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("functionResult").getter(InvocationResultMember.getter(InvocationResultMember::functionResult)).setter(InvocationResultMember.setter(Builder::functionResult)).constructor(FunctionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_RESULT_FIELD, FUNCTION_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ApiResult apiResult;
    private final FunctionResult functionResult;
    private final Type type;

    private InvocationResultMember(BuilderImpl builder) {
        this.apiResult = builder.apiResult;
        this.functionResult = builder.functionResult;
        this.type = builder.type;
    }

    public final ApiResult apiResult() {
        return this.apiResult;
    }

    public final FunctionResult functionResult() {
        return this.functionResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationResultMember)) {
            return false;
        }
        InvocationResultMember other = (InvocationResultMember)obj;
        return Objects.equals(this.apiResult(), other.apiResult()) && Objects.equals(this.functionResult(), other.functionResult());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationResultMember").add("ApiResult", (Object)this.apiResult()).add("FunctionResult", (Object)this.functionResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiResult": {
                return Optional.ofNullable(clazz.cast(this.apiResult()));
            }
            case "functionResult": {
                return Optional.ofNullable(clazz.cast(this.functionResult()));
            }
        }
        return Optional.empty();
    }

    public static InvocationResultMember fromApiResult(ApiResult apiResult) {
        return (InvocationResultMember)InvocationResultMember.builder().apiResult(apiResult).build();
    }

    public static InvocationResultMember fromApiResult(Consumer<ApiResult.Builder> apiResult) {
        ApiResult.Builder builder = ApiResult.builder();
        apiResult.accept(builder);
        return InvocationResultMember.fromApiResult((ApiResult)builder.build());
    }

    public static InvocationResultMember fromFunctionResult(FunctionResult functionResult) {
        return (InvocationResultMember)InvocationResultMember.builder().functionResult(functionResult).build();
    }

    public static InvocationResultMember fromFunctionResult(Consumer<FunctionResult.Builder> functionResult) {
        FunctionResult.Builder builder = FunctionResult.builder();
        functionResult.accept(builder);
        return InvocationResultMember.fromFunctionResult((FunctionResult)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvocationResultMember, T> g) {
        return obj -> g.apply((InvocationResultMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        API_RESULT,
        FUNCTION_RESULT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ApiResult apiResult;
        private FunctionResult functionResult;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationResultMember model) {
            this.apiResult(model.apiResult);
            this.functionResult(model.functionResult);
        }

        public final ApiResult.Builder getApiResult() {
            return this.apiResult != null ? this.apiResult.toBuilder() : null;
        }

        public final void setApiResult(ApiResult.BuilderImpl apiResult) {
            ApiResult oldValue = this.apiResult;
            this.apiResult = apiResult != null ? apiResult.build() : null;
            this.handleUnionValueChange(Type.API_RESULT, oldValue, this.apiResult);
        }

        @Override
        public final Builder apiResult(ApiResult apiResult) {
            ApiResult oldValue = this.apiResult;
            this.apiResult = apiResult;
            this.handleUnionValueChange(Type.API_RESULT, oldValue, this.apiResult);
            return this;
        }

        public final FunctionResult.Builder getFunctionResult() {
            return this.functionResult != null ? this.functionResult.toBuilder() : null;
        }

        public final void setFunctionResult(FunctionResult.BuilderImpl functionResult) {
            FunctionResult oldValue = this.functionResult;
            this.functionResult = functionResult != null ? functionResult.build() : null;
            this.handleUnionValueChange(Type.FUNCTION_RESULT, oldValue, this.functionResult);
        }

        @Override
        public final Builder functionResult(FunctionResult functionResult) {
            FunctionResult oldValue = this.functionResult;
            this.functionResult = functionResult;
            this.handleUnionValueChange(Type.FUNCTION_RESULT, oldValue, this.functionResult);
            return this;
        }

        public InvocationResultMember build() {
            return new InvocationResultMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationResultMember> {
        public Builder apiResult(ApiResult var1);

        default public Builder apiResult(Consumer<ApiResult.Builder> apiResult) {
            return this.apiResult((ApiResult)((ApiResult.Builder)ApiResult.builder().applyMutation(apiResult)).build());
        }

        public Builder functionResult(FunctionResult var1);

        default public Builder functionResult(Consumer<FunctionResult.Builder> functionResult) {
            return this.functionResult((FunctionResult)((FunctionResult.Builder)FunctionResult.builder().applyMutation(functionResult)).build());
        }
    }
}

