/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter;
import software.amazon.awssdk.services.bedrockagentruntime.model.SearchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseVectorSearchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseVectorSearchConfiguration> {
    private static final SdkField<RetrievalFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(KnowledgeBaseVectorSearchConfiguration.getter(KnowledgeBaseVectorSearchConfiguration::filter)).setter(KnowledgeBaseVectorSearchConfiguration.setter(Builder::filter)).constructor(RetrievalFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfResults").getter(KnowledgeBaseVectorSearchConfiguration.getter(KnowledgeBaseVectorSearchConfiguration::numberOfResults)).setter(KnowledgeBaseVectorSearchConfiguration.setter(Builder::numberOfResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()}).build();
    private static final SdkField<String> OVERRIDE_SEARCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideSearchType").getter(KnowledgeBaseVectorSearchConfiguration.getter(KnowledgeBaseVectorSearchConfiguration::overrideSearchTypeAsString)).setter(KnowledgeBaseVectorSearchConfiguration.setter(Builder::overrideSearchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideSearchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, NUMBER_OF_RESULTS_FIELD, OVERRIDE_SEARCH_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final RetrievalFilter filter;
    private final Integer numberOfResults;
    private final String overrideSearchType;

    private KnowledgeBaseVectorSearchConfiguration(BuilderImpl builder) {
        this.filter = builder.filter;
        this.numberOfResults = builder.numberOfResults;
        this.overrideSearchType = builder.overrideSearchType;
    }

    public final RetrievalFilter filter() {
        return this.filter;
    }

    public final Integer numberOfResults() {
        return this.numberOfResults;
    }

    public final SearchType overrideSearchType() {
        return SearchType.fromValue(this.overrideSearchType);
    }

    public final String overrideSearchTypeAsString() {
        return this.overrideSearchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideSearchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseVectorSearchConfiguration)) {
            return false;
        }
        KnowledgeBaseVectorSearchConfiguration other = (KnowledgeBaseVectorSearchConfiguration)obj;
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.numberOfResults(), other.numberOfResults()) && Objects.equals(this.overrideSearchTypeAsString(), other.overrideSearchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseVectorSearchConfiguration").add("Filter", (Object)(this.filter() == null ? null : "*** Sensitive Data Redacted ***")).add("NumberOfResults", (Object)this.numberOfResults()).add("OverrideSearchType", (Object)this.overrideSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "numberOfResults": {
                return Optional.ofNullable(clazz.cast(this.numberOfResults()));
            }
            case "overrideSearchType": {
                return Optional.ofNullable(clazz.cast(this.overrideSearchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseVectorSearchConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseVectorSearchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RetrievalFilter filter;
        private Integer numberOfResults;
        private String overrideSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseVectorSearchConfiguration model) {
            this.filter(model.filter);
            this.numberOfResults(model.numberOfResults);
            this.overrideSearchType(model.overrideSearchType);
        }

        public final RetrievalFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(RetrievalFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(RetrievalFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getNumberOfResults() {
            return this.numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final String getOverrideSearchType() {
            return this.overrideSearchType;
        }

        public final void setOverrideSearchType(String overrideSearchType) {
            this.overrideSearchType = overrideSearchType;
        }

        @Override
        public final Builder overrideSearchType(String overrideSearchType) {
            this.overrideSearchType = overrideSearchType;
            return this;
        }

        @Override
        public final Builder overrideSearchType(SearchType overrideSearchType) {
            this.overrideSearchType(overrideSearchType == null ? null : overrideSearchType.toString());
            return this;
        }

        public KnowledgeBaseVectorSearchConfiguration build() {
            return new KnowledgeBaseVectorSearchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseVectorSearchConfiguration> {
        public Builder filter(RetrievalFilter var1);

        default public Builder filter(Consumer<RetrievalFilter.Builder> filter) {
            return this.filter((RetrievalFilter)((RetrievalFilter.Builder)RetrievalFilter.builder().applyMutation(filter)).build());
        }

        public Builder numberOfResults(Integer var1);

        public Builder overrideSearchType(String var1);

        public Builder overrideSearchType(SearchType var1);
    }
}

