/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseRetrieveAndGenerateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::knowledgeBaseId)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::modelArn)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, MODEL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String modelArn;

    private KnowledgeBaseRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelArn = builder.modelArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrieveAndGenerateConfiguration)) {
            return false;
        }
        KnowledgeBaseRetrieveAndGenerateConfiguration other = (KnowledgeBaseRetrieveAndGenerateConfiguration)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.modelArn(), other.modelArn());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseRetrieveAndGenerateConfiguration").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ModelArn", (Object)this.modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrieveAndGenerateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrieveAndGenerateConfiguration model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.modelArn(model.modelArn);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public KnowledgeBaseRetrieveAndGenerateConfiguration build() {
            return new KnowledgeBaseRetrieveAndGenerateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
        public Builder knowledgeBaseId(String var1);

        public Builder modelArn(String var1);
    }
}

