/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace contains intermidate response for customer
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trace implements SdkPojo, Serializable, ToCopyableBuilder<Trace.Builder, Trace> {
    private static final SdkField<PreProcessingTrace> PRE_PROCESSING_TRACE_FIELD = SdkField
            .<PreProcessingTrace> builder(MarshallingType.SDK_POJO).memberName("preProcessingTrace")
            .getter(getter(Trace::preProcessingTrace)).setter(setter(Builder::preProcessingTrace))
            .constructor(PreProcessingTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProcessingTrace").build())
            .build();

    private static final SdkField<OrchestrationTrace> ORCHESTRATION_TRACE_FIELD = SdkField
            .<OrchestrationTrace> builder(MarshallingType.SDK_POJO).memberName("orchestrationTrace")
            .getter(getter(Trace::orchestrationTrace)).setter(setter(Builder::orchestrationTrace))
            .constructor(OrchestrationTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationTrace").build())
            .build();

    private static final SdkField<PostProcessingTrace> POST_PROCESSING_TRACE_FIELD = SdkField
            .<PostProcessingTrace> builder(MarshallingType.SDK_POJO).memberName("postProcessingTrace")
            .getter(getter(Trace::postProcessingTrace)).setter(setter(Builder::postProcessingTrace))
            .constructor(PostProcessingTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postProcessingTrace").build())
            .build();

    private static final SdkField<FailureTrace> FAILURE_TRACE_FIELD = SdkField.<FailureTrace> builder(MarshallingType.SDK_POJO)
            .memberName("failureTrace").getter(getter(Trace::failureTrace)).setter(setter(Builder::failureTrace))
            .constructor(FailureTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTrace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_PROCESSING_TRACE_FIELD,
            ORCHESTRATION_TRACE_FIELD, POST_PROCESSING_TRACE_FIELD, FAILURE_TRACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PreProcessingTrace preProcessingTrace;

    private final OrchestrationTrace orchestrationTrace;

    private final PostProcessingTrace postProcessingTrace;

    private final FailureTrace failureTrace;

    private final Type type;

    private Trace(BuilderImpl builder) {
        this.preProcessingTrace = builder.preProcessingTrace;
        this.orchestrationTrace = builder.orchestrationTrace;
        this.postProcessingTrace = builder.postProcessingTrace;
        this.failureTrace = builder.failureTrace;
        this.type = builder.type;
    }

    /**
     * Returns the value of the PreProcessingTrace property for this object.
     * 
     * @return The value of the PreProcessingTrace property for this object.
     */
    public final PreProcessingTrace preProcessingTrace() {
        return preProcessingTrace;
    }

    /**
     * Returns the value of the OrchestrationTrace property for this object.
     * 
     * @return The value of the OrchestrationTrace property for this object.
     */
    public final OrchestrationTrace orchestrationTrace() {
        return orchestrationTrace;
    }

    /**
     * Returns the value of the PostProcessingTrace property for this object.
     * 
     * @return The value of the PostProcessingTrace property for this object.
     */
    public final PostProcessingTrace postProcessingTrace() {
        return postProcessingTrace;
    }

    /**
     * Returns the value of the FailureTrace property for this object.
     * 
     * @return The value of the FailureTrace property for this object.
     */
    public final FailureTrace failureTrace() {
        return failureTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preProcessingTrace());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationTrace());
        hashCode = 31 * hashCode + Objects.hashCode(postProcessingTrace());
        hashCode = 31 * hashCode + Objects.hashCode(failureTrace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace) obj;
        return Objects.equals(preProcessingTrace(), other.preProcessingTrace())
                && Objects.equals(orchestrationTrace(), other.orchestrationTrace())
                && Objects.equals(postProcessingTrace(), other.postProcessingTrace())
                && Objects.equals(failureTrace(), other.failureTrace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Trace")
                .add("PreProcessingTrace", preProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OrchestrationTrace", orchestrationTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostProcessingTrace", postProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FailureTrace", failureTrace() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "preProcessingTrace":
            return Optional.ofNullable(clazz.cast(preProcessingTrace()));
        case "orchestrationTrace":
            return Optional.ofNullable(clazz.cast(orchestrationTrace()));
        case "postProcessingTrace":
            return Optional.ofNullable(clazz.cast(postProcessingTrace()));
        case "failureTrace":
            return Optional.ofNullable(clazz.cast(failureTrace()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #preProcessingTrace()} initialized to the given value.
     *
     * Sets the value of the PreProcessingTrace property for this object.
     *
     * @param preProcessingTrace
     *        The new value for the PreProcessingTrace property for this object.
     */
    public static Trace fromPreProcessingTrace(PreProcessingTrace preProcessingTrace) {
        return builder().preProcessingTrace(preProcessingTrace).build();
    }

    /**
     * Create an instance of this class with {@link #preProcessingTrace()} initialized to the given value.
     *
     * Sets the value of the PreProcessingTrace property for this object.
     *
     * @param preProcessingTrace
     *        The new value for the PreProcessingTrace property for this object.
     */
    public static Trace fromPreProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
        PreProcessingTrace.Builder builder = PreProcessingTrace.builder();
        preProcessingTrace.accept(builder);
        return fromPreProcessingTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #orchestrationTrace()} initialized to the given value.
     *
     * Sets the value of the OrchestrationTrace property for this object.
     *
     * @param orchestrationTrace
     *        The new value for the OrchestrationTrace property for this object.
     */
    public static Trace fromOrchestrationTrace(OrchestrationTrace orchestrationTrace) {
        return builder().orchestrationTrace(orchestrationTrace).build();
    }

    /**
     * Create an instance of this class with {@link #orchestrationTrace()} initialized to the given value.
     *
     * Sets the value of the OrchestrationTrace property for this object.
     *
     * @param orchestrationTrace
     *        The new value for the OrchestrationTrace property for this object.
     */
    public static Trace fromOrchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
        OrchestrationTrace.Builder builder = OrchestrationTrace.builder();
        orchestrationTrace.accept(builder);
        return fromOrchestrationTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #postProcessingTrace()} initialized to the given value.
     *
     * Sets the value of the PostProcessingTrace property for this object.
     *
     * @param postProcessingTrace
     *        The new value for the PostProcessingTrace property for this object.
     */
    public static Trace fromPostProcessingTrace(PostProcessingTrace postProcessingTrace) {
        return builder().postProcessingTrace(postProcessingTrace).build();
    }

    /**
     * Create an instance of this class with {@link #postProcessingTrace()} initialized to the given value.
     *
     * Sets the value of the PostProcessingTrace property for this object.
     *
     * @param postProcessingTrace
     *        The new value for the PostProcessingTrace property for this object.
     */
    public static Trace fromPostProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
        PostProcessingTrace.Builder builder = PostProcessingTrace.builder();
        postProcessingTrace.accept(builder);
        return fromPostProcessingTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #failureTrace()} initialized to the given value.
     *
     * Sets the value of the FailureTrace property for this object.
     *
     * @param failureTrace
     *        The new value for the FailureTrace property for this object.
     */
    public static Trace fromFailureTrace(FailureTrace failureTrace) {
        return builder().failureTrace(failureTrace).build();
    }

    /**
     * Create an instance of this class with {@link #failureTrace()} initialized to the given value.
     *
     * Sets the value of the FailureTrace property for this object.
     *
     * @param failureTrace
     *        The new value for the FailureTrace property for this object.
     */
    public static Trace fromFailureTrace(Consumer<FailureTrace.Builder> failureTrace) {
        FailureTrace.Builder builder = FailureTrace.builder();
        failureTrace.accept(builder);
        return fromFailureTrace(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trace, T> g) {
        return obj -> g.apply((Trace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trace> {
        /**
         * Sets the value of the PreProcessingTrace property for this object.
         *
         * @param preProcessingTrace
         *        The new value for the PreProcessingTrace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preProcessingTrace(PreProcessingTrace preProcessingTrace);

        /**
         * Sets the value of the PreProcessingTrace property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PreProcessingTrace.Builder} avoiding the
         * need to create one manually via {@link PreProcessingTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreProcessingTrace.Builder#build()} is called immediately and its
         * result is passed to {@link #preProcessingTrace(PreProcessingTrace)}.
         * 
         * @param preProcessingTrace
         *        a consumer that will call methods on {@link PreProcessingTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preProcessingTrace(PreProcessingTrace)
         */
        default Builder preProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
            return preProcessingTrace(PreProcessingTrace.builder().applyMutation(preProcessingTrace).build());
        }

        /**
         * Sets the value of the OrchestrationTrace property for this object.
         *
         * @param orchestrationTrace
         *        The new value for the OrchestrationTrace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationTrace(OrchestrationTrace orchestrationTrace);

        /**
         * Sets the value of the OrchestrationTrace property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OrchestrationTrace.Builder} avoiding the
         * need to create one manually via {@link OrchestrationTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrchestrationTrace.Builder#build()} is called immediately and its
         * result is passed to {@link #orchestrationTrace(OrchestrationTrace)}.
         * 
         * @param orchestrationTrace
         *        a consumer that will call methods on {@link OrchestrationTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrationTrace(OrchestrationTrace)
         */
        default Builder orchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
            return orchestrationTrace(OrchestrationTrace.builder().applyMutation(orchestrationTrace).build());
        }

        /**
         * Sets the value of the PostProcessingTrace property for this object.
         *
         * @param postProcessingTrace
         *        The new value for the PostProcessingTrace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postProcessingTrace(PostProcessingTrace postProcessingTrace);

        /**
         * Sets the value of the PostProcessingTrace property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PostProcessingTrace.Builder} avoiding the
         * need to create one manually via {@link PostProcessingTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostProcessingTrace.Builder#build()} is called immediately and
         * its result is passed to {@link #postProcessingTrace(PostProcessingTrace)}.
         * 
         * @param postProcessingTrace
         *        a consumer that will call methods on {@link PostProcessingTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postProcessingTrace(PostProcessingTrace)
         */
        default Builder postProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
            return postProcessingTrace(PostProcessingTrace.builder().applyMutation(postProcessingTrace).build());
        }

        /**
         * Sets the value of the FailureTrace property for this object.
         *
         * @param failureTrace
         *        The new value for the FailureTrace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureTrace(FailureTrace failureTrace);

        /**
         * Sets the value of the FailureTrace property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FailureTrace.Builder} avoiding the need
         * to create one manually via {@link FailureTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureTrace.Builder#build()} is called immediately and its
         * result is passed to {@link #failureTrace(FailureTrace)}.
         * 
         * @param failureTrace
         *        a consumer that will call methods on {@link FailureTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureTrace(FailureTrace)
         */
        default Builder failureTrace(Consumer<FailureTrace.Builder> failureTrace) {
            return failureTrace(FailureTrace.builder().applyMutation(failureTrace).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PreProcessingTrace preProcessingTrace;

        private OrchestrationTrace orchestrationTrace;

        private PostProcessingTrace postProcessingTrace;

        private FailureTrace failureTrace;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            preProcessingTrace(model.preProcessingTrace);
            orchestrationTrace(model.orchestrationTrace);
            postProcessingTrace(model.postProcessingTrace);
            failureTrace(model.failureTrace);
        }

        public final PreProcessingTrace.Builder getPreProcessingTrace() {
            return preProcessingTrace != null ? preProcessingTrace.toBuilder() : null;
        }

        public final void setPreProcessingTrace(PreProcessingTrace.BuilderImpl preProcessingTrace) {
            Object oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace != null ? preProcessingTrace.build() : null;
            handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
        }

        @Override
        public final Builder preProcessingTrace(PreProcessingTrace preProcessingTrace) {
            Object oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace;
            handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
            return this;
        }

        public final OrchestrationTrace.Builder getOrchestrationTrace() {
            return orchestrationTrace != null ? orchestrationTrace.toBuilder() : null;
        }

        public final void setOrchestrationTrace(OrchestrationTrace.BuilderImpl orchestrationTrace) {
            Object oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace != null ? orchestrationTrace.build() : null;
            handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
        }

        @Override
        public final Builder orchestrationTrace(OrchestrationTrace orchestrationTrace) {
            Object oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace;
            handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
            return this;
        }

        public final PostProcessingTrace.Builder getPostProcessingTrace() {
            return postProcessingTrace != null ? postProcessingTrace.toBuilder() : null;
        }

        public final void setPostProcessingTrace(PostProcessingTrace.BuilderImpl postProcessingTrace) {
            Object oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace != null ? postProcessingTrace.build() : null;
            handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
        }

        @Override
        public final Builder postProcessingTrace(PostProcessingTrace postProcessingTrace) {
            Object oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace;
            handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
            return this;
        }

        public final FailureTrace.Builder getFailureTrace() {
            return failureTrace != null ? failureTrace.toBuilder() : null;
        }

        public final void setFailureTrace(FailureTrace.BuilderImpl failureTrace) {
            Object oldValue = this.failureTrace;
            this.failureTrace = failureTrace != null ? failureTrace.build() : null;
            handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
        }

        @Override
        public final Builder failureTrace(FailureTrace failureTrace) {
            Object oldValue = this.failureTrace;
            this.failureTrace = failureTrace;
            handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
            return this;
        }

        @Override
        public Trace build() {
            return new Trace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Trace#type()
     */
    public enum Type {
        PRE_PROCESSING_TRACE,

        ORCHESTRATION_TRACE,

        POST_PROCESSING_TRACE,

        FAILURE_TRACE,

        UNKNOWN_TO_SDK_VERSION
    }
}
