/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains information related to postprocessing
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostProcessingModelInvocationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<PostProcessingModelInvocationOutput.Builder, PostProcessingModelInvocationOutput> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(PostProcessingModelInvocationOutput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<PostProcessingParsedResponse> PARSED_RESPONSE_FIELD = SdkField
            .<PostProcessingParsedResponse> builder(MarshallingType.SDK_POJO).memberName("parsedResponse")
            .getter(getter(PostProcessingModelInvocationOutput::parsedResponse)).setter(setter(Builder::parsedResponse))
            .constructor(PostProcessingParsedResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD,
            PARSED_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String traceId;

    private final PostProcessingParsedResponse parsedResponse;

    private PostProcessingModelInvocationOutput(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.parsedResponse = builder.parsedResponse;
    }

    /**
     * Returns the value of the TraceId property for this object.
     * 
     * @return The value of the TraceId property for this object.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * Returns the value of the ParsedResponse property for this object.
     * 
     * @return The value of the ParsedResponse property for this object.
     */
    public final PostProcessingParsedResponse parsedResponse() {
        return parsedResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(parsedResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostProcessingModelInvocationOutput)) {
            return false;
        }
        PostProcessingModelInvocationOutput other = (PostProcessingModelInvocationOutput) obj;
        return Objects.equals(traceId(), other.traceId()) && Objects.equals(parsedResponse(), other.parsedResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostProcessingModelInvocationOutput").add("TraceId", traceId())
                .add("ParsedResponse", parsedResponse() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "parsedResponse":
            return Optional.ofNullable(clazz.cast(parsedResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostProcessingModelInvocationOutput, T> g) {
        return obj -> g.apply((PostProcessingModelInvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostProcessingModelInvocationOutput> {
        /**
         * Sets the value of the TraceId property for this object.
         *
         * @param traceId
         *        The new value for the TraceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * Sets the value of the ParsedResponse property for this object.
         *
         * @param parsedResponse
         *        The new value for the ParsedResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedResponse(PostProcessingParsedResponse parsedResponse);

        /**
         * Sets the value of the ParsedResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PostProcessingParsedResponse.Builder}
         * avoiding the need to create one manually via {@link PostProcessingParsedResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostProcessingParsedResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #parsedResponse(PostProcessingParsedResponse)}.
         * 
         * @param parsedResponse
         *        a consumer that will call methods on {@link PostProcessingParsedResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsedResponse(PostProcessingParsedResponse)
         */
        default Builder parsedResponse(Consumer<PostProcessingParsedResponse.Builder> parsedResponse) {
            return parsedResponse(PostProcessingParsedResponse.builder().applyMutation(parsedResponse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String traceId;

        private PostProcessingParsedResponse parsedResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PostProcessingModelInvocationOutput model) {
            traceId(model.traceId);
            parsedResponse(model.parsedResponse);
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final PostProcessingParsedResponse.Builder getParsedResponse() {
            return parsedResponse != null ? parsedResponse.toBuilder() : null;
        }

        public final void setParsedResponse(PostProcessingParsedResponse.BuilderImpl parsedResponse) {
            this.parsedResponse = parsedResponse != null ? parsedResponse.build() : null;
        }

        @Override
        public final Builder parsedResponse(PostProcessingParsedResponse parsedResponse) {
            this.parsedResponse = parsedResponse;
            return this;
        }

        @Override
        public PostProcessingModelInvocationOutput build() {
            return new PostProcessingModelInvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
