/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains output details for action group or knowledge base or final response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Observation implements SdkPojo, Serializable, ToCopyableBuilder<Observation.Builder, Observation> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(Observation::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Observation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ActionGroupInvocationOutput> ACTION_GROUP_INVOCATION_OUTPUT_FIELD = SdkField
            .<ActionGroupInvocationOutput> builder(MarshallingType.SDK_POJO)
            .memberName("actionGroupInvocationOutput")
            .getter(getter(Observation::actionGroupInvocationOutput))
            .setter(setter(Builder::actionGroupInvocationOutput))
            .constructor(ActionGroupInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationOutput")
                    .build()).build();

    private static final SdkField<KnowledgeBaseLookupOutput> KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD = SdkField
            .<KnowledgeBaseLookupOutput> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupOutput")
            .getter(getter(Observation::knowledgeBaseLookupOutput)).setter(setter(Builder::knowledgeBaseLookupOutput))
            .constructor(KnowledgeBaseLookupOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupOutput").build())
            .build();

    private static final SdkField<FinalResponse> FINAL_RESPONSE_FIELD = SdkField
            .<FinalResponse> builder(MarshallingType.SDK_POJO).memberName("finalResponse")
            .getter(getter(Observation::finalResponse)).setter(setter(Builder::finalResponse))
            .constructor(FinalResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalResponse").build()).build();

    private static final SdkField<RepromptResponse> REPROMPT_RESPONSE_FIELD = SdkField
            .<RepromptResponse> builder(MarshallingType.SDK_POJO).memberName("repromptResponse")
            .getter(getter(Observation::repromptResponse)).setter(setter(Builder::repromptResponse))
            .constructor(RepromptResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repromptResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TYPE_FIELD,
            ACTION_GROUP_INVOCATION_OUTPUT_FIELD, KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD, FINAL_RESPONSE_FIELD,
            REPROMPT_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String traceId;

    private final String type;

    private final ActionGroupInvocationOutput actionGroupInvocationOutput;

    private final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;

    private final FinalResponse finalResponse;

    private final RepromptResponse repromptResponse;

    private Observation(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.type = builder.type;
        this.actionGroupInvocationOutput = builder.actionGroupInvocationOutput;
        this.knowledgeBaseLookupOutput = builder.knowledgeBaseLookupOutput;
        this.finalResponse = builder.finalResponse;
        this.repromptResponse = builder.repromptResponse;
    }

    /**
     * Returns the value of the TraceId property for this object.
     * 
     * @return The value of the TraceId property for this object.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the ActionGroupInvocationOutput property for this object.
     * 
     * @return The value of the ActionGroupInvocationOutput property for this object.
     */
    public final ActionGroupInvocationOutput actionGroupInvocationOutput() {
        return actionGroupInvocationOutput;
    }

    /**
     * Returns the value of the KnowledgeBaseLookupOutput property for this object.
     * 
     * @return The value of the KnowledgeBaseLookupOutput property for this object.
     */
    public final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput() {
        return knowledgeBaseLookupOutput;
    }

    /**
     * Returns the value of the FinalResponse property for this object.
     * 
     * @return The value of the FinalResponse property for this object.
     */
    public final FinalResponse finalResponse() {
        return finalResponse;
    }

    /**
     * Returns the value of the RepromptResponse property for this object.
     * 
     * @return The value of the RepromptResponse property for this object.
     */
    public final RepromptResponse repromptResponse() {
        return repromptResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseLookupOutput());
        hashCode = 31 * hashCode + Objects.hashCode(finalResponse());
        hashCode = 31 * hashCode + Objects.hashCode(repromptResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation) obj;
        return Objects.equals(traceId(), other.traceId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(actionGroupInvocationOutput(), other.actionGroupInvocationOutput())
                && Objects.equals(knowledgeBaseLookupOutput(), other.knowledgeBaseLookupOutput())
                && Objects.equals(finalResponse(), other.finalResponse())
                && Objects.equals(repromptResponse(), other.repromptResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Observation").add("TraceId", traceId()).add("Type", typeAsString())
                .add("ActionGroupInvocationOutput", actionGroupInvocationOutput())
                .add("KnowledgeBaseLookupOutput", knowledgeBaseLookupOutput()).add("FinalResponse", finalResponse())
                .add("RepromptResponse", repromptResponse() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "actionGroupInvocationOutput":
            return Optional.ofNullable(clazz.cast(actionGroupInvocationOutput()));
        case "knowledgeBaseLookupOutput":
            return Optional.ofNullable(clazz.cast(knowledgeBaseLookupOutput()));
        case "finalResponse":
            return Optional.ofNullable(clazz.cast(finalResponse()));
        case "repromptResponse":
            return Optional.ofNullable(clazz.cast(repromptResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Observation> {
        /**
         * Sets the value of the TraceId property for this object.
         *
         * @param traceId
         *        The new value for the TraceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * Sets the value of the ActionGroupInvocationOutput property for this object.
         *
         * @param actionGroupInvocationOutput
         *        The new value for the ActionGroupInvocationOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupInvocationOutput(ActionGroupInvocationOutput actionGroupInvocationOutput);

        /**
         * Sets the value of the ActionGroupInvocationOutput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionGroupInvocationOutput.Builder}
         * avoiding the need to create one manually via {@link ActionGroupInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #actionGroupInvocationOutput(ActionGroupInvocationOutput)}.
         * 
         * @param actionGroupInvocationOutput
         *        a consumer that will call methods on {@link ActionGroupInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupInvocationOutput(ActionGroupInvocationOutput)
         */
        default Builder actionGroupInvocationOutput(Consumer<ActionGroupInvocationOutput.Builder> actionGroupInvocationOutput) {
            return actionGroupInvocationOutput(ActionGroupInvocationOutput.builder().applyMutation(actionGroupInvocationOutput)
                    .build());
        }

        /**
         * Sets the value of the KnowledgeBaseLookupOutput property for this object.
         *
         * @param knowledgeBaseLookupOutput
         *        The new value for the KnowledgeBaseLookupOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput knowledgeBaseLookupOutput);

        /**
         * Sets the value of the KnowledgeBaseLookupOutput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseLookupOutput.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseLookupOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseLookupOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput)}.
         * 
         * @param knowledgeBaseLookupOutput
         *        a consumer that will call methods on {@link KnowledgeBaseLookupOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput)
         */
        default Builder knowledgeBaseLookupOutput(Consumer<KnowledgeBaseLookupOutput.Builder> knowledgeBaseLookupOutput) {
            return knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput.builder().applyMutation(knowledgeBaseLookupOutput).build());
        }

        /**
         * Sets the value of the FinalResponse property for this object.
         *
         * @param finalResponse
         *        The new value for the FinalResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalResponse(FinalResponse finalResponse);

        /**
         * Sets the value of the FinalResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FinalResponse.Builder} avoiding the need
         * to create one manually via {@link FinalResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FinalResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #finalResponse(FinalResponse)}.
         * 
         * @param finalResponse
         *        a consumer that will call methods on {@link FinalResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalResponse(FinalResponse)
         */
        default Builder finalResponse(Consumer<FinalResponse.Builder> finalResponse) {
            return finalResponse(FinalResponse.builder().applyMutation(finalResponse).build());
        }

        /**
         * Sets the value of the RepromptResponse property for this object.
         *
         * @param repromptResponse
         *        The new value for the RepromptResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repromptResponse(RepromptResponse repromptResponse);

        /**
         * Sets the value of the RepromptResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RepromptResponse.Builder} avoiding the
         * need to create one manually via {@link RepromptResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepromptResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #repromptResponse(RepromptResponse)}.
         * 
         * @param repromptResponse
         *        a consumer that will call methods on {@link RepromptResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repromptResponse(RepromptResponse)
         */
        default Builder repromptResponse(Consumer<RepromptResponse.Builder> repromptResponse) {
            return repromptResponse(RepromptResponse.builder().applyMutation(repromptResponse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String traceId;

        private String type;

        private ActionGroupInvocationOutput actionGroupInvocationOutput;

        private KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;

        private FinalResponse finalResponse;

        private RepromptResponse repromptResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            traceId(model.traceId);
            type(model.type);
            actionGroupInvocationOutput(model.actionGroupInvocationOutput);
            knowledgeBaseLookupOutput(model.knowledgeBaseLookupOutput);
            finalResponse(model.finalResponse);
            repromptResponse(model.repromptResponse);
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ActionGroupInvocationOutput.Builder getActionGroupInvocationOutput() {
            return actionGroupInvocationOutput != null ? actionGroupInvocationOutput.toBuilder() : null;
        }

        public final void setActionGroupInvocationOutput(ActionGroupInvocationOutput.BuilderImpl actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput != null ? actionGroupInvocationOutput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationOutput(ActionGroupInvocationOutput actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput;
            return this;
        }

        public final KnowledgeBaseLookupOutput.Builder getKnowledgeBaseLookupOutput() {
            return knowledgeBaseLookupOutput != null ? knowledgeBaseLookupOutput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupOutput(KnowledgeBaseLookupOutput.BuilderImpl knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput != null ? knowledgeBaseLookupOutput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput;
            return this;
        }

        public final FinalResponse.Builder getFinalResponse() {
            return finalResponse != null ? finalResponse.toBuilder() : null;
        }

        public final void setFinalResponse(FinalResponse.BuilderImpl finalResponse) {
            this.finalResponse = finalResponse != null ? finalResponse.build() : null;
        }

        @Override
        public final Builder finalResponse(FinalResponse finalResponse) {
            this.finalResponse = finalResponse;
            return this;
        }

        public final RepromptResponse.Builder getRepromptResponse() {
            return repromptResponse != null ? repromptResponse.toBuilder() : null;
        }

        public final void setRepromptResponse(RepromptResponse.BuilderImpl repromptResponse) {
            this.repromptResponse = repromptResponse != null ? repromptResponse.build() : null;
        }

        @Override
        public final Builder repromptResponse(RepromptResponse repromptResponse) {
            this.repromptResponse = repromptResponse;
            return this;
        }

        @Override
        public Observation build() {
            return new Observation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
