/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result item returned from a knowledge base retrieval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseRetrievalResult implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseRetrievalResult.Builder, KnowledgeBaseRetrievalResult> {
    private static final SdkField<RetrievalResultContent> CONTENT_FIELD = SdkField
            .<RetrievalResultContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(KnowledgeBaseRetrievalResult::content)).setter(setter(Builder::content))
            .constructor(RetrievalResultContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<RetrievalResultLocation> LOCATION_FIELD = SdkField
            .<RetrievalResultLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(KnowledgeBaseRetrievalResult::location)).setter(setter(Builder::location))
            .constructor(RetrievalResultLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(KnowledgeBaseRetrievalResult::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, LOCATION_FIELD,
            SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final RetrievalResultContent content;

    private final RetrievalResultLocation location;

    private final Double score;

    private KnowledgeBaseRetrievalResult(BuilderImpl builder) {
        this.content = builder.content;
        this.location = builder.location;
        this.score = builder.score;
    }

    /**
     * Returns the value of the Content property for this object.
     * 
     * @return The value of the Content property for this object.
     */
    public final RetrievalResultContent content() {
        return content;
    }

    /**
     * Returns the value of the Location property for this object.
     * 
     * @return The value of the Location property for this object.
     */
    public final RetrievalResultLocation location() {
        return location;
    }

    /**
     * <p>
     * The relevance score of a result.
     * </p>
     * 
     * @return The relevance score of a result.
     */
    public final Double score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrievalResult)) {
            return false;
        }
        KnowledgeBaseRetrievalResult other = (KnowledgeBaseRetrievalResult) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(location(), other.location())
                && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseRetrievalResult").add("Content", content()).add("Location", location())
                .add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrievalResult, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrievalResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseRetrievalResult> {
        /**
         * Sets the value of the Content property for this object.
         *
         * @param content
         *        The new value for the Content property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(RetrievalResultContent content);

        /**
         * Sets the value of the Content property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrievalResultContent.Builder} avoiding
         * the need to create one manually via {@link RetrievalResultContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultContent.Builder#build()} is called immediately and
         * its result is passed to {@link #content(RetrievalResultContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link RetrievalResultContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(RetrievalResultContent)
         */
        default Builder content(Consumer<RetrievalResultContent.Builder> content) {
            return content(RetrievalResultContent.builder().applyMutation(content).build());
        }

        /**
         * Sets the value of the Location property for this object.
         *
         * @param location
         *        The new value for the Location property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(RetrievalResultLocation location);

        /**
         * Sets the value of the Location property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrievalResultLocation.Builder} avoiding
         * the need to create one manually via {@link RetrievalResultLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #location(RetrievalResultLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link RetrievalResultLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(RetrievalResultLocation)
         */
        default Builder location(Consumer<RetrievalResultLocation.Builder> location) {
            return location(RetrievalResultLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The relevance score of a result.
         * </p>
         * 
         * @param score
         *        The relevance score of a result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);
    }

    static final class BuilderImpl implements Builder {
        private RetrievalResultContent content;

        private RetrievalResultLocation location;

        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrievalResult model) {
            content(model.content);
            location(model.location);
            score(model.score);
        }

        public final RetrievalResultContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(RetrievalResultContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RetrievalResultContent content) {
            this.content = content;
            return this;
        }

        public final RetrievalResultLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(RetrievalResultLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(RetrievalResultLocation location) {
            this.location = location;
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        @Override
        public KnowledgeBaseRetrievalResult build() {
            return new KnowledgeBaseRetrievalResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
