/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Generate response part
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedResponsePart implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedResponsePart.Builder, GeneratedResponsePart> {
    private static final SdkField<TextResponsePart> TEXT_RESPONSE_PART_FIELD = SdkField
            .<TextResponsePart> builder(MarshallingType.SDK_POJO).memberName("textResponsePart")
            .getter(getter(GeneratedResponsePart::textResponsePart)).setter(setter(Builder::textResponsePart))
            .constructor(TextResponsePart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textResponsePart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_RESPONSE_PART_FIELD));

    private static final long serialVersionUID = 1L;

    private final TextResponsePart textResponsePart;

    private GeneratedResponsePart(BuilderImpl builder) {
        this.textResponsePart = builder.textResponsePart;
    }

    /**
     * Returns the value of the TextResponsePart property for this object.
     * 
     * @return The value of the TextResponsePart property for this object.
     */
    public final TextResponsePart textResponsePart() {
        return textResponsePart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textResponsePart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedResponsePart)) {
            return false;
        }
        GeneratedResponsePart other = (GeneratedResponsePart) obj;
        return Objects.equals(textResponsePart(), other.textResponsePart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedResponsePart").add("TextResponsePart", textResponsePart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textResponsePart":
            return Optional.ofNullable(clazz.cast(textResponsePart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedResponsePart, T> g) {
        return obj -> g.apply((GeneratedResponsePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedResponsePart> {
        /**
         * Sets the value of the TextResponsePart property for this object.
         *
         * @param textResponsePart
         *        The new value for the TextResponsePart property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textResponsePart(TextResponsePart textResponsePart);

        /**
         * Sets the value of the TextResponsePart property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TextResponsePart.Builder} avoiding the
         * need to create one manually via {@link TextResponsePart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextResponsePart.Builder#build()} is called immediately and its
         * result is passed to {@link #textResponsePart(TextResponsePart)}.
         * 
         * @param textResponsePart
         *        a consumer that will call methods on {@link TextResponsePart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textResponsePart(TextResponsePart)
         */
        default Builder textResponsePart(Consumer<TextResponsePart.Builder> textResponsePart) {
            return textResponsePart(TextResponsePart.builder().applyMutation(textResponsePart).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextResponsePart textResponsePart;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedResponsePart model) {
            textResponsePart(model.textResponsePart);
        }

        public final TextResponsePart.Builder getTextResponsePart() {
            return textResponsePart != null ? textResponsePart.toBuilder() : null;
        }

        public final void setTextResponsePart(TextResponsePart.BuilderImpl textResponsePart) {
            this.textResponsePart = textResponsePart != null ? textResponsePart.build() : null;
        }

        @Override
        public final Builder textResponsePart(TextResponsePart textResponsePart) {
            this.textResponsePart = textResponsePart;
            return this;
        }

        @Override
        public GeneratedResponsePart build() {
            return new GeneratedResponsePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
