/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher;

/**
 * Service client for accessing Agents for Amazon Bedrock Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Bedrock Agent
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent-runtime";

    /**
     * <p>
     * Invokes the specified Bedrock model to run inference using the input provided in the request body.
     * </p>
     *
     * @param invokeAgentRequest
     *        InvokeAgent Request
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(InvokeAgentRequest invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes the specified Bedrock model to run inference using the input provided in the request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeAgentRequest#builder()}
     * </p>
     *
     * @param invokeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest.Builder} to create a
     *        request. InvokeAgent Request
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(Consumer<InvokeAgentRequest.Builder> invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        return invokeAgent(InvokeAgentRequest.builder().applyMutation(invokeAgentRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Retrieve from knowledge base.
     * </p>
     *
     * @param retrieveRequest
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(RetrieveRequest retrieveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve from knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrieve(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * RetrieveAndGenerate API
     * </p>
     *
     * @param retrieveAndGenerateRequest
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            RetrieveAndGenerateRequest retrieveAndGenerateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * RetrieveAndGenerate API
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveAndGenerateRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            Consumer<RetrieveAndGenerateRequest.Builder> retrieveAndGenerateRequest) {
        return retrieveAndGenerate(RetrieveAndGenerateRequest.builder().applyMutation(retrieveAndGenerateRequest).build());
    }

    /**
     * <p>
     * Retrieve from knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     *
     * @param retrieveRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(RetrieveRequest retrieveRequest) {
        return new RetrievePublisher(this, retrieveRequest);
    }

    /**
     * <p>
     * Retrieve from knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>DependencyFailedException This exception is thrown when a request fails due to dependency like
     *         Lambda, Bedrock, STS resource due to a customer fault (i.e. bad configuration)</li>
     *         <li>BadGatewayException This exception is thrown when a request fails due to dependency like Lambda,
     *         Bedrock, STS resource</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrievePaginator(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    @Override
    default BedrockAgentRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentRuntimeAsyncClient}.
     */
    static BedrockAgentRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockAgentRuntimeAsyncClientBuilder();
    }
}
