/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasConcurrencyConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowAliasSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowAliasSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FlowAliasSummary.getter(FlowAliasSummary::name)).setter(FlowAliasSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(FlowAliasSummary.getter(FlowAliasSummary::description)).setter(FlowAliasSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(FlowAliasSummary.getter(FlowAliasSummary::routingConfiguration)).setter(FlowAliasSummary.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FlowAliasConcurrencyConfiguration> CONCURRENCY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("concurrencyConfiguration").getter(FlowAliasSummary.getter(FlowAliasSummary::concurrencyConfiguration)).setter(FlowAliasSummary.setter(Builder::concurrencyConfiguration)).constructor(FlowAliasConcurrencyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrencyConfiguration").build()}).build();
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowId").getter(FlowAliasSummary.getter(FlowAliasSummary::flowId)).setter(FlowAliasSummary.setter(Builder::flowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FlowAliasSummary.getter(FlowAliasSummary::id)).setter(FlowAliasSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(FlowAliasSummary.getter(FlowAliasSummary::arn)).setter(FlowAliasSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FlowAliasSummary.getter(FlowAliasSummary::createdAt)).setter(FlowAliasSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(FlowAliasSummary.getter(FlowAliasSummary::updatedAt)).setter(FlowAliasSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, CONCURRENCY_CONFIGURATION_FIELD, FLOW_ID_FIELD, ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowAliasSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;
    private final FlowAliasConcurrencyConfiguration concurrencyConfiguration;
    private final String flowId;
    private final String id;
    private final String arn;
    private final Instant createdAt;
    private final Instant updatedAt;

    private FlowAliasSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.concurrencyConfiguration = builder.concurrencyConfiguration;
        this.flowId = builder.flowId;
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final FlowAliasConcurrencyConfiguration concurrencyConfiguration() {
        return this.concurrencyConfiguration;
    }

    public final String flowId() {
        return this.flowId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrencyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowAliasSummary)) {
            return false;
        }
        FlowAliasSummary other = (FlowAliasSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && Objects.equals(this.concurrencyConfiguration(), other.concurrencyConfiguration()) && Objects.equals(this.flowId(), other.flowId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FlowAliasSummary").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("ConcurrencyConfiguration", (Object)this.concurrencyConfiguration()).add("FlowId", (Object)this.flowId()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "concurrencyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.concurrencyConfiguration()));
            }
            case "flowId": {
                return Optional.ofNullable(clazz.cast(this.flowId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("concurrencyConfiguration", CONCURRENCY_CONFIGURATION_FIELD);
        map.put("flowId", FLOW_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowAliasSummary, T> g) {
        return obj -> g.apply((FlowAliasSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private FlowAliasConcurrencyConfiguration concurrencyConfiguration;
        private String flowId;
        private String id;
        private String arn;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowAliasSummary model) {
            this.name(model.name);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
            this.concurrencyConfiguration(model.concurrencyConfiguration);
            this.flowId(model.flowId);
            this.id(model.id);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (FlowAliasRoutingConfigurationListItem)((FlowAliasRoutingConfigurationListItem.Builder)FlowAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FlowAliasConcurrencyConfiguration.Builder getConcurrencyConfiguration() {
            return this.concurrencyConfiguration != null ? this.concurrencyConfiguration.toBuilder() : null;
        }

        public final void setConcurrencyConfiguration(FlowAliasConcurrencyConfiguration.BuilderImpl concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration != null ? concurrencyConfiguration.build() : null;
        }

        @Override
        public final Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration;
            return this;
        }

        public final String getFlowId() {
            return this.flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public FlowAliasSummary build() {
            return new FlowAliasSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowAliasSummary> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration var1);

        default public Builder concurrencyConfiguration(Consumer<FlowAliasConcurrencyConfiguration.Builder> concurrencyConfiguration) {
            return this.concurrencyConfiguration((FlowAliasConcurrencyConfiguration)((FlowAliasConcurrencyConfiguration.Builder)FlowAliasConcurrencyConfiguration.builder().applyMutation(concurrencyConfiguration)).build());
        }

        public Builder flowId(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

