/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateAgentRequest.Builder, UpdateAgentRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(UpdateAgentRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(UpdateAgentRequest::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(UpdateAgentRequest::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModel").getter(getter(UpdateAgentRequest::foundationModel))
            .setter(setter(Builder::foundationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAgentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ORCHESTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestrationType").getter(getter(UpdateAgentRequest::orchestrationTypeAsString))
            .setter(setter(Builder::orchestrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationType").build()).build();

    private static final SdkField<CustomOrchestration> CUSTOM_ORCHESTRATION_FIELD = SdkField
            .<CustomOrchestration> builder(MarshallingType.SDK_POJO).memberName("customOrchestration")
            .getter(getter(UpdateAgentRequest::customOrchestration)).setter(setter(Builder::customOrchestration))
            .constructor(CustomOrchestration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOrchestration").build())
            .build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(UpdateAgentRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> AGENT_RESOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentResourceRoleArn").getter(getter(UpdateAgentRequest::agentResourceRoleArn))
            .setter(setter(Builder::agentResourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentResourceRoleArn").build())
            .build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(UpdateAgentRequest::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<PromptOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("promptOverrideConfiguration")
            .getter(getter(UpdateAgentRequest::promptOverrideConfiguration))
            .setter(setter(Builder::promptOverrideConfiguration))
            .constructor(PromptOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration")
                    .build()).build();

    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(UpdateAgentRequest::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<MemoryConfiguration> MEMORY_CONFIGURATION_FIELD = SdkField
            .<MemoryConfiguration> builder(MarshallingType.SDK_POJO).memberName("memoryConfiguration")
            .getter(getter(UpdateAgentRequest::memoryConfiguration)).setter(setter(Builder::memoryConfiguration))
            .constructor(MemoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryConfiguration").build())
            .build();

    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboration").getter(getter(UpdateAgentRequest::agentCollaborationAsString))
            .setter(setter(Builder::agentCollaboration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_NAME_FIELD, INSTRUCTION_FIELD, FOUNDATION_MODEL_FIELD, DESCRIPTION_FIELD, ORCHESTRATION_TYPE_FIELD,
            CUSTOM_ORCHESTRATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, AGENT_RESOURCE_ROLE_ARN_FIELD,
            CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, GUARDRAIL_CONFIGURATION_FIELD,
            MEMORY_CONFIGURATION_FIELD, AGENT_COLLABORATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String agentName;

    private final String instruction;

    private final String foundationModel;

    private final String description;

    private final String orchestrationType;

    private final CustomOrchestration customOrchestration;

    private final Integer idleSessionTTLInSeconds;

    private final String agentResourceRoleArn;

    private final String customerEncryptionKeyArn;

    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private final GuardrailConfiguration guardrailConfiguration;

    private final MemoryConfiguration memoryConfiguration;

    private final String agentCollaboration;

    private UpdateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.instruction = builder.instruction;
        this.foundationModel = builder.foundationModel;
        this.description = builder.description;
        this.orchestrationType = builder.orchestrationType;
        this.customOrchestration = builder.customOrchestration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.agentResourceRoleArn = builder.agentResourceRoleArn;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.memoryConfiguration = builder.memoryConfiguration;
        this.agentCollaboration = builder.agentCollaboration;
    }

    /**
     * <p>
     * The unique identifier of the agent.
     * </p>
     * 
     * @return The unique identifier of the agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Specifies a new name for the agent.
     * </p>
     * 
     * @return Specifies a new name for the agent.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * <p>
     * Specifies new instructions that tell the agent what it should do and how it should interact with users.
     * </p>
     * 
     * @return Specifies new instructions that tell the agent what it should do and how it should interact with users.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * <p>
     * The identifier for the model that you want to be used for orchestration by the agent you create.
     * </p>
     * <p>
     * The <code>modelId</code> to provide depends on the type of model or throughput that you use:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
     * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile
     * IDs, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions
     * and models for cross-region inference</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned
     * Throughput</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting
     * provisioned model. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in
     * Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
     * model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html"
     * >CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the model that you want to be used for orchestration by the agent you create.</p>
     *         <p>
     *         The <code>modelId</code> to provide depends on the type of model or throughput that you use:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock
     *         base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference
     *         profile IDs, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported
     *         Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
     *         Provisioned Throughput</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
     *         resulting provisioned model. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
     *         model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
     *         >imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful
     *         call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">
     *         CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
     *         </p>
     *         </li>
     */
    public final String foundationModel() {
        return foundationModel;
    }

    /**
     * <p>
     * Specifies a new description of the agent.
     * </p>
     * 
     * @return Specifies a new description of the agent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code> orchestration
     * type, by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrationType}
     * will return {@link OrchestrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestrationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code>
     *         orchestration type, by default.
     * @see OrchestrationType
     */
    public final OrchestrationType orchestrationType() {
        return OrchestrationType.fromValue(orchestrationType);
    }

    /**
     * <p>
     * Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code> orchestration
     * type, by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrationType}
     * will return {@link OrchestrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestrationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code>
     *         orchestration type, by default.
     * @see OrchestrationType
     */
    public final String orchestrationTypeAsString() {
        return orchestrationType;
    }

    /**
     * <p>
     * Contains details of the custom orchestration configured for the agent.
     * </p>
     * 
     * @return Contains details of the custom orchestration configured for the agent.
     */
    public final CustomOrchestration customOrchestration() {
        return customOrchestration;
    }

    /**
     * <p>
     * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Bedrock deletes any data provided before the timeout.
     * </p>
     * 
     * @return The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the
     *         agent.</p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
     */
    public final String agentResourceRoleArn() {
        return agentResourceRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * Contains configurations to override prompts in different parts of an agent sequence. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * 
     * @return Contains configurations to override prompts in different parts of an agent sequence. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     */
    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return promptOverrideConfiguration;
    }

    /**
     * <p>
     * The unique Guardrail configuration assigned to the agent when it is updated.
     * </p>
     * 
     * @return The unique Guardrail configuration assigned to the agent when it is updated.
     */
    public final GuardrailConfiguration guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * Specifies the new memory configuration for the agent.
     * </p>
     * 
     * @return Specifies the new memory configuration for the agent.
     */
    public final MemoryConfiguration memoryConfiguration() {
        return memoryConfiguration;
    }

    /**
     * <p>
     * The agent's collaboration role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return The agent's collaboration role.
     * @see AgentCollaboration
     */
    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(agentCollaboration);
    }

    /**
     * <p>
     * The agent's collaboration role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return The agent's collaboration role.
     * @see AgentCollaboration
     */
    public final String agentCollaborationAsString() {
        return agentCollaboration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customOrchestration());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(agentResourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(memoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaborationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRequest)) {
            return false;
        }
        UpdateAgentRequest other = (UpdateAgentRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentName(), other.agentName())
                && Objects.equals(instruction(), other.instruction())
                && Objects.equals(foundationModel(), other.foundationModel())
                && Objects.equals(description(), other.description())
                && Objects.equals(orchestrationTypeAsString(), other.orchestrationTypeAsString())
                && Objects.equals(customOrchestration(), other.customOrchestration())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(agentResourceRoleArn(), other.agentResourceRoleArn())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(promptOverrideConfiguration(), other.promptOverrideConfiguration())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(memoryConfiguration(), other.memoryConfiguration())
                && Objects.equals(agentCollaborationAsString(), other.agentCollaborationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAgentRequest")
                .add("AgentId", agentId())
                .add("AgentName", agentName())
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FoundationModel", foundationModel())
                .add("Description", description())
                .add("OrchestrationType", orchestrationTypeAsString())
                .add("CustomOrchestration", customOrchestration())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("AgentResourceRoleArn", agentResourceRoleArn())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("PromptOverrideConfiguration",
                        promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GuardrailConfiguration", guardrailConfiguration()).add("MemoryConfiguration", memoryConfiguration())
                .add("AgentCollaboration", agentCollaborationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "foundationModel":
            return Optional.ofNullable(clazz.cast(foundationModel()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "orchestrationType":
            return Optional.ofNullable(clazz.cast(orchestrationTypeAsString()));
        case "customOrchestration":
            return Optional.ofNullable(clazz.cast(customOrchestration()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "agentResourceRoleArn":
            return Optional.ofNullable(clazz.cast(agentResourceRoleArn()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "promptOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(promptOverrideConfiguration()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "memoryConfiguration":
            return Optional.ofNullable(clazz.cast(memoryConfiguration()));
        case "agentCollaboration":
            return Optional.ofNullable(clazz.cast(agentCollaborationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("orchestrationType", ORCHESTRATION_TYPE_FIELD);
        map.put("customOrchestration", CUSTOM_ORCHESTRATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("agentResourceRoleArn", AGENT_RESOURCE_ROLE_ARN_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("memoryConfiguration", MEMORY_CONFIGURATION_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRequest, T> g) {
        return obj -> g.apply((UpdateAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentRequest> {
        /**
         * <p>
         * The unique identifier of the agent.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Specifies a new name for the agent.
         * </p>
         * 
         * @param agentName
         *        Specifies a new name for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * Specifies new instructions that tell the agent what it should do and how it should interact with users.
         * </p>
         * 
         * @param instruction
         *        Specifies new instructions that tell the agent what it should do and how it should interact with
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * The identifier for the model that you want to be used for orchestration by the agent you create.
         * </p>
         * <p>
         * The <code>modelId</code> to provide depends on the type of model or throughput that you use:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
         * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile
         * IDs, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported
         * Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
         * Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         * resulting provisioned model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model
         * in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
         * model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a
         * href=
         * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob
         * </a> or from the Imported models page in the Amazon Bedrock console.
         * </p>
         * </li>
         * </ul>
         * 
         * @param foundationModel
         *        The identifier for the model that you want to be used for orchestration by the agent you create.</p>
         *        <p>
         *        The <code>modelId</code> to provide depends on the type of model or throughput that you use:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon
         *        Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference
         *        profile IDs, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html"
         *        >Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information,
         *        see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference
         *        using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         *        resulting provisioned model. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
         *        model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
         *        >imported model</a>, specify the ARN of the imported model. You can get the model ARN from a
         *        successful call to <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html"
         *        >CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModel(String foundationModel);

        /**
         * <p>
         * Specifies a new description of the agent.
         * </p>
         * 
         * @param description
         *        Specifies a new description of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code> orchestration
         * type, by default.
         * </p>
         * 
         * @param orchestrationType
         *        Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code>
         *        orchestration type, by default.
         * @see OrchestrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationType
         */
        Builder orchestrationType(String orchestrationType);

        /**
         * <p>
         * Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code> orchestration
         * type, by default.
         * </p>
         * 
         * @param orchestrationType
         *        Specifies the type of orchestration strategy for the agent. This is set to <code>DEFAULT</code>
         *        orchestration type, by default.
         * @see OrchestrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationType
         */
        Builder orchestrationType(OrchestrationType orchestrationType);

        /**
         * <p>
         * Contains details of the custom orchestration configured for the agent.
         * </p>
         * 
         * @param customOrchestration
         *        Contains details of the custom orchestration configured for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOrchestration(CustomOrchestration customOrchestration);

        /**
         * <p>
         * Contains details of the custom orchestration configured for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomOrchestration.Builder} avoiding the
         * need to create one manually via {@link CustomOrchestration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOrchestration.Builder#build()} is called immediately and
         * its result is passed to {@link #customOrchestration(CustomOrchestration)}.
         * 
         * @param customOrchestration
         *        a consumer that will call methods on {@link CustomOrchestration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOrchestration(CustomOrchestration)
         */
        default Builder customOrchestration(Consumer<CustomOrchestration.Builder> customOrchestration) {
            return customOrchestration(CustomOrchestration.builder().applyMutation(customOrchestration).build());
        }

        /**
         * <p>
         * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the
         *        agent.</p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
         * </p>
         * 
         * @param agentResourceRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentResourceRoleArn(String agentResourceRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * Contains configurations to override prompts in different parts of an agent sequence. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         * prompts</a>.
         * </p>
         * 
         * @param promptOverrideConfiguration
         *        Contains configurations to override prompts in different parts of an agent sequence. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         *        prompts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration);

        /**
         * <p>
         * Contains configurations to override prompts in different parts of an agent sequence. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         * prompts</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptOverrideConfiguration(PromptOverrideConfiguration)}.
         * 
         * @param promptOverrideConfiguration
         *        a consumer that will call methods on {@link PromptOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptOverrideConfiguration(PromptOverrideConfiguration)
         */
        default Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return promptOverrideConfiguration(PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique Guardrail configuration assigned to the agent when it is updated.
         * </p>
         * 
         * @param guardrailConfiguration
         *        The unique Guardrail configuration assigned to the agent when it is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration);

        /**
         * <p>
         * The unique Guardrail configuration assigned to the agent when it is updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfiguration.Builder} avoiding
         * the need to create one manually via {@link GuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #guardrailConfiguration(GuardrailConfiguration)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfiguration)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfiguration.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * Specifies the new memory configuration for the agent.
         * </p>
         * 
         * @param memoryConfiguration
         *        Specifies the new memory configuration for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryConfiguration(MemoryConfiguration memoryConfiguration);

        /**
         * <p>
         * Specifies the new memory configuration for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemoryConfiguration.Builder} avoiding the
         * need to create one manually via {@link MemoryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemoryConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #memoryConfiguration(MemoryConfiguration)}.
         * 
         * @param memoryConfiguration
         *        a consumer that will call methods on {@link MemoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryConfiguration(MemoryConfiguration)
         */
        default Builder memoryConfiguration(Consumer<MemoryConfiguration.Builder> memoryConfiguration) {
            return memoryConfiguration(MemoryConfiguration.builder().applyMutation(memoryConfiguration).build());
        }

        /**
         * <p>
         * The agent's collaboration role.
         * </p>
         * 
         * @param agentCollaboration
         *        The agent's collaboration role.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(String agentCollaboration);

        /**
         * <p>
         * The agent's collaboration role.
         * </p>
         * 
         * @param agentCollaboration
         *        The agent's collaboration role.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(AgentCollaboration agentCollaboration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentName;

        private String instruction;

        private String foundationModel;

        private String description;

        private String orchestrationType;

        private CustomOrchestration customOrchestration;

        private Integer idleSessionTTLInSeconds;

        private String agentResourceRoleArn;

        private String customerEncryptionKeyArn;

        private PromptOverrideConfiguration promptOverrideConfiguration;

        private GuardrailConfiguration guardrailConfiguration;

        private MemoryConfiguration memoryConfiguration;

        private String agentCollaboration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRequest model) {
            super(model);
            agentId(model.agentId);
            agentName(model.agentName);
            instruction(model.instruction);
            foundationModel(model.foundationModel);
            description(model.description);
            orchestrationType(model.orchestrationType);
            customOrchestration(model.customOrchestration);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            agentResourceRoleArn(model.agentResourceRoleArn);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            promptOverrideConfiguration(model.promptOverrideConfiguration);
            guardrailConfiguration(model.guardrailConfiguration);
            memoryConfiguration(model.memoryConfiguration);
            agentCollaboration(model.agentCollaboration);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final String getFoundationModel() {
            return foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOrchestrationType() {
            return orchestrationType;
        }

        public final void setOrchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
        }

        @Override
        public final Builder orchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
            return this;
        }

        @Override
        public final Builder orchestrationType(OrchestrationType orchestrationType) {
            this.orchestrationType(orchestrationType == null ? null : orchestrationType.toString());
            return this;
        }

        public final CustomOrchestration.Builder getCustomOrchestration() {
            return customOrchestration != null ? customOrchestration.toBuilder() : null;
        }

        public final void setCustomOrchestration(CustomOrchestration.BuilderImpl customOrchestration) {
            this.customOrchestration = customOrchestration != null ? customOrchestration.build() : null;
        }

        @Override
        public final Builder customOrchestration(CustomOrchestration customOrchestration) {
            this.customOrchestration = customOrchestration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getAgentResourceRoleArn() {
            return agentResourceRoleArn;
        }

        public final void setAgentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
        }

        @Override
        public final Builder agentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return promptOverrideConfiguration != null ? promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final MemoryConfiguration.Builder getMemoryConfiguration() {
            return memoryConfiguration != null ? memoryConfiguration.toBuilder() : null;
        }

        public final void setMemoryConfiguration(MemoryConfiguration.BuilderImpl memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration != null ? memoryConfiguration.build() : null;
        }

        @Override
        public final Builder memoryConfiguration(MemoryConfiguration memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration;
            return this;
        }

        public final String getAgentCollaboration() {
            return agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentRequest build() {
            return new UpdateAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
