/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information to connect to Salesforce as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceDataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceDataSourceConfiguration.Builder, SalesforceDataSourceConfiguration> {
    private static final SdkField<SalesforceSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SalesforceSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(SalesforceDataSourceConfiguration::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SalesforceSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final SdkField<SalesforceCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField
            .<SalesforceCrawlerConfiguration> builder(MarshallingType.SDK_POJO).memberName("crawlerConfiguration")
            .getter(getter(SalesforceDataSourceConfiguration::crawlerConfiguration))
            .setter(setter(Builder::crawlerConfiguration)).constructor(SalesforceCrawlerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONFIGURATION_FIELD,
            CRAWLER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SalesforceSourceConfiguration sourceConfiguration;

    private final SalesforceCrawlerConfiguration crawlerConfiguration;

    private SalesforceDataSourceConfiguration(BuilderImpl builder) {
        this.sourceConfiguration = builder.sourceConfiguration;
        this.crawlerConfiguration = builder.crawlerConfiguration;
    }

    /**
     * <p>
     * The endpoint information to connect to your Salesforce data source.
     * </p>
     * 
     * @return The endpoint information to connect to your Salesforce data source.
     */
    public final SalesforceSourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
     * </p>
     * 
     * @return The configuration of the Salesforce content. For example, configuring specific types of Salesforce
     *         content.
     */
    public final SalesforceCrawlerConfiguration crawlerConfiguration() {
        return crawlerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceDataSourceConfiguration)) {
            return false;
        }
        SalesforceDataSourceConfiguration other = (SalesforceDataSourceConfiguration) obj;
        return Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(crawlerConfiguration(), other.crawlerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceDataSourceConfiguration").add("SourceConfiguration", sourceConfiguration())
                .add("CrawlerConfiguration", crawlerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "crawlerConfiguration":
            return Optional.ofNullable(clazz.cast(crawlerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        map.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SalesforceDataSourceConfiguration, T> g) {
        return obj -> g.apply((SalesforceDataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceDataSourceConfiguration> {
        /**
         * <p>
         * The endpoint information to connect to your Salesforce data source.
         * </p>
         * 
         * @param sourceConfiguration
         *        The endpoint information to connect to your Salesforce data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SalesforceSourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The endpoint information to connect to your Salesforce data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SalesforceSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link SalesforceSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceConfiguration(SalesforceSourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SalesforceSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SalesforceSourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SalesforceSourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SalesforceSourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
         * </p>
         * 
         * @param crawlerConfiguration
         *        The configuration of the Salesforce content. For example, configuring specific types of Salesforce
         *        content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerConfiguration(SalesforceCrawlerConfiguration crawlerConfiguration);

        /**
         * <p>
         * The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
         * </p>
         * This is a convenience method that creates an instance of the {@link SalesforceCrawlerConfiguration.Builder}
         * avoiding the need to create one manually via {@link SalesforceCrawlerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceCrawlerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #crawlerConfiguration(SalesforceCrawlerConfiguration)}.
         * 
         * @param crawlerConfiguration
         *        a consumer that will call methods on {@link SalesforceCrawlerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlerConfiguration(SalesforceCrawlerConfiguration)
         */
        default Builder crawlerConfiguration(Consumer<SalesforceCrawlerConfiguration.Builder> crawlerConfiguration) {
            return crawlerConfiguration(SalesforceCrawlerConfiguration.builder().applyMutation(crawlerConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SalesforceSourceConfiguration sourceConfiguration;

        private SalesforceCrawlerConfiguration crawlerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceDataSourceConfiguration model) {
            sourceConfiguration(model.sourceConfiguration);
            crawlerConfiguration(model.crawlerConfiguration);
        }

        public final SalesforceSourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SalesforceSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SalesforceSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final SalesforceCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return crawlerConfiguration != null ? crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(SalesforceCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(SalesforceCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        @Override
        public SalesforceDataSourceConfiguration build() {
            return new SalesforceDataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
