/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for an Amazon Redshift database. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge
 * base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftConfiguration.Builder, RedshiftConfiguration> {
    private static final SdkField<List<RedshiftQueryEngineStorageConfiguration>> STORAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<RedshiftQueryEngineStorageConfiguration>> builder(MarshallingType.LIST)
            .memberName("storageConfigurations")
            .getter(getter(RedshiftConfiguration::storageConfigurations))
            .setter(setter(Builder::storageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RedshiftQueryEngineStorageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RedshiftQueryEngineStorageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RedshiftQueryEngineConfiguration> QUERY_ENGINE_CONFIGURATION_FIELD = SdkField
            .<RedshiftQueryEngineConfiguration> builder(MarshallingType.SDK_POJO).memberName("queryEngineConfiguration")
            .getter(getter(RedshiftConfiguration::queryEngineConfiguration)).setter(setter(Builder::queryEngineConfiguration))
            .constructor(RedshiftQueryEngineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEngineConfiguration").build())
            .build();

    private static final SdkField<QueryGenerationConfiguration> QUERY_GENERATION_CONFIGURATION_FIELD = SdkField
            .<QueryGenerationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("queryGenerationConfiguration")
            .getter(getter(RedshiftConfiguration::queryGenerationConfiguration))
            .setter(setter(Builder::queryGenerationConfiguration))
            .constructor(QueryGenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryGenerationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATIONS_FIELD,
            QUERY_ENGINE_CONFIGURATION_FIELD, QUERY_GENERATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RedshiftQueryEngineStorageConfiguration> storageConfigurations;

    private final RedshiftQueryEngineConfiguration queryEngineConfiguration;

    private final QueryGenerationConfiguration queryGenerationConfiguration;

    private RedshiftConfiguration(BuilderImpl builder) {
        this.storageConfigurations = builder.storageConfigurations;
        this.queryEngineConfiguration = builder.queryEngineConfiguration;
        this.queryGenerationConfiguration = builder.queryGenerationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStorageConfigurations() {
        return storageConfigurations != null && !(storageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies configurations for Amazon Redshift database storage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConfigurations} method.
     * </p>
     * 
     * @return Specifies configurations for Amazon Redshift database storage.
     */
    public final List<RedshiftQueryEngineStorageConfiguration> storageConfigurations() {
        return storageConfigurations;
    }

    /**
     * <p>
     * Specifies configurations for an Amazon Redshift query engine.
     * </p>
     * 
     * @return Specifies configurations for an Amazon Redshift query engine.
     */
    public final RedshiftQueryEngineConfiguration queryEngineConfiguration() {
        return queryEngineConfiguration;
    }

    /**
     * <p>
     * Specifies configurations for generating queries.
     * </p>
     * 
     * @return Specifies configurations for generating queries.
     */
    public final QueryGenerationConfiguration queryGenerationConfiguration() {
        return queryGenerationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConfigurations() ? storageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryEngineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(queryGenerationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConfiguration)) {
            return false;
        }
        RedshiftConfiguration other = (RedshiftConfiguration) obj;
        return hasStorageConfigurations() == other.hasStorageConfigurations()
                && Objects.equals(storageConfigurations(), other.storageConfigurations())
                && Objects.equals(queryEngineConfiguration(), other.queryEngineConfiguration())
                && Objects.equals(queryGenerationConfiguration(), other.queryGenerationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftConfiguration")
                .add("StorageConfigurations", hasStorageConfigurations() ? storageConfigurations() : null)
                .add("QueryEngineConfiguration", queryEngineConfiguration())
                .add("QueryGenerationConfiguration", queryGenerationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfigurations":
            return Optional.ofNullable(clazz.cast(storageConfigurations()));
        case "queryEngineConfiguration":
            return Optional.ofNullable(clazz.cast(queryEngineConfiguration()));
        case "queryGenerationConfiguration":
            return Optional.ofNullable(clazz.cast(queryGenerationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageConfigurations", STORAGE_CONFIGURATIONS_FIELD);
        map.put("queryEngineConfiguration", QUERY_ENGINE_CONFIGURATION_FIELD);
        map.put("queryGenerationConfiguration", QUERY_GENERATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConfiguration, T> g) {
        return obj -> g.apply((RedshiftConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftConfiguration> {
        /**
         * <p>
         * Specifies configurations for Amazon Redshift database storage.
         * </p>
         * 
         * @param storageConfigurations
         *        Specifies configurations for Amazon Redshift database storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(Collection<RedshiftQueryEngineStorageConfiguration> storageConfigurations);

        /**
         * <p>
         * Specifies configurations for Amazon Redshift database storage.
         * </p>
         * 
         * @param storageConfigurations
         *        Specifies configurations for Amazon Redshift database storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(RedshiftQueryEngineStorageConfiguration... storageConfigurations);

        /**
         * <p>
         * Specifies configurations for Amazon Redshift database storage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #storageConfigurations(List<RedshiftQueryEngineStorageConfiguration>)}.
         * 
         * @param storageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfigurations(java.util.Collection<RedshiftQueryEngineStorageConfiguration>)
         */
        Builder storageConfigurations(Consumer<RedshiftQueryEngineStorageConfiguration.Builder>... storageConfigurations);

        /**
         * <p>
         * Specifies configurations for an Amazon Redshift query engine.
         * </p>
         * 
         * @param queryEngineConfiguration
         *        Specifies configurations for an Amazon Redshift query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryEngineConfiguration(RedshiftQueryEngineConfiguration queryEngineConfiguration);

        /**
         * <p>
         * Specifies configurations for an Amazon Redshift query engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftQueryEngineConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftQueryEngineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftQueryEngineConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #queryEngineConfiguration(RedshiftQueryEngineConfiguration)}.
         * 
         * @param queryEngineConfiguration
         *        a consumer that will call methods on {@link RedshiftQueryEngineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryEngineConfiguration(RedshiftQueryEngineConfiguration)
         */
        default Builder queryEngineConfiguration(Consumer<RedshiftQueryEngineConfiguration.Builder> queryEngineConfiguration) {
            return queryEngineConfiguration(RedshiftQueryEngineConfiguration.builder().applyMutation(queryEngineConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies configurations for generating queries.
         * </p>
         * 
         * @param queryGenerationConfiguration
         *        Specifies configurations for generating queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryGenerationConfiguration(QueryGenerationConfiguration queryGenerationConfiguration);

        /**
         * <p>
         * Specifies configurations for generating queries.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryGenerationConfiguration.Builder}
         * avoiding the need to create one manually via {@link QueryGenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryGenerationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #queryGenerationConfiguration(QueryGenerationConfiguration)}.
         * 
         * @param queryGenerationConfiguration
         *        a consumer that will call methods on {@link QueryGenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryGenerationConfiguration(QueryGenerationConfiguration)
         */
        default Builder queryGenerationConfiguration(Consumer<QueryGenerationConfiguration.Builder> queryGenerationConfiguration) {
            return queryGenerationConfiguration(QueryGenerationConfiguration.builder()
                    .applyMutation(queryGenerationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RedshiftQueryEngineStorageConfiguration> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private RedshiftQueryEngineConfiguration queryEngineConfiguration;

        private QueryGenerationConfiguration queryGenerationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConfiguration model) {
            storageConfigurations(model.storageConfigurations);
            queryEngineConfiguration(model.queryEngineConfiguration);
            queryGenerationConfiguration(model.queryGenerationConfiguration);
        }

        public final List<RedshiftQueryEngineStorageConfiguration.Builder> getStorageConfigurations() {
            List<RedshiftQueryEngineStorageConfiguration.Builder> result = RedshiftQueryEngineStorageConfigurationsCopier
                    .copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(
                Collection<RedshiftQueryEngineStorageConfiguration.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = RedshiftQueryEngineStorageConfigurationsCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<RedshiftQueryEngineStorageConfiguration> storageConfigurations) {
            this.storageConfigurations = RedshiftQueryEngineStorageConfigurationsCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(RedshiftQueryEngineStorageConfiguration... storageConfigurations) {
            storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(
                Consumer<RedshiftQueryEngineStorageConfiguration.Builder>... storageConfigurations) {
            storageConfigurations(Stream.of(storageConfigurations)
                    .map(c -> RedshiftQueryEngineStorageConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RedshiftQueryEngineConfiguration.Builder getQueryEngineConfiguration() {
            return queryEngineConfiguration != null ? queryEngineConfiguration.toBuilder() : null;
        }

        public final void setQueryEngineConfiguration(RedshiftQueryEngineConfiguration.BuilderImpl queryEngineConfiguration) {
            this.queryEngineConfiguration = queryEngineConfiguration != null ? queryEngineConfiguration.build() : null;
        }

        @Override
        public final Builder queryEngineConfiguration(RedshiftQueryEngineConfiguration queryEngineConfiguration) {
            this.queryEngineConfiguration = queryEngineConfiguration;
            return this;
        }

        public final QueryGenerationConfiguration.Builder getQueryGenerationConfiguration() {
            return queryGenerationConfiguration != null ? queryGenerationConfiguration.toBuilder() : null;
        }

        public final void setQueryGenerationConfiguration(QueryGenerationConfiguration.BuilderImpl queryGenerationConfiguration) {
            this.queryGenerationConfiguration = queryGenerationConfiguration != null ? queryGenerationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder queryGenerationConfiguration(QueryGenerationConfiguration queryGenerationConfiguration) {
            this.queryGenerationConfiguration = queryGenerationConfiguration;
            return this;
        }

        @Override
        public RedshiftConfiguration build() {
            return new RedshiftConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
